/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

class TeamFolderIdListArg {
    @Nonnull
    protected final List<String> teamFolderIds;

    public TeamFolderIdListArg(@Nonnull List<String> teamFolderIds) {
        if (teamFolderIds == null) {
            throw new IllegalArgumentException("Required value for 'teamFolderIds' is null");
        }
        if (teamFolderIds.size() < 1) {
            throw new IllegalArgumentException("List 'teamFolderIds' has fewer than 1 items");
        }
        for (String x : teamFolderIds) {
            if (x == null) {
                throw new IllegalArgumentException("An item in list 'teamFolderIds' is null");
            }
            if (Pattern.matches("[-_0-9a-zA-Z:]+", x)) continue;
            throw new IllegalArgumentException("Stringan item in list 'teamFolderIds' does not match pattern");
        }
        this.teamFolderIds = teamFolderIds;
    }

    @Nonnull
    public List<String> getTeamFolderIds() {
        return this.teamFolderIds;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.teamFolderIds});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamFolderIdListArg other = (TeamFolderIdListArg)obj;
            return this.teamFolderIds == other.teamFolderIds || this.teamFolderIds.equals(other.teamFolderIds);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TeamFolderIdListArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamFolderIdListArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("team_folder_ids");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.teamFolderIds, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TeamFolderIdListArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<String> f_teamFolderIds;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_teamFolderIds = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("team_folder_ids".equals(field)) {
                        f_teamFolderIds = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_teamFolderIds == null) {
                    throw new JsonParseException(p, "Required field \"team_folder_ids\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TeamFolderIdListArg value = new TeamFolderIdListArg(f_teamFolderIds);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

