/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.functions.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobInfo;
import org.apache.flink.api.common.JobInfoImpl;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.externalresource.ExternalResourceInfo;
import org.apache.flink.api.common.functions.BroadcastVariableInitializer;
import org.apache.flink.api.common.functions.util.AbstractRuntimeUDFContext;
import org.apache.flink.core.fs.Path;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.util.SimpleUserCodeClassLoader;

@Internal
public class RuntimeUDFContext
extends AbstractRuntimeUDFContext {
    private final HashMap<String, Object> initializedBroadcastVars = new HashMap();
    private final HashMap<String, List<?>> uninitializedBroadcastVars = new HashMap();

    @VisibleForTesting
    public RuntimeUDFContext(TaskInfo taskInfo, ClassLoader userCodeClassLoader, ExecutionConfig executionConfig, Map<String, Future<Path>> cpTasks, Map<String, Accumulator<?, ?>> accumulators, OperatorMetricGroup metrics) {
        this((JobInfo)new JobInfoImpl(new JobID(), "TestJob"), taskInfo, userCodeClassLoader, executionConfig, cpTasks, accumulators, metrics);
    }

    public RuntimeUDFContext(JobInfo jobInfo, TaskInfo taskInfo, ClassLoader userCodeClassLoader, ExecutionConfig executionConfig, Map<String, Future<Path>> cpTasks, Map<String, Accumulator<?, ?>> accumulators, OperatorMetricGroup metrics) {
        super(jobInfo, taskInfo, SimpleUserCodeClassLoader.create(userCodeClassLoader), executionConfig, accumulators, cpTasks, metrics);
    }

    @Override
    public boolean hasBroadcastVariable(String name) {
        return this.initializedBroadcastVars.containsKey(name) || this.uninitializedBroadcastVars.containsKey(name);
    }

    @Override
    public <RT> List<RT> getBroadcastVariable(String name) {
        Object o = this.initializedBroadcastVars.get(name);
        if (o != null) {
            if (o instanceof List) {
                return (List)o;
            }
            throw new IllegalStateException("The broadcast variable with name '" + name + "' is not a List. A different call must have requested this variable with a BroadcastVariableInitializer.");
        }
        List<?> uninitialized = this.uninitializedBroadcastVars.remove(name);
        if (uninitialized != null) {
            this.initializedBroadcastVars.put(name, uninitialized);
            return uninitialized;
        }
        throw new IllegalArgumentException("The broadcast variable with name '" + name + "' has not been set.");
    }

    @Override
    public <T, C> C getBroadcastVariableWithInitializer(String name, BroadcastVariableInitializer<T, C> initializer) {
        Object o = this.initializedBroadcastVars.get(name);
        if (o != null) {
            return (C)o;
        }
        List<?> uninitialized = this.uninitializedBroadcastVars.remove(name);
        if (uninitialized != null) {
            C result = initializer.initializeBroadcastVariable(uninitialized);
            this.initializedBroadcastVars.put(name, result);
            return result;
        }
        throw new IllegalArgumentException("The broadcast variable with name '" + name + "' has not been set.");
    }

    @Override
    public Set<ExternalResourceInfo> getExternalResourceInfos(String resourceName) {
        throw new UnsupportedOperationException("Do not support external resource in current environment");
    }

    public void setBroadcastVariable(String name, List<?> value) {
        this.uninitializedBroadcastVars.put(name, value);
        this.initializedBroadcastVars.remove(name);
    }

    public void clearBroadcastVariable(String name) {
        this.uninitializedBroadcastVars.remove(name);
        this.initializedBroadcastVars.remove(name);
    }

    public void clearAllBroadcastVariables() {
        this.uninitializedBroadcastVars.clear();
        this.initializedBroadcastVars.clear();
    }
}

