/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.splittabledofn;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class RestrictionTrackers {
    private static final @UnknownKeyFor @NonNull @Initialized NoopClaimObserver<@UnknownKeyFor @NonNull @Initialized Object> NOOP_CLAIM_OBSERVER = new NoopClaimObserver();

    public static <RestrictionT, PositionT> @UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, PositionT> observe(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, PositionT> restrictionTracker, @UnknownKeyFor @NonNull @Initialized ClaimObserver<PositionT> claimObserver) {
        if (restrictionTracker instanceof RestrictionTracker.HasProgress) {
            return new RestrictionTrackerObserverWithProgress<RestrictionT, PositionT>(restrictionTracker, claimObserver);
        }
        return new RestrictionTrackerObserver<RestrictionT, PositionT>(restrictionTracker, claimObserver);
    }

    public static <RestrictionT, PositionT> @UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, PositionT> synchronize(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, PositionT> restrictionTracker) {
        if (restrictionTracker instanceof RestrictionTracker.HasProgress) {
            return new RestrictionTrackerObserverWithProgress<RestrictionT, Object>(restrictionTracker, NOOP_CLAIM_OBSERVER);
        }
        return new RestrictionTrackerObserver<RestrictionT, Object>(restrictionTracker, NOOP_CLAIM_OBSERVER);
    }

    static class NoopClaimObserver<@UnknownKeyFor PositionT>
    implements ClaimObserver<PositionT> {
        NoopClaimObserver() {
        }

        @Override
        public void onClaimed(PositionT position) {
        }

        @Override
        public void onClaimFailed(PositionT position) {
        }
    }

    @ThreadSafe
    static class RestrictionTrackerObserverWithProgress<@UnknownKeyFor RestrictionT, @UnknownKeyFor PositionT>
    extends RestrictionTrackerObserver<RestrictionT, PositionT>
    implements RestrictionTracker.HasProgress {
        private static final @UnknownKeyFor @NonNull @Initialized int FIRST_PROGRESS_TIMEOUT_SEC = 60;

        protected RestrictionTrackerObserverWithProgress(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, PositionT> delegate, @UnknownKeyFor @NonNull @Initialized ClaimObserver<PositionT> claimObserver) {
            super(delegate, claimObserver);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.Progress getProgress() {
            return this.getProgress(60);
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized RestrictionTracker.Progress getProgress(@UnknownKeyFor @NonNull @Initialized int timeOutSec) {
            if (!this.hasInitialProgress) {
                RestrictionTracker.Progress progress;
                block6: {
                    progress = RestrictionTracker.Progress.NONE;
                    try {
                        if (!this.lock.tryLock(timeOutSec, TimeUnit.SECONDS)) break block6;
                        try {
                            progress = this.getProgressBlocking();
                            this.hasInitialProgress = true;
                        }
                        finally {
                            this.lock.unlock();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                return progress;
            }
            return this.getProgressBlocking();
        }
    }

    @ThreadSafe
    private static class RestrictionTrackerObserver<@UnknownKeyFor RestrictionT, @UnknownKeyFor PositionT>
    extends RestrictionTracker<RestrictionT, PositionT> {
        protected final @UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, PositionT> delegate;
        protected @UnknownKeyFor @NonNull @Initialized ReentrantLock lock = new ReentrantLock();
        protected volatile @UnknownKeyFor @NonNull @Initialized boolean hasInitialProgress = false;
        private final @UnknownKeyFor @NonNull @Initialized ClaimObserver<PositionT> claimObserver;

        protected RestrictionTrackerObserver(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, PositionT> delegate, @UnknownKeyFor @NonNull @Initialized ClaimObserver<PositionT> claimObserver) {
            this.delegate = delegate;
            this.claimObserver = claimObserver;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(PositionT position) {
            this.lock.lock();
            try {
                if (this.delegate.tryClaim(position)) {
                    this.claimObserver.onClaimed(position);
                    boolean bl = true;
                    return bl;
                }
                this.claimObserver.onClaimFailed(position);
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public RestrictionT currentRestriction() {
            this.lock.lock();
            try {
                RestrictionT RestrictionT = this.delegate.currentRestriction();
                return RestrictionT;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public @UnknownKeyFor @NonNull @Initialized SplitResult<RestrictionT> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
            this.lock.lock();
            try {
                SplitResult<RestrictionT> result;
                SplitResult<RestrictionT> splitResult = result = this.delegate.trySplit(fractionOfRemainder);
                return splitResult;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void checkDone() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
            this.lock.lock();
            try {
                this.delegate.checkDone();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.IsBounded isBounded() {
            return this.delegate.isBounded();
        }

        protected @UnknownKeyFor @NonNull @Initialized RestrictionTracker.Progress getProgressBlocking() {
            this.lock.lock();
            try {
                RestrictionTracker.Progress progress = ((RestrictionTracker.HasProgress)((Object)this.delegate)).getProgress();
                return progress;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public static interface ClaimObserver<@UnknownKeyFor PositionT> {
        public void onClaimed(PositionT var1);

        public void onClaimFailed(PositionT var1);
    }
}

