/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.api.core.InternalApi;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.v2.ExecuteQueryRequest;
import com.google.cloud.bigtable.data.v2.internal.PrepareResponse;
import com.google.cloud.bigtable.data.v2.internal.PreparedStatementImpl;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.sql.BoundStatement;
import com.google.cloud.bigtable.data.v2.models.sql.PreparedStatementRefreshTimeoutException;
import com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import io.grpc.Deadline;
import io.grpc.Status;
import java.time.Instant;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

@InternalApi(value="For internal use only")
public class ExecuteQueryCallContext {
    private final BoundStatement boundStatement;
    private final SettableApiFuture<ResultSetMetadata> metadataFuture;
    private PreparedStatementImpl.PreparedQueryData latestPrepareResponse;
    @Nullable
    private ByteString resumeToken;
    private final Instant startTimeOfCall;

    private ExecuteQueryCallContext(BoundStatement boundStatement, SettableApiFuture<ResultSetMetadata> metadataFuture) {
        this.boundStatement = boundStatement;
        this.metadataFuture = metadataFuture;
        this.latestPrepareResponse = boundStatement.getLatestPrepareResponse();
        this.startTimeOfCall = Instant.now();
    }

    public static ExecuteQueryCallContext create(BoundStatement boundStatement, SettableApiFuture<ResultSetMetadata> metadataFuture) {
        return new ExecuteQueryCallContext(boundStatement, metadataFuture);
    }

    ExecuteQueryRequest buildRequestWithDeadline(RequestContext requestContext, @Nullable Deadline currentAttemptDeadline) throws PreparedStatementRefreshTimeoutException {
        long planRefreshWaitTimeoutNanos = Long.MAX_VALUE;
        if (currentAttemptDeadline != null) {
            planRefreshWaitTimeoutNanos = currentAttemptDeadline.timeRemaining(TimeUnit.NANOSECONDS);
        }
        try {
            PrepareResponse response = (PrepareResponse)this.latestPrepareResponse.prepareFuture().get(planRefreshWaitTimeoutNanos, TimeUnit.NANOSECONDS);
            return this.boundStatement.toProto(response.preparedQuery(), requestContext, this.resumeToken);
        }
        catch (TimeoutException e) {
            throw new PreparedStatementRefreshTimeoutException("Exceeded deadline waiting for PreparedQuery to refresh");
        }
        catch (ExecutionException e) {
            GrpcStatusCode retryStatusCode = GrpcStatusCode.of((Status.Code)Status.Code.FAILED_PRECONDITION);
            Throwable cause = e.getCause();
            if (cause instanceof ApiException) {
                retryStatusCode = ((ApiException)cause).getStatusCode();
            }
            throw ApiExceptionFactory.createException((String)"Plan refresh error", (Throwable)cause, (StatusCode)retryStatusCode, (boolean)true);
        }
        catch (InterruptedException e) {
            throw ApiExceptionFactory.createException((String)"Plan refresh error", (Throwable)e, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.FAILED_PRECONDITION), (boolean)true);
        }
    }

    void finalizeMetadata() {
        try {
            Preconditions.checkState((boolean)this.latestPrepareResponse.prepareFuture().isDone(), (Object)"Unexpected attempt to finalize metadata with unresolved prepare response. This should never as this is called after we receive ExecuteQuery responses, which requires the future to be resolved");
            PrepareResponse response = (PrepareResponse)ApiExceptions.callAndTranslateApiException(this.latestPrepareResponse.prepareFuture());
            this.metadataFuture.set((Object)response.resultSetMetadata());
        }
        catch (Throwable t) {
            this.metadataFuture.setException(t);
            throw t;
        }
    }

    void setMetadataException(Throwable t) {
        this.metadataFuture.setException(t);
    }

    SettableApiFuture<ResultSetMetadata> resultSetMetadataFuture() {
        return this.metadataFuture;
    }

    void setLatestResumeToken(ByteString resumeToken) {
        this.resumeToken = resumeToken;
    }

    boolean hasResumeToken() {
        return this.resumeToken != null;
    }

    void triggerImmediateRefreshOfPreparedQuery() {
        this.latestPrepareResponse = this.boundStatement.markExpiredAndStartRefresh(this.latestPrepareResponse.version());
    }

    Instant startTimeOfCall() {
        return this.startTimeOfCall;
    }
}

