/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.IMetrics;
import org.apache.hop.core.metrics.IMetricsSnapshot;

public class MetricsRegistry {
    private static MetricsRegistry registry = new MetricsRegistry();
    private Map<String, Map<String, IMetricsSnapshot>> snapshotMaps = new ConcurrentHashMap<String, Map<String, IMetricsSnapshot>>();
    private Map<String, Queue<IMetricsSnapshot>> snapshotLists = new ConcurrentHashMap<String, Queue<IMetricsSnapshot>>();

    public static MetricsRegistry getInstance() {
        return registry;
    }

    private MetricsRegistry() {
    }

    public void addSnapshot(ILogChannel logChannel, IMetricsSnapshot snapshot) {
        IMetrics metric = snapshot.getMetric();
        String channelId = logChannel.getLogChannelId();
        switch (metric.getType()) {
            case START: 
            case STOP: {
                Queue<IMetricsSnapshot> list = this.getSnapshotList(channelId);
                list.add(snapshot);
                break;
            }
            case MIN: 
            case MAX: 
            case SUM: 
            case COUNT: {
                Map<String, IMetricsSnapshot> map = this.getSnapshotMap(channelId);
                map.put(snapshot.getKey(), snapshot);
                break;
            }
        }
    }

    public Map<String, Queue<IMetricsSnapshot>> getSnapshotLists() {
        return this.snapshotLists;
    }

    public Map<String, Map<String, IMetricsSnapshot>> getSnapshotMaps() {
        return this.snapshotMaps;
    }

    public Queue<IMetricsSnapshot> getSnapshotList(String logChannelId) {
        Queue<IMetricsSnapshot> list = this.snapshotLists.get(logChannelId);
        if (list == null) {
            list = new ConcurrentLinkedQueue<IMetricsSnapshot>();
            this.snapshotLists.put(logChannelId, list);
        }
        return list;
    }

    public Map<String, IMetricsSnapshot> getSnapshotMap(String logChannelId) {
        Map<String, IMetricsSnapshot> map = this.snapshotMaps.get(logChannelId);
        if (map == null) {
            map = new ConcurrentHashMap<String, IMetricsSnapshot>();
            this.snapshotMaps.put(logChannelId, map);
        }
        return map;
    }

    public void reset() {
        this.snapshotMaps.clear();
        this.snapshotLists.clear();
    }
}

