/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core;

import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;

public class FormDataBuilder
implements Cloneable {
    private static final FormAttachment MIN = new FormAttachment(0, 0);
    private static final FormAttachment MAX = new FormAttachment(100, 0);
    protected FormData fd = new FormData();

    public static FormDataBuilder builder() {
        return new FormDataBuilder();
    }

    public FormData build() {
        return this.fd;
    }

    public FormDataBuilder width(int width) {
        this.fd.width = width;
        return this;
    }

    public FormDataBuilder height(int height) {
        this.fd.height = height;
        return this;
    }

    public FormDataBuilder left(int p1, int p2) {
        this.fd.left = new FormAttachment(p1, p2);
        return this;
    }

    public FormDataBuilder right(int p1, int p2) {
        this.fd.right = new FormAttachment(p1, p2);
        return this;
    }

    public FormDataBuilder top(int p1, int p2) {
        this.fd.top = new FormAttachment(p1, p2);
        return this;
    }

    public FormDataBuilder bottom(int p1, int p2) {
        this.fd.bottom = new FormAttachment(p1, p2);
        return this;
    }

    public FormDataBuilder left(FormAttachment fa) {
        this.fd.left = fa;
        return this;
    }

    public FormDataBuilder right(FormAttachment fa) {
        this.fd.right = fa;
        return this;
    }

    public FormDataBuilder top(FormAttachment fa) {
        this.fd.top = fa;
        return this;
    }

    public FormDataBuilder bottom(FormAttachment fa) {
        this.fd.bottom = fa;
        return this;
    }

    public FormDataBuilder left(Control control, int margin) {
        return this.left(new FormAttachment(control, margin));
    }

    public FormDataBuilder top(Control control, int margin) {
        return this.top(new FormAttachment(control, margin));
    }

    public FormDataBuilder left(Control control, int margin, int alignment) {
        return this.left(new FormAttachment(control, margin, alignment));
    }

    public FormDataBuilder right(Control control, int margin, int alignment) {
        return this.right(new FormAttachment(control, margin, alignment));
    }

    public FormDataBuilder top(Control control, int margin, int alignment) {
        return this.top(new FormAttachment(control, margin, alignment));
    }

    public FormDataBuilder bottom(Control control, int margin) {
        return this.bottom(new FormAttachment(control, margin));
    }

    public FormDataBuilder right(Control control, int margin) {
        return this.right(new FormAttachment(control, margin));
    }

    public FormDataBuilder left() {
        return this.left(MIN);
    }

    public FormDataBuilder right() {
        return this.right(MAX);
    }

    public FormDataBuilder top() {
        return this.top(MIN);
    }

    public FormDataBuilder bottom() {
        return this.bottom(MAX);
    }

    public FormDataBuilder top(Control control) {
        return this.top(control, 5);
    }

    public FormDataBuilder fullWidth() {
        return this.percentWidth(100);
    }

    public FormDataBuilder percentWidth(int width) {
        return this.left().right(width, 0);
    }

    public FormDataBuilder fullSize() {
        return this.fullWidth().top().bottom();
    }

    public FormData result() {
        return this.fd;
    }

    protected FormDataBuilder clone() {
        FormDataBuilder res = new FormDataBuilder();
        return res.left(this.fd.left).right(this.fd.right).top(this.fd.top).bottom(this.fd.bottom);
    }
}

