/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.partitions.AbstractBTreePartition;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.schema.TableMetadata;

public class ImmutableBTreePartition
extends AbstractBTreePartition {
    protected final AbstractBTreePartition.Holder holder;
    protected final TableMetadata metadata;

    public ImmutableBTreePartition(TableMetadata metadata, DecoratedKey partitionKey, RegularAndStaticColumns columns, Row staticRow, Object[] tree, DeletionInfo deletionInfo, EncodingStats stats) {
        super(partitionKey);
        this.metadata = metadata;
        this.holder = new AbstractBTreePartition.Holder(columns, tree, deletionInfo, staticRow, stats);
    }

    protected ImmutableBTreePartition(TableMetadata metadata, DecoratedKey partitionKey, AbstractBTreePartition.Holder holder) {
        super(partitionKey);
        this.metadata = metadata;
        this.holder = holder;
    }

    public static ImmutableBTreePartition create(UnfilteredRowIterator iterator) {
        return ImmutableBTreePartition.create(iterator, 16);
    }

    public static ImmutableBTreePartition create(UnfilteredRowIterator iterator, boolean ordered) {
        return ImmutableBTreePartition.create(iterator, 16, ordered);
    }

    public static ImmutableBTreePartition create(UnfilteredRowIterator iterator, int initialRowCapacity) {
        return ImmutableBTreePartition.create(iterator, initialRowCapacity, true);
    }

    public static ImmutableBTreePartition create(UnfilteredRowIterator iterator, int initialRowCapacity, boolean ordered) {
        return new ImmutableBTreePartition(iterator.metadata(), iterator.partitionKey(), ImmutableBTreePartition.build(iterator, initialRowCapacity, ordered));
    }

    @Override
    public TableMetadata metadata() {
        return this.metadata;
    }

    @Override
    protected AbstractBTreePartition.Holder holder() {
        return this.holder;
    }

    @Override
    protected boolean canHaveShadowedData() {
        return false;
    }
}

