/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

public interface DiskOptimizationStrategy {
    public static final int MIN_BUFFER_SIZE = 4096;
    public static final int MIN_BUFFER_SIZE_MASK = 4095;
    public static final int MAX_BUFFER_SIZE = 65536;

    public int bufferSize(long var1);

    default public int roundBufferSize(long size) {
        if (size <= 0L) {
            return 4096;
        }
        size = size + 4095L & 0xFFFFFFFFFFFFF000L;
        return (int)Math.min(size, 65536L);
    }

    public static int roundForCaching(int size, boolean roundUp) {
        if (size <= 4096) {
            return 4096;
        }
        int ret = roundUp ? 1 << 32 - Integer.numberOfLeadingZeros(size - 1) : Integer.highestOneBit(size);
        return Math.min(65536, ret);
    }
}

