/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basehlc;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

public class HLC {
    public static final HLC INST = new HLC();
    private static final long CAUSAL_MASK = 65535L;
    private static final VarHandle CAE;
    private long p3;
    private long p4;
    private long p5;
    private long p6;
    private long p7;
    private volatile long hlc = 0L;
    private long p9;
    private long p10;
    private long p11;
    private long p12;
    private long p13;
    private long p14;
    private long p15;

    private HLC() {
    }

    private static long nextMillis(long nowMillis) {
        long t;
        while ((t = System.currentTimeMillis()) == nowMillis) {
            Thread.onSpinWait();
        }
        return t;
    }

    public long get() {
        long newHLC;
        long witness;
        do {
            long now = this.hlc;
            long l = this.logical(now);
            long c = this.causal(now);
            long phys = System.currentTimeMillis();
            long updateL = Math.max(l, phys);
            long l2 = c = updateL == l ? c + 1L : 0L;
            if (c > 65535L) {
                updateL = HLC.nextMillis(updateL);
                c = 0L;
            }
            if ((witness = CAE.compareAndExchange(this, now, newHLC = this.toTimestamp(updateL, c))) != now) continue;
            return newHLC;
        } while (witness < newHLC);
        return witness;
    }

    public long update(long otherHLC) {
        long newHLC;
        long witness;
        do {
            long now = this.hlc;
            long l = this.logical(now);
            long c = this.causal(now);
            long otherL = this.logical(otherHLC);
            long otherC = this.causal(otherHLC);
            long updateL = Math.max(l, Math.max(otherL, System.currentTimeMillis()));
            c = updateL == l && otherL == l ? Math.max(c, otherC) + 1L : (updateL == l ? ++c : (otherL == l ? otherC + 1L : 0L));
            if (c > 65535L) {
                updateL = HLC.nextMillis(updateL);
                c = 0L;
            }
            if ((witness = CAE.compareAndExchange(this, now, newHLC = this.toTimestamp(updateL, c))) != now) continue;
            return newHLC;
        } while (witness < newHLC);
        return witness;
    }

    public long getPhysical() {
        return this.getPhysical(this.get());
    }

    public long getPhysical(long hlc) {
        return this.logical(hlc);
    }

    private long toTimestamp(long l, long c) {
        return l << 16 | c;
    }

    private long logical(long hlc) {
        return hlc >> 16;
    }

    private long causal(long hlc) {
        return hlc & 0xFFFFL;
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.privateLookupIn(HLC.class, MethodHandles.lookup());
            CAE = l.findVarHandle(HLC.class, "hlc", Long.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

