/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.authprovider;

import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.plugin.authprovider.DevOnlyAuthProvider;
import org.apache.bifromq.plugin.authprovider.IAuthProvider;
import org.apache.bifromq.plugin.authprovider.MetricManager;
import org.apache.bifromq.plugin.authprovider.type.CheckResult;
import org.apache.bifromq.plugin.authprovider.type.Error;
import org.apache.bifromq.plugin.authprovider.type.Failed;
import org.apache.bifromq.plugin.authprovider.type.Granted;
import org.apache.bifromq.plugin.authprovider.type.MQTT3AuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTT3AuthResult;
import org.apache.bifromq.plugin.authprovider.type.MQTT5AuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTT5AuthResult;
import org.apache.bifromq.plugin.authprovider.type.MQTT5ExtendedAuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTT5ExtendedAuthResult;
import org.apache.bifromq.plugin.authprovider.type.MQTTAction;
import org.apache.bifromq.plugin.authprovider.type.Reject;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.accessctrl.AccessControlError;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.Setting;
import org.apache.bifromq.type.ClientInfo;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthProviderManager
implements IAuthProvider,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthProviderManager.class);
    private static final Logger pluginLog = LoggerFactory.getLogger((String)"plugin.manager");
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final IAuthProvider delegate;
    private final ISettingProvider settingProvider;
    private final IEventCollector eventCollector;
    private MetricManager metricMgr;

    public AuthProviderManager(String authProviderFQN, PluginManager pluginMgr, ISettingProvider settingProvider, IEventCollector eventCollector) {
        this.settingProvider = settingProvider;
        this.eventCollector = eventCollector;
        Map<String, IAuthProvider> availAuthProviders = pluginMgr.getExtensions(IAuthProvider.class).stream().collect(Collectors.toMap(e -> e.getClass().getName(), e -> e));
        if (availAuthProviders.isEmpty()) {
            pluginLog.warn("No auth provider plugin available, use DEV ONLY one instead");
            this.delegate = new DevOnlyAuthProvider();
        } else if (authProviderFQN == null) {
            pluginLog.warn("Auth provider plugin type not specified, use DEV ONLY one instead");
            this.delegate = new DevOnlyAuthProvider();
        } else if (!availAuthProviders.containsKey(authProviderFQN)) {
            pluginLog.warn("Auth provider plugin type '{}' not found, use DEV ONLY one instead", (Object)authProviderFQN);
            this.delegate = new DevOnlyAuthProvider();
        } else {
            pluginLog.info("Auth provider plugin type: {}", (Object)authProviderFQN);
            this.delegate = availAuthProviders.get(authProviderFQN);
        }
        this.init();
    }

    private void init() {
        this.metricMgr = new MetricManager(this.delegate.getClass().getName());
    }

    public CompletableFuture<MQTT3AuthResult> auth(MQTT3AuthData authData) {
        assert (!this.stopped.get());
        Timer.Sample start = Timer.start();
        try {
            return this.delegate.auth(authData).handle((v, e) -> {
                if (e != null) {
                    this.metricMgr.authCallErrorCounter.increment();
                    return MQTT3AuthResult.newBuilder().setReject(Reject.newBuilder().setCode(Reject.Code.Error).setReason(e.getMessage() != null ? e.getMessage() : e.toString()).build()).build();
                }
                start.stop(this.metricMgr.authCallTimer);
                return v;
            });
        }
        catch (Throwable e2) {
            this.metricMgr.authCallErrorCounter.increment();
            pluginLog.error("AuthProvider auth3 throws exception", e2);
            Reject.Builder rb = Reject.newBuilder().setCode(Reject.Code.Error);
            if (e2.getMessage() != null) {
                rb.setReason(e2.getMessage());
            }
            return CompletableFuture.completedFuture(MQTT3AuthResult.newBuilder().setReject(Reject.newBuilder().setCode(Reject.Code.Error).setReason(e2.getMessage() != null ? e2.getMessage() : e2.toString()).build()).build());
        }
    }

    public CompletableFuture<MQTT5AuthResult> auth(MQTT5AuthData authData) {
        assert (!this.stopped.get());
        Timer.Sample start = Timer.start();
        try {
            return this.delegate.auth(authData).handle((v, e) -> {
                if (e != null) {
                    this.metricMgr.authCallErrorCounter.increment();
                    return MQTT5AuthResult.newBuilder().setFailed(Failed.newBuilder().setCode(Failed.Code.Error).setReason(e.getMessage() != null ? e.getMessage() : e.toString()).build()).build();
                }
                start.stop(this.metricMgr.authCallTimer);
                return v;
            });
        }
        catch (Throwable e2) {
            this.metricMgr.authCallErrorCounter.increment();
            pluginLog.error("AuthProvider auth5 throws exception", e2);
            Failed.Builder rb = Failed.newBuilder().setCode(Failed.Code.Error);
            if (e2.getMessage() != null) {
                rb.setReason(e2.getMessage());
            }
            return CompletableFuture.completedFuture(MQTT5AuthResult.newBuilder().setFailed(Failed.newBuilder().setCode(Failed.Code.Error).setReason(e2.getMessage() != null ? e2.getMessage() : e2.toString()).build()).build());
        }
    }

    public CompletableFuture<MQTT5ExtendedAuthResult> extendedAuth(MQTT5ExtendedAuthData authData) {
        assert (!this.stopped.get());
        Timer.Sample start = Timer.start();
        try {
            return this.delegate.extendedAuth(authData).handle((v, e) -> {
                if (e != null) {
                    this.metricMgr.extAuthCallErrorCounter.increment();
                    return MQTT5ExtendedAuthResult.newBuilder().setFailed(Failed.newBuilder().setCode(Failed.Code.Error).setReason(e.getMessage() != null ? e.getMessage() : e.toString()).build()).build();
                }
                start.stop(this.metricMgr.extAuthCallTimer);
                return v;
            });
        }
        catch (Throwable e2) {
            this.metricMgr.extAuthCallErrorCounter.increment();
            pluginLog.error("AuthProvider extendedAuth throws exception", e2);
            Failed.Builder rb = Failed.newBuilder().setCode(Failed.Code.Error);
            if (e2.getMessage() != null) {
                rb.setReason(e2.getMessage());
            }
            return CompletableFuture.completedFuture(MQTT5ExtendedAuthResult.newBuilder().setFailed(Failed.newBuilder().setCode(Failed.Code.Error).setReason(e2.getMessage() != null ? e2.getMessage() : e2.toString()).build()).build());
        }
    }

    public CompletableFuture<Boolean> check(ClientInfo client, MQTTAction action) {
        pluginLog.warn("IAuthProvider/check method has been deprecated and will be removed in later release, please implement checkPermission instead");
        return this.delegate.check(client, action);
    }

    public CompletableFuture<CheckResult> checkPermission(ClientInfo client, MQTTAction action) {
        assert (!this.stopped.get());
        Timer.Sample start = Timer.start();
        try {
            return ((CompletableFuture)this.delegate.checkPermission(client, action).thenApply(v -> {
                start.stop(this.metricMgr.checkCallTimer);
                if (v.getTypeCase() == CheckResult.TypeCase.ERROR && ((Boolean)this.settingProvider.provide(Setting.ByPassPermCheckError, client.getTenantId())).booleanValue()) {
                    this.eventCollector.report((Event)((AccessControlError)((AccessControlError)ThreadLocalEventPool.getLocal(AccessControlError.class)).clientInfo(client)).cause(v.getError().getReason()));
                    return CheckResult.newBuilder().setGranted(Granted.getDefaultInstance()).build();
                }
                return v;
            })).exceptionally(e -> {
                this.metricMgr.checkCallErrorCounter.increment();
                this.eventCollector.report((Event)((AccessControlError)((AccessControlError)ThreadLocalEventPool.getLocal(AccessControlError.class)).clientInfo(client)).cause(e.getMessage()));
                boolean byPass = (Boolean)this.settingProvider.provide(Setting.ByPassPermCheckError, client.getTenantId());
                if (byPass) {
                    return CheckResult.newBuilder().setGranted(Granted.getDefaultInstance()).build();
                }
                pluginLog.error("AuthProvider permission check error", e);
                return CheckResult.newBuilder().setError(Error.newBuilder().setReason("Permission check error").build()).build();
            });
        }
        catch (Throwable e2) {
            this.metricMgr.checkCallErrorCounter.increment();
            this.eventCollector.report((Event)((AccessControlError)((AccessControlError)ThreadLocalEventPool.getLocal(AccessControlError.class)).clientInfo(client)).cause(e2.getMessage()));
            boolean byPass = (Boolean)this.settingProvider.provide(Setting.ByPassPermCheckError, client.getTenantId());
            if (byPass) {
                return CompletableFuture.completedFuture(CheckResult.newBuilder().setGranted(Granted.getDefaultInstance()).build());
            }
            pluginLog.error("AuthProvider permission check error", e2);
            return CompletableFuture.completedFuture(CheckResult.newBuilder().setError(Error.newBuilder().setReason("Permission check error").build()).build());
        }
    }

    @Override
    public void close() {
        if (this.stopped.compareAndSet(false, true)) {
            log.debug("Closing auth provider manager");
            try {
                this.delegate.close();
            }
            catch (Throwable e) {
                pluginLog.error("AuthProvider close throws exception", e);
            }
            this.metricMgr.close();
            log.debug("Auth provider manager stopped");
        }
    }
}

