/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.metrics;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.lang.ref.Cleaner;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMeter;

class TenantMeterCache {
    private static final Cleaner CLEANER = Cleaner.create();
    private static final LoadingCache<String, TenantMeter> TENANT_METER_CACHE = Caffeine.newBuilder().weakValues().build(TenantMeter::new);
    private static final ThreadLocal<ThreadLocalRef> THREAD_LOCAL_REF = ThreadLocal.withInitial(() -> new ThreadLocalRef(arg_0 -> TENANT_METER_CACHE.get(arg_0)));

    TenantMeterCache() {
    }

    static ITenantMeter get(String tenantId) {
        return THREAD_LOCAL_REF.get().get(tenantId);
    }

    static void cleanUp() {
        TENANT_METER_CACHE.cleanUp();
    }

    private static class ThreadLocalRef {
        private final Function<String, TenantMeter> tenantMeterGetter;
        private final Map<String, WeakReference<TenantMeter>> tenantMeterWeakRefMap;
        private final WeakHashMap<TenantMeter, CleanableState> cleanableStateMap;

        private ThreadLocalRef(Function<String, TenantMeter> tenantMeterGetter) {
            this.tenantMeterGetter = tenantMeterGetter;
            this.tenantMeterWeakRefMap = new ConcurrentHashMap<String, WeakReference<TenantMeter>>();
            this.cleanableStateMap = new WeakHashMap();
        }

        public TenantMeter get(String tenantId) {
            TenantMeter tenantMeter;
            while ((tenantMeter = this.getInternal(tenantId)) == null) {
            }
            return tenantMeter;
        }

        private TenantMeter getInternal(String tenantId) {
            return (TenantMeter)this.tenantMeterWeakRefMap.computeIfAbsent(tenantId, k -> {
                TenantMeter meter = this.tenantMeterGetter.apply((String)k);
                CleanableState state = new CleanableState((String)k, this.tenantMeterWeakRefMap);
                this.cleanableStateMap.put(meter, state);
                CLEANER.register(meter, state);
                return new WeakReference<TenantMeter>(meter);
            }).get();
        }
    }

    private static class CleanableState
    implements Runnable {
        final String tenantId;
        final Map<String, WeakReference<TenantMeter>> tenantMeterWeakRefMap;

        private CleanableState(String tenantId, Map<String, WeakReference<TenantMeter>> tenantMeterWeakRefMap) {
            this.tenantId = tenantId;
            this.tenantMeterWeakRefMap = tenantMeterWeakRefMap;
        }

        @Override
        public void run() {
            this.tenantMeterWeakRefMap.remove(this.tenantId);
        }
    }
}

