/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.sys;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.statement.sys.AuthorStatement;

public class AuthorizerTask
implements IConfigTask {
    private final AuthorStatement authorStatement;

    public AuthorizerTask(AuthorStatement authorStatement) {
        this.authorStatement = authorStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) {
        if (this.authorStatement.getQueryType() == QueryType.WRITE) {
            return AuthorityChecker.operatePermission(this.authorStatement);
        }
        return AuthorityChecker.queryPermission(this.authorStatement);
    }
}

