/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.splitter;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.load.LoadFileException;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.load.splitter.AlignedChunkData;
import org.apache.iotdb.db.storageengine.load.splitter.BatchedAlignedValueChunkData;
import org.apache.iotdb.db.storageengine.load.splitter.ChunkData;
import org.apache.iotdb.db.storageengine.load.splitter.DeletionData;
import org.apache.iotdb.db.storageengine.load.splitter.TsFileData;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.TsFileRuntimeException;
import org.apache.tsfile.file.MetaMarker;
import org.apache.tsfile.file.header.ChunkGroupHeader;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.reader.page.PageReader;
import org.apache.tsfile.read.reader.page.TimePageReader;
import org.apache.tsfile.read.reader.page.ValuePageReader;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileSplitter {
    private static final Logger logger = LoggerFactory.getLogger(TsFileSplitter.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final File tsFile;
    private final TsFileDataConsumer consumer;
    private Map<Long, IChunkMetadata> offset2ChunkMetadata = new HashMap<Long, IChunkMetadata>();
    private TreeMap<Long, List<Deletion>> offset2Deletions = new TreeMap();
    private Map<Integer, List<AlignedChunkData>> pageIndex2ChunkData = new HashMap<Integer, List<AlignedChunkData>>();
    private Map<Integer, long[]> pageIndex2Times = new HashMap<Integer, long[]>();
    private boolean isTimeChunkNeedDecode = true;
    private IDeviceID curDevice = null;
    private boolean isAligned;
    private int timeChunkIndexOfCurrentValueColumn = 0;
    private Set<TTimePartitionSlot> timePartitionSlots = new HashSet<TTimePartitionSlot>();
    private Map<String, Integer> valueColumn2TimeChunkIndex = new HashMap<String, Integer>();
    private List<Map<Integer, List<AlignedChunkData>>> pageIndex2ChunkDataList = new ArrayList<Map<Integer, List<AlignedChunkData>>>();
    private List<Map<Integer, long[]>> pageIndex2TimesList = null;
    private List<Boolean> isTimeChunkNeedDecodeList = new ArrayList<Boolean>();

    public TsFileSplitter(File tsFile, TsFileDataConsumer consumer) {
        this.tsFile = tsFile;
        this.consumer = consumer;
    }

    public void splitTsFileByDataPartition() throws IOException, LoadFileException, IllegalStateException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(this.tsFile.getAbsolutePath());){
            byte marker;
            this.getAllModification(this.offset2Deletions);
            if (!this.checkMagic(reader)) {
                throw new TsFileRuntimeException(String.format("Magic String check error when parsing TsFile %s.", this.tsFile.getPath()));
            }
            reader.position((long)"TsFile".getBytes().length + 1L);
            this.getChunkMetadata(reader, this.offset2ChunkMetadata);
            block11: while ((marker = reader.readMarker()) != 2) {
                switch (marker) {
                    case -127: 
                    case -123: 
                    case 1: 
                    case 5: {
                        this.processTimeChunkOrNonAlignedChunk(reader, marker);
                        if (!this.isAligned) continue block11;
                        this.storeTimeChunkContext();
                        continue block11;
                    }
                    case 65: 
                    case 69: {
                        this.processValueChunk(reader, marker);
                        continue block11;
                    }
                    case 0: {
                        ChunkGroupHeader chunkGroupHeader = reader.readChunkGroupHeader();
                        this.curDevice = chunkGroupHeader.getDeviceID();
                        this.pageIndex2ChunkDataList = new ArrayList<Map<Integer, List<AlignedChunkData>>>();
                        this.pageIndex2TimesList = new ArrayList<Map<Integer, long[]>>();
                        this.isTimeChunkNeedDecodeList = new ArrayList<Boolean>();
                        this.valueColumn2TimeChunkIndex = new HashMap<String, Integer>();
                        this.timeChunkIndexOfCurrentValueColumn = 0;
                        continue block11;
                    }
                    case 4: {
                        reader.readPlanIndex();
                        continue block11;
                    }
                }
                MetaMarker.handleUnexpectedMarker((byte)marker);
            }
            this.consumeAllAlignedChunkData(reader.position(), this.pageIndex2ChunkData);
            this.handleModification(this.offset2Deletions, Long.MAX_VALUE);
        }
    }

    private void processTimeChunkOrNonAlignedChunk(TsFileSequenceReader reader, byte marker) throws IOException, LoadFileException {
        long chunkOffset = reader.position();
        this.timeChunkIndexOfCurrentValueColumn = this.pageIndex2TimesList.size();
        this.consumeAllAlignedChunkData(chunkOffset, this.pageIndex2ChunkData);
        this.handleModification(this.offset2Deletions, chunkOffset);
        ChunkHeader header = reader.readChunkHeader(marker);
        String measurementId = header.getMeasurementID();
        if (header.getDataSize() == 0) {
            throw new TsFileRuntimeException(String.format("Empty Nonaligned Chunk or Time Chunk with offset %d in TsFile %s.", chunkOffset, this.tsFile.getPath()));
        }
        this.isAligned = (header.getChunkType() & 0xFFFFFF80) == -128;
        IChunkMetadata chunkMetadata = this.offset2ChunkMetadata.get(chunkOffset - 1L);
        if (chunkMetadata == null) {
            reader.readChunk(-1L, header.getDataSize());
            return;
        }
        TTimePartitionSlot timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)chunkMetadata.getStartTime());
        ChunkData chunkData = ChunkData.createChunkData(this.isAligned, ((PlainDeviceID)this.curDevice).toStringID(), header, timePartitionSlot);
        if (!this.needDecodeChunk(chunkMetadata)) {
            chunkData.setNotDecode();
            chunkData.writeEntireChunk(reader.readChunk(-1L, header.getDataSize()), chunkMetadata);
            if (this.isAligned) {
                this.isTimeChunkNeedDecode = false;
                this.pageIndex2ChunkData.computeIfAbsent(1, o -> new ArrayList()).add((AlignedChunkData)chunkData);
            } else {
                this.consumeChunkData(measurementId, chunkOffset, chunkData);
            }
            return;
        }
        this.decodeAndWriteTimeChunkOrNonAlignedChunk(reader, header, chunkMetadata, chunkOffset, chunkData);
    }

    private void decodeAndWriteTimeChunkOrNonAlignedChunk(TsFileSequenceReader reader, ChunkHeader header, IChunkMetadata chunkMetadata, long chunkOffset, ChunkData chunkData) throws IOException, LoadFileException {
        String measurementId = header.getMeasurementID();
        TTimePartitionSlot timePartitionSlot = chunkData.getTimePartitionSlot();
        Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)header.getEncodingType(), (TSDataType)header.getDataType());
        int dataSize = header.getDataSize();
        int pageIndex = 0;
        if (this.isAligned) {
            this.isTimeChunkNeedDecode = true;
            this.pageIndex2Times = new HashMap<Integer, long[]>();
        }
        while (dataSize > 0) {
            PageHeader pageHeader = reader.readPageHeader(header.getDataType(), (header.getChunkType() & 0x3F) == 1);
            long pageDataSize = pageHeader.getSerializedPageSize();
            if (!this.needDecodePage(pageHeader, chunkMetadata)) {
                long startTime = pageHeader.getStatistics() == null ? chunkMetadata.getStartTime() : pageHeader.getStartTime();
                TTimePartitionSlot pageTimePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)startTime);
                if (!timePartitionSlot.equals(pageTimePartitionSlot)) {
                    if (!this.isAligned) {
                        this.consumeChunkData(measurementId, chunkOffset, chunkData);
                    }
                    timePartitionSlot = pageTimePartitionSlot;
                    chunkData = ChunkData.createChunkData(this.isAligned, ((PlainDeviceID)this.curDevice).toStringID(), header, timePartitionSlot);
                }
                if (this.isAligned) {
                    this.pageIndex2ChunkData.computeIfAbsent(pageIndex, o -> new ArrayList()).add((AlignedChunkData)chunkData);
                }
                chunkData.writeEntirePage(pageHeader, reader.readCompressedPage(pageHeader));
            } else {
                ByteBuffer pageData = reader.readPage(pageHeader, header.getCompressionType());
                Pair<long[], Object[]> tvArray = this.decodePage(this.isAligned, pageData, pageHeader, defaultTimeDecoder, valueDecoder, header);
                long[] times = (long[])tvArray.left;
                Object[] values = (Object[])tvArray.right;
                if (this.isAligned) {
                    this.pageIndex2Times.put(pageIndex, times);
                }
                int satisfiedLength = 0;
                long endTime = timePartitionSlot.getStartTime() + TimePartitionUtils.getTimePartitionInterval();
                if (endTime <= timePartitionSlot.getStartTime()) {
                    endTime = Long.MAX_VALUE;
                }
                for (int i = 0; i < times.length; ++i) {
                    if (times[i] >= endTime) {
                        chunkData.writeDecodePage(times, values, satisfiedLength);
                        if (this.isAligned) {
                            this.pageIndex2ChunkData.computeIfAbsent(pageIndex, o -> new ArrayList()).add((AlignedChunkData)chunkData);
                        } else {
                            this.consumeChunkData(measurementId, chunkOffset, chunkData);
                        }
                        timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)times[i]);
                        satisfiedLength = 0;
                        endTime = timePartitionSlot.getStartTime() + TimePartitionUtils.getTimePartitionInterval();
                        if (endTime <= timePartitionSlot.getStartTime()) {
                            endTime = Long.MAX_VALUE;
                        }
                        chunkData = ChunkData.createChunkData(this.isAligned, ((PlainDeviceID)this.curDevice).toStringID(), header, timePartitionSlot);
                    }
                    ++satisfiedLength;
                }
                chunkData.writeDecodePage(times, values, satisfiedLength);
                if (this.isAligned) {
                    this.pageIndex2ChunkData.computeIfAbsent(pageIndex, o -> new ArrayList()).add((AlignedChunkData)chunkData);
                }
            }
            ++pageIndex;
            dataSize = (int)((long)dataSize - pageDataSize);
        }
        if (!this.isAligned) {
            this.consumeChunkData(measurementId, chunkOffset, chunkData);
        }
    }

    private void processValueChunk(TsFileSequenceReader reader, byte marker) throws IOException, LoadFileException {
        long chunkOffset = reader.position();
        IChunkMetadata chunkMetadata = this.offset2ChunkMetadata.get(chunkOffset - 1L);
        ChunkHeader header = reader.readChunkHeader(marker);
        if (chunkMetadata == null) {
            reader.readChunk(-1L, header.getDataSize());
            return;
        }
        this.switchToTimeChunkContextOfCurrentMeasurement(reader, header.getMeasurementID());
        if (header.getDataSize() == 0) {
            this.handleEmptyValueChunk(header, this.pageIndex2ChunkData, chunkMetadata, this.isTimeChunkNeedDecode);
            return;
        }
        if (!this.isTimeChunkNeedDecode) {
            AlignedChunkData alignedChunkData = this.pageIndex2ChunkData.get(1).get(0);
            alignedChunkData.addValueChunk(header);
            alignedChunkData.writeEntireChunk(reader.readChunk(-1L, header.getDataSize()), chunkMetadata);
            return;
        }
        HashSet<AlignedChunkData> allChunkData = new HashSet<AlignedChunkData>();
        int dataSize = header.getDataSize();
        int pageIndex = 0;
        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)header.getEncodingType(), (TSDataType)header.getDataType());
        while (dataSize > 0) {
            PageHeader pageHeader = reader.readPageHeader(header.getDataType(), (header.getChunkType() & 0x3F) == 1);
            List<AlignedChunkData> alignedChunkDataList = this.pageIndex2ChunkData.get(pageIndex);
            for (AlignedChunkData alignedChunkData : alignedChunkDataList) {
                if (allChunkData.contains(alignedChunkData)) continue;
                alignedChunkData.addValueChunk(header);
                allChunkData.add(alignedChunkData);
            }
            if (alignedChunkDataList.size() == 1) {
                alignedChunkDataList.get(0).writeEntirePage(pageHeader, reader.readCompressedPage(pageHeader));
            } else {
                long[] times = this.pageIndex2Times.get(pageIndex);
                TsPrimitiveType[] values = this.decodeValuePage(reader, header, pageHeader, times, valueDecoder);
                for (AlignedChunkData alignedChunkData : alignedChunkDataList) {
                    alignedChunkData.writeDecodeValuePage(times, values, header.getDataType());
                }
            }
            long pageDataSize = pageHeader.getSerializedPageSize();
            ++pageIndex;
            dataSize = (int)((long)dataSize - pageDataSize);
        }
    }

    private void storeTimeChunkContext() {
        this.pageIndex2TimesList.add(this.pageIndex2Times);
        this.pageIndex2ChunkDataList.add(this.pageIndex2ChunkData);
        this.isTimeChunkNeedDecodeList.add(this.isTimeChunkNeedDecode);
        this.pageIndex2Times = new HashMap<Integer, long[]>();
        this.pageIndex2ChunkData = new HashMap<Integer, List<AlignedChunkData>>();
        this.isTimeChunkNeedDecode = true;
    }

    private void switchToTimeChunkContextOfCurrentMeasurement(TsFileSequenceReader reader, String measurement) throws IOException, LoadFileException {
        int index = this.valueColumn2TimeChunkIndex.getOrDefault(measurement, 0);
        if (index != this.timeChunkIndexOfCurrentValueColumn) {
            this.consumeAllAlignedChunkData(reader.position(), this.pageIndex2ChunkData);
        }
        this.timeChunkIndexOfCurrentValueColumn = index;
        this.valueColumn2TimeChunkIndex.put(measurement, index + 1);
        this.pageIndex2Times = this.pageIndex2TimesList.get(index);
        this.pageIndex2ChunkData = this.pageIndex2ChunkDataList.get(index);
        this.isTimeChunkNeedDecode = this.isTimeChunkNeedDecodeList.get(index);
    }

    private void getAllModification(Map<Long, List<Deletion>> offset2Deletions) throws IOException {
        try (ModificationFile modificationFile = new ModificationFile(this.tsFile.getAbsolutePath() + ".mods");){
            for (Modification modification : modificationFile.getModifications()) {
                offset2Deletions.computeIfAbsent(modification.getFileOffset(), o -> new ArrayList()).add((Deletion)modification);
            }
        }
    }

    private boolean checkMagic(TsFileSequenceReader reader) throws IOException {
        String magic = reader.readHeadMagic();
        if (!magic.equals("TsFile")) {
            logger.error("the file's MAGIC STRING is incorrect, file path: {}", (Object)reader.getFileName());
            return false;
        }
        byte versionNumber = reader.readVersionNumber();
        if (versionNumber != 3) {
            logger.error("the file's Version Number is incorrect, file path: {}", (Object)reader.getFileName());
            return false;
        }
        if (!reader.readTailMagic().equals("TsFile")) {
            logger.error("the file is not closed correctly, file path: {}", (Object)reader.getFileName());
            return false;
        }
        return true;
    }

    private void getChunkMetadata(TsFileSequenceReader reader, Map<Long, IChunkMetadata> offset2ChunkMetadata) throws IOException {
        Map device2Metadata = reader.getAllTimeseriesMetadata(true);
        for (Map.Entry entry : device2Metadata.entrySet()) {
            for (TimeseriesMetadata timeseriesMetadata : (List)entry.getValue()) {
                for (IChunkMetadata chunkMetadata : timeseriesMetadata.getChunkMetadataList()) {
                    offset2ChunkMetadata.put(chunkMetadata.getOffsetOfChunkHeader(), chunkMetadata);
                }
            }
        }
    }

    private void handleModification(TreeMap<Long, List<Deletion>> offset2Deletions, long chunkOffset) throws LoadFileException {
        while (!offset2Deletions.isEmpty() && offset2Deletions.firstEntry().getKey() <= chunkOffset) {
            for (Deletion deletion : offset2Deletions.pollFirstEntry().getValue()) {
                this.consumer.apply(new DeletionData(deletion));
            }
        }
    }

    private void consumeAllAlignedChunkData(long offset, Map<Integer, List<AlignedChunkData>> pageIndex2ChunkData) throws LoadFileException {
        if (pageIndex2ChunkData.isEmpty()) {
            return;
        }
        HashMap<AlignedChunkData, BatchedAlignedValueChunkData> chunkDataMap = new HashMap<AlignedChunkData, BatchedAlignedValueChunkData>();
        for (Map.Entry<Integer, List<AlignedChunkData>> entry : pageIndex2ChunkData.entrySet()) {
            List<AlignedChunkData> alignedChunkDataList = entry.getValue();
            for (int i = 0; i < alignedChunkDataList.size(); ++i) {
                AlignedChunkData oldChunkData = alignedChunkDataList.get(i);
                BatchedAlignedValueChunkData chunkData = chunkDataMap.computeIfAbsent(oldChunkData, BatchedAlignedValueChunkData::new);
                alignedChunkDataList.set(i, chunkData);
            }
        }
        for (AlignedChunkData chunkData : chunkDataMap.keySet()) {
            this.timePartitionSlots.add(chunkData.getTimePartitionSlot());
            if (this.offset2Deletions.isEmpty() && this.timePartitionSlots.size() > CONFIG.getLoadTsFileSpiltPartitionMaxSize()) {
                throw new LoadFileException(String.format("Time partition slots size is greater than %s", CONFIG.getLoadTsFileSpiltPartitionMaxSize()));
            }
            if (!Boolean.FALSE.equals(this.consumer.apply(chunkData))) continue;
            throw new IllegalStateException(String.format("Consume aligned chunk data error, next chunk offset: %d, chunkData: %s", offset, chunkData));
        }
        this.pageIndex2ChunkData = new HashMap<Integer, List<AlignedChunkData>>();
    }

    private void consumeChunkData(String measurement, long offset, ChunkData chunkData) throws LoadFileException {
        this.timePartitionSlots.add(chunkData.getTimePartitionSlot());
        if (this.offset2Deletions.isEmpty() && this.timePartitionSlots.size() > CONFIG.getLoadTsFileSpiltPartitionMaxSize()) {
            throw new LoadFileException(String.format("Time partition slots size is greater than %s", CONFIG.getLoadTsFileSpiltPartitionMaxSize()));
        }
        if (Boolean.FALSE.equals(this.consumer.apply(chunkData))) {
            throw new IllegalStateException(String.format("Consume chunkData error, chunk offset: %d, measurement: %s, chunkData: %s", offset, measurement, chunkData));
        }
    }

    private boolean needDecodeChunk(IChunkMetadata chunkMetadata) {
        return !TimePartitionUtils.getTimePartitionSlot((long)chunkMetadata.getStartTime()).equals(TimePartitionUtils.getTimePartitionSlot((long)chunkMetadata.getEndTime()));
    }

    private boolean needDecodePage(PageHeader pageHeader, IChunkMetadata chunkMetadata) {
        if (pageHeader.getStatistics() == null) {
            return !TimePartitionUtils.getTimePartitionSlot((long)chunkMetadata.getStartTime()).equals(TimePartitionUtils.getTimePartitionSlot((long)chunkMetadata.getEndTime()));
        }
        return !TimePartitionUtils.getTimePartitionSlot((long)pageHeader.getStartTime()).equals(TimePartitionUtils.getTimePartitionSlot((long)pageHeader.getEndTime()));
    }

    private Pair<long[], Object[]> decodePage(boolean isAligned, ByteBuffer pageData, PageHeader pageHeader, Decoder timeDecoder, Decoder valueDecoder, ChunkHeader chunkHeader) throws IOException {
        if (isAligned) {
            TimePageReader timePageReader = new TimePageReader(pageHeader, pageData, timeDecoder);
            long[] times = timePageReader.getNextTimeBatch();
            return new Pair((Object)times, (Object)new Object[times.length]);
        }
        valueDecoder.reset();
        PageReader pageReader = new PageReader(pageData, chunkHeader.getDataType(), valueDecoder, timeDecoder);
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        long[] times = new long[batchData.length()];
        Object[] values = new Object[batchData.length()];
        int index = 0;
        while (batchData.hasCurrent()) {
            times[index] = batchData.currentTime();
            values[index++] = batchData.currentValue();
            batchData.next();
        }
        return new Pair((Object)times, (Object)values);
    }

    private void handleEmptyValueChunk(ChunkHeader header, Map<Integer, List<AlignedChunkData>> pageIndex2ChunkData, IChunkMetadata chunkMetadata, boolean isTimeChunkNeedDecode) throws IOException {
        HashSet<AlignedChunkData> allChunkData = new HashSet<AlignedChunkData>();
        for (Map.Entry<Integer, List<AlignedChunkData>> entry : pageIndex2ChunkData.entrySet()) {
            for (AlignedChunkData alignedChunkData : entry.getValue()) {
                if (allChunkData.contains(alignedChunkData)) continue;
                alignedChunkData.addValueChunk(header);
                if (!isTimeChunkNeedDecode) {
                    alignedChunkData.writeEntireChunk(ByteBuffer.allocate(0), chunkMetadata);
                } else {
                    alignedChunkData.writeEntirePage(new PageHeader(0, 0, chunkMetadata.getStatistics()), ByteBuffer.allocate(0));
                }
                allChunkData.add(alignedChunkData);
            }
        }
    }

    private boolean isEmptyPage(PageHeader pageHeader) {
        return pageHeader.getUncompressedSize() == 0 && pageHeader.getCompressedSize() == 0 && pageHeader.getStatistics() == null;
    }

    private TsPrimitiveType[] decodeValuePage(TsFileSequenceReader reader, ChunkHeader chunkHeader, PageHeader pageHeader, long[] times, Decoder valueDecoder) throws IOException {
        if (pageHeader.getSerializedPageSize() == 0) {
            return new TsPrimitiveType[times.length];
        }
        valueDecoder.reset();
        ByteBuffer pageData = reader.readPage(pageHeader, chunkHeader.getCompressionType());
        ValuePageReader valuePageReader = new ValuePageReader(pageHeader, pageData, chunkHeader.getDataType(), valueDecoder);
        return valuePageReader.nextValueBatch(times);
    }

    @FunctionalInterface
    public static interface TsFileDataConsumer {
        public boolean apply(TsFileData var1) throws LoadFileException;
    }
}

