/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.JoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.AbstractMergeSortJoinOperator;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;

public class MergeSortSemiJoinOperator
extends AbstractMergeSortJoinOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(MergeSortSemiJoinOperator.class);
    private final int outputColumnNum;
    private boolean rightHasNullValue = false;

    public MergeSortSemiJoinOperator(OperatorContext operatorContext, Operator leftChild, int leftJoinKeyPosition, int[] leftOutputSymbolIdx, Operator rightChild, int rightJoinKeyPosition, JoinKeyComparator joinKeyComparator, List<TSDataType> dataTypes) {
        super(operatorContext, leftChild, new int[]{leftJoinKeyPosition}, leftOutputSymbolIdx, rightChild, new int[]{rightJoinKeyPosition}, null, Collections.singletonList(joinKeyComparator), dataTypes);
        this.outputColumnNum = dataTypes.size();
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.retainedTsBlock != null) {
            return true;
        }
        return !this.leftFinished;
    }

    @Override
    protected boolean prepareInput() throws Exception {
        this.gotCandidateBlocks();
        if (this.rightFinished) {
            return this.leftBlockNotEmpty();
        }
        return this.leftBlockNotEmpty() && this.rightBlockNotEmpty() && this.gotNextRightBlock();
    }

    @Override
    protected boolean processFinished() {
        if (this.rightFinished) {
            this.appendAllLeftBlock();
            return true;
        }
        while (this.currentRightHasNullValue()) {
            this.rightHasNullValue = true;
            if (!this.rightFinishedWithIncIndex()) continue;
            return true;
        }
        if (this.allRightLessThanLeft()) {
            this.resetRightBlockList();
            return true;
        }
        if (this.allLeftLessThanRight()) {
            this.appendAllLeftBlock();
            this.resetLeftBlock();
            return true;
        }
        while (this.lessThan((TsBlock)this.rightBlockList.get(this.rightBlockListIdx), this.rightJoinKeyPositions, this.rightIndex, this.leftBlock, this.leftJoinKeyPositions, this.leftIndex)) {
            if (!this.rightFinishedWithIncIndex()) continue;
            return true;
        }
        if (this.currentRoundNeedStop()) {
            return true;
        }
        while (this.currentLeftHasNullValue()) {
            this.appendNullValueToResult();
            if (!this.leftFinishedWithIncIndex()) continue;
            return true;
        }
        while (this.lessThan(this.leftBlock, this.leftJoinKeyPositions, this.leftIndex, (TsBlock)this.rightBlockList.get(this.rightBlockListIdx), this.rightJoinKeyPositions, this.rightIndex)) {
            this.appendWhenNotMatch();
            ++this.leftIndex;
            if (this.leftIndex < this.leftBlock.getPositionCount()) continue;
            this.resetLeftBlock();
            return true;
        }
        if (this.currentRoundNeedStop()) {
            return true;
        }
        return this.hasMatchedRightValueToProbeLeft() && this.leftFinishedWithIncIndex();
    }

    @Override
    protected boolean hasMatchedRightValueToProbeLeft() {
        boolean matches = this.equalsTo(this.leftBlock, this.leftJoinKeyPositions, this.leftIndex, (TsBlock)this.rightBlockList.get(this.rightBlockListIdx), this.rightJoinKeyPositions, this.rightIndex);
        if (matches) {
            this.appendValueToResult(true);
        } else {
            this.appendWhenNotMatch();
        }
        return matches;
    }

    private void appendWhenNotMatch() {
        if (!this.rightHasNullValue) {
            this.appendValueToResult(false);
        } else {
            this.appendNullValueToResult();
        }
    }

    private void appendValueToResult(boolean matches) {
        this.appendLeftBlockData(this.leftOutputSymbolIdx, this.resultBuilder, this.leftBlock, this.leftIndex);
        ColumnBuilder columnBuilder = this.resultBuilder.getColumnBuilder(this.outputColumnNum - 1);
        columnBuilder.writeBoolean(matches);
        this.resultBuilder.declarePosition();
    }

    private void appendNullValueToResult() {
        this.appendLeftBlockData(this.leftOutputSymbolIdx, this.resultBuilder, this.leftBlock, this.leftIndex);
        ColumnBuilder columnBuilder = this.resultBuilder.getColumnBuilder(this.outputColumnNum - 1);
        columnBuilder.appendNull();
        this.resultBuilder.declarePosition();
    }

    private void appendAllLeftBlock() {
        if (this.rightHasNullValue) {
            while (this.leftBlockNotEmpty()) {
                this.appendNullValueToResult();
                ++this.leftIndex;
            }
        } else {
            while (this.leftBlockNotEmpty()) {
                this.appendValueToResult(false);
                ++this.leftIndex;
            }
        }
    }

    @Override
    protected void recordsWhenDataMatches() {
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.leftChild) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.rightChild) + RamUsageEstimator.sizeOf((int[])this.leftOutputSymbolIdx) + RamUsageEstimator.sizeOf((int[])this.rightOutputSymbolIdx) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + this.resultBuilder.getRetainedSizeInBytes();
    }
}

