/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.jts;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.jena.geosparql.implementation.WKTLiteralFactory;
import org.apache.jena.geosparql.implementation.jts.CoordinateSequenceDimensions;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;

public class CustomCoordinateSequence
implements CoordinateSequence,
Serializable {
    private static final long serialVersionUID = 1L;
    private final double[] x;
    private final double[] y;
    private final double[] z;
    private final double[] m;
    private final int size;
    private final int coordinateDimension;
    private final int spatialDimension;
    private final int measuresDimension;
    private final CoordinateSequenceDimensions dimensions;

    public CustomCoordinateSequence() {
        this.size = 0;
        this.x = new double[this.size];
        this.y = new double[this.size];
        this.z = new double[this.size];
        this.m = new double[this.size];
        this.coordinateDimension = 4;
        this.spatialDimension = 3;
        this.dimensions = CoordinateSequenceDimensions.XYZM;
        this.measuresDimension = 1;
    }

    public CustomCoordinateSequence(int size, CoordinateSequenceDimensions dimensions) {
        this.size = size;
        this.x = new double[size];
        this.y = new double[size];
        this.z = new double[size];
        this.m = new double[size];
        for (int i = 0; i < size; ++i) {
            this.x[i] = Double.NaN;
            this.y[i] = Double.NaN;
            this.z[i] = Double.NaN;
            this.m[i] = Double.NaN;
        }
        int[] dims = CustomCoordinateSequence.getDimensionValues(dimensions);
        this.coordinateDimension = dims[0];
        this.spatialDimension = dims[1];
        this.dimensions = dimensions;
        this.measuresDimension = dimensions.equals((Object)CoordinateSequenceDimensions.XYM) || dimensions.equals((Object)CoordinateSequenceDimensions.XYZM) ? 1 : 0;
    }

    public CustomCoordinateSequence(int size, int dimension) {
        this.size = size;
        this.x = new double[size];
        this.y = new double[size];
        this.z = new double[size];
        this.m = new double[size];
        for (int i = 0; i < size; ++i) {
            this.x[i] = Double.NaN;
            this.y[i] = Double.NaN;
            this.z[i] = Double.NaN;
            this.m[i] = Double.NaN;
        }
        this.coordinateDimension = dimension;
        if (dimension == 4) {
            this.spatialDimension = 3;
            this.dimensions = CoordinateSequenceDimensions.XYZM;
            this.measuresDimension = 1;
        } else {
            this.spatialDimension = dimension;
            this.dimensions = dimension == 2 ? CoordinateSequenceDimensions.XY : CoordinateSequenceDimensions.XYZ;
            this.measuresDimension = 0;
        }
    }

    public CustomCoordinateSequence(CoordinateSequenceDimensions dimensions) {
        this(dimensions, "");
    }

    public CustomCoordinateSequence(CoordinateSequenceDimensions dimensions, List<Coordinate> coordinates) {
        this.dimensions = dimensions;
        if (!coordinates.isEmpty()) {
            this.size = coordinates.size();
            this.x = new double[this.size];
            this.y = new double[this.size];
            this.z = new double[this.size];
            this.m = new double[this.size];
            block5: for (int i = 0; i < this.size; ++i) {
                Coordinate coord = coordinates.get(i);
                switch (dimensions) {
                    default: {
                        this.x[i] = coord.getX();
                        this.y[i] = coord.getY();
                        this.z[i] = Double.NaN;
                        this.m[i] = Double.NaN;
                        continue block5;
                    }
                    case XYZ: {
                        this.x[i] = coord.getX();
                        this.y[i] = coord.getY();
                        this.z[i] = coord.getZ();
                        this.m[i] = Double.NaN;
                        continue block5;
                    }
                    case XYM: {
                        this.x[i] = coord.getX();
                        this.y[i] = coord.getY();
                        this.z[i] = Double.NaN;
                        this.m[i] = coord.getM();
                        continue block5;
                    }
                    case XYZM: {
                        this.x[i] = coord.getX();
                        this.y[i] = coord.getY();
                        this.z[i] = coord.getZ();
                        this.m[i] = coord.getM();
                    }
                }
            }
        } else {
            this.size = 0;
            this.x = new double[this.size];
            this.y = new double[this.size];
            this.z = new double[this.size];
            this.m = new double[this.size];
        }
        int[] dims = CustomCoordinateSequence.getDimensionValues(dimensions);
        this.coordinateDimension = dims[0];
        this.spatialDimension = dims[1];
        this.measuresDimension = dimensions.equals((Object)CoordinateSequenceDimensions.XYM) || dimensions.equals((Object)CoordinateSequenceDimensions.XYZM) ? 1 : 0;
    }

    public CustomCoordinateSequence(CoordinateSequenceDimensions dimensions, String sequence) {
        this.dimensions = dimensions;
        if (!sequence.isEmpty()) {
            String[] parts = sequence.split(",");
            this.size = parts.length;
            this.x = new double[this.size];
            this.y = new double[this.size];
            this.z = new double[this.size];
            this.m = new double[this.size];
            block5: for (int i = 0; i < this.size; ++i) {
                String part = parts[i].trim();
                String[] coords = part.split(" ");
                switch (dimensions) {
                    default: {
                        this.x[i] = Double.parseDouble(coords[0]);
                        this.y[i] = Double.parseDouble(coords[1]);
                        this.z[i] = Double.NaN;
                        this.m[i] = Double.NaN;
                        continue block5;
                    }
                    case XYZ: {
                        this.x[i] = Double.parseDouble(coords[0]);
                        this.y[i] = Double.parseDouble(coords[1]);
                        this.z[i] = Double.parseDouble(coords[2]);
                        this.m[i] = Double.NaN;
                        continue block5;
                    }
                    case XYM: {
                        this.x[i] = Double.parseDouble(coords[0]);
                        this.y[i] = Double.parseDouble(coords[1]);
                        this.z[i] = Double.NaN;
                        this.m[i] = Double.parseDouble(coords[2]);
                        continue block5;
                    }
                    case XYZM: {
                        this.x[i] = Double.parseDouble(coords[0]);
                        this.y[i] = Double.parseDouble(coords[1]);
                        this.z[i] = Double.parseDouble(coords[2]);
                        this.m[i] = Double.parseDouble(coords[3]);
                    }
                }
            }
        } else {
            this.size = 0;
            this.x = new double[this.size];
            this.y = new double[this.size];
            this.z = new double[this.size];
            this.m = new double[this.size];
        }
        int[] dims = CustomCoordinateSequence.getDimensionValues(dimensions);
        this.coordinateDimension = dims[0];
        this.spatialDimension = dims[1];
        this.measuresDimension = dimensions.equals((Object)CoordinateSequenceDimensions.XYM) || dimensions.equals((Object)CoordinateSequenceDimensions.XYZM) ? 1 : 0;
    }

    @Override
    public CustomCoordinateSequence copy() {
        return new CustomCoordinateSequence(this.x, this.y, this.z, this.m);
    }

    public int getSize() {
        return this.size;
    }

    private static int[] getDimensionValues(CoordinateSequenceDimensions dimensions) {
        int coordinateDimension;
        return new int[]{coordinateDimension, switch (dimensions) {
            default -> {
                coordinateDimension = 2;
                yield 2;
            }
            case CoordinateSequenceDimensions.XYZ -> {
                coordinateDimension = 3;
                yield 3;
            }
            case CoordinateSequenceDimensions.XYM -> {
                coordinateDimension = 3;
                yield 2;
            }
            case CoordinateSequenceDimensions.XYZM -> {
                coordinateDimension = 4;
                yield 3;
            }
        }};
    }

    public CustomCoordinateSequence(Coordinate[] coordinates) {
        this.size = coordinates.length;
        this.x = new double[this.size];
        this.y = new double[this.size];
        this.z = new double[this.size];
        this.m = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.x[i] = coordinates[i].getX();
            this.y[i] = coordinates[i].getY();
            this.z[i] = coordinates[i].getZ();
            this.m[i] = Double.NaN;
        }
        boolean isZPresent = this.checkDimensionality(this.z);
        if (isZPresent) {
            this.coordinateDimension = 3;
            this.spatialDimension = 3;
            this.dimensions = CoordinateSequenceDimensions.XYZ;
        } else {
            this.coordinateDimension = 2;
            this.spatialDimension = 2;
            this.dimensions = CoordinateSequenceDimensions.XY;
        }
        this.measuresDimension = 0;
    }

    public static final CustomCoordinateSequence createPoint(double x, double y) {
        return new CustomCoordinateSequence(new double[]{x}, new double[]{y}, new double[]{Double.NaN}, new double[]{Double.NaN});
    }

    public CustomCoordinateSequence(double[] x, double[] y, double[] z, double[] m) {
        this.size = x.length;
        this.x = new double[this.size];
        this.y = new double[this.size];
        this.z = new double[this.size];
        this.m = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.x[i] = x[i];
            this.y[i] = y[i];
            this.z[i] = z[i];
            this.m[i] = m[i];
        }
        boolean isZPresent = this.checkDimensionality(this.z);
        boolean isMPresent = this.checkDimensionality(this.m);
        if (!isZPresent && !isMPresent) {
            this.coordinateDimension = 2;
            this.spatialDimension = 2;
            this.dimensions = CoordinateSequenceDimensions.XY;
            this.measuresDimension = 0;
        } else if (isZPresent && !isMPresent) {
            this.coordinateDimension = 3;
            this.spatialDimension = 3;
            this.dimensions = CoordinateSequenceDimensions.XYZ;
            this.measuresDimension = 0;
        } else if (!isZPresent && isMPresent) {
            this.coordinateDimension = 3;
            this.spatialDimension = 2;
            this.dimensions = CoordinateSequenceDimensions.XYM;
            this.measuresDimension = 1;
        } else {
            this.coordinateDimension = 4;
            this.spatialDimension = 3;
            this.dimensions = CoordinateSequenceDimensions.XYZM;
            this.measuresDimension = 1;
        }
    }

    private boolean checkDimensionality(double[] dim) {
        if (dim.length > 0) {
            return !Double.isNaN(dim[0]);
        }
        return false;
    }

    @Override
    public int getDimension() {
        return this.coordinateDimension;
    }

    @Override
    public int getMeasures() {
        return this.measuresDimension;
    }

    @Override
    public boolean hasZ() {
        return this.spatialDimension > 2;
    }

    @Override
    public boolean hasM() {
        return this.measuresDimension == 1;
    }

    public CoordinateSequenceDimensions getDimensions() {
        return this.dimensions;
    }

    public int getSpatialDimension() {
        return this.spatialDimension;
    }

    @Override
    public Coordinate getCoordinate(int i) {
        return new Coordinate(this.x[i], this.y[i], this.z[i]);
    }

    @Override
    public Coordinate getCoordinateCopy(int i) {
        return new Coordinate(this.x[i], this.y[i], this.z[i]);
    }

    @Override
    public void getCoordinate(int index, Coordinate coord) {
        coord.setX(this.x[index]);
        coord.setY(this.y[index]);
        if (this.spatialDimension > 2) {
            coord.setZ(this.z[index]);
        }
        if (this.measuresDimension == 1) {
            coord.setM(this.m[index]);
        }
    }

    @Override
    public double getX(int index) {
        return this.x[index];
    }

    @Override
    public double getY(int index) {
        return this.y[index];
    }

    @Override
    public double getZ(int index) {
        return this.z[index];
    }

    @Override
    public double getM(int index) {
        return this.m[index];
    }

    @Override
    public double getOrdinate(int index, int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.x[index];
            }
            case 1: {
                return this.y[index];
            }
            case 2: {
                return this.z[index];
            }
            case 3: {
                return this.m[index];
            }
        }
        return Double.NaN;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void setOrdinate(int index, int ordinateIndex, double value) {
        switch (ordinateIndex) {
            case 0: {
                this.x[index] = value;
                break;
            }
            case 1: {
                this.y[index] = value;
                break;
            }
            case 2: {
                this.z[index] = value;
                break;
            }
            case 3: {
                this.m[index] = value;
            }
        }
    }

    @Override
    public Coordinate[] toCoordinateArray() {
        Coordinate[] coordinates = new Coordinate[this.size];
        for (int i = 0; i < this.size; ++i) {
            coordinates[i] = new Coordinate(this.x[i], this.y[i], this.z[i]);
        }
        return coordinates;
    }

    @Override
    public Envelope expandEnvelope(Envelope env) {
        Envelope newEnv = new Envelope(env);
        for (int i = 0; i < this.size; ++i) {
            newEnv.expandToInclude(this.x[i], this.y[i]);
        }
        return newEnv;
    }

    @Override
    @Deprecated
    public CustomCoordinateSequence clone() {
        return new CustomCoordinateSequence(this.x, this.y, this.z, this.m);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Arrays.hashCode(this.x);
        hash = 67 * hash + Arrays.hashCode(this.y);
        hash = 67 * hash + Arrays.hashCode(this.z);
        hash = 67 * hash + Arrays.hashCode(this.m);
        hash = 67 * hash + this.size;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomCoordinateSequence other = (CustomCoordinateSequence)obj;
        if (this.size != other.size) {
            return false;
        }
        if (!Arrays.equals(this.x, other.x)) {
            return false;
        }
        if (!Arrays.equals(this.y, other.y)) {
            return false;
        }
        if (!Arrays.equals(this.z, other.z)) {
            return false;
        }
        return Arrays.equals(this.m, other.m);
    }

    public String toString() {
        return "CustomCoordinateSequence{x=" + Arrays.toString(this.x) + ", y=" + Arrays.toString(this.y) + ", z=" + Arrays.toString(this.z) + ", m=" + Arrays.toString(this.m) + ", size=" + this.size + "}";
    }

    public String getCoordinateText(int index) {
        StringBuilder sb = new StringBuilder();
        String xValue = WKTLiteralFactory.reducePrecision(this.x[index]);
        String yValue = WKTLiteralFactory.reducePrecision(this.y[index]);
        switch (this.dimensions) {
            case XY: {
                sb.append(xValue).append(" ").append(yValue);
                break;
            }
            case XYZ: {
                String zValue = WKTLiteralFactory.reducePrecision(this.z[index]);
                sb.append(xValue).append(" ").append(yValue).append(" ").append(zValue);
                break;
            }
            case XYM: {
                String mValue = WKTLiteralFactory.reducePrecision(this.m[index]);
                sb.append(xValue).append(" ").append(yValue).append(" ").append(mValue);
                break;
            }
            default: {
                String zValue = WKTLiteralFactory.reducePrecision(this.z[index]);
                String mValue = WKTLiteralFactory.reducePrecision(this.m[index]);
                sb.append(xValue).append(" ").append(yValue).append(" ").append(zValue).append(" ").append(mValue);
            }
        }
        return sb.toString();
    }

    public static final CoordinateSequenceDimensions findCoordinateSequenceDimensions(int coordinateDimension, int spatialDimension) {
        if (coordinateDimension == 2 && spatialDimension == 2) {
            return CoordinateSequenceDimensions.XY;
        }
        if (coordinateDimension == 3 && spatialDimension == 3) {
            return CoordinateSequenceDimensions.XYZ;
        }
        if (coordinateDimension == 3 && spatialDimension == 2) {
            return CoordinateSequenceDimensions.XYM;
        }
        return CoordinateSequenceDimensions.XYZM;
    }
}

