/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lang.sparql_12;

import java.io.Reader;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.lang.UpdateParser;
import org.apache.jena.sparql.lang.sparql_12.javacc.ParseException;
import org.apache.jena.sparql.lang.sparql_12.javacc.SPARQLParser12;
import org.apache.jena.sparql.lang.sparql_12.javacc.TokenMgrError;
import org.apache.jena.sparql.modify.UpdateSink;
import org.apache.jena.update.UpdateException;

public class ParserSPARQL12Update
extends UpdateParser {
    @Override
    protected void executeParse(UpdateSink sink, Prologue prologue, Reader r) {
        SPARQLParser12 parser = null;
        try {
            parser = new SPARQLParser12(r);
            parser.setUpdate(prologue, sink);
            parser.UpdateUnit();
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new QueryParseException(tErr.getMessage(), line, col);
        }
        catch (UpdateException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Error err) {
            throw new QueryParseException(err.getMessage(), (Throwable)err, -1, -1);
        }
        catch (Throwable th) {
            Log.error(this, "Unexpected throwable: ", th);
            throw new QueryException(th.getMessage(), th);
        }
    }
}

