/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.iso;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.util.EqualityTest;
import org.apache.jena.sparql.util.iso.IsoLib;
import org.apache.jena.sparql.util.iso.IsoMapping;

public class IsoAlgTuple {
    private static final boolean DEBUG = false;
    private static final IndentedWriter out = IsoAlgTuple.debugIndentedWriter();
    private static Function<Triple, Tuple<Node>> tripleToTuple = triple -> TupleFactory.tuple(triple.getSubject(), triple.getPredicate(), triple.getObject());

    public static boolean isIsomorphic(Collection<Tuple<Node>> x1, Collection<Tuple<Node>> x2, EqualityTest nodeTest) {
        return IsoAlgTuple.isIsomorphic(x1, x2, IsoLib.mappableBlankNodes, nodeTest);
    }

    static boolean isIsomorphic(Collection<Tuple<Node>> x1, Collection<Tuple<Node>> x2, IsoLib.Mappable mappable, EqualityTest nodeTest) {
        if (x1.size() != x2.size()) {
            return false;
        }
        return IsoAlgTuple.matcher(x1, x2, IsoMapping.rootMapping, mappable, nodeTest);
    }

    private static IsoMapping isIsomorphic(Tuple<Node> tuple1, Tuple<Node> tuple2, IsoMapping mapping, IsoLib.Mappable mappable, EqualityTest nodeTest) {
        return IsoAlgTuple.matchTuples(tuple1, tuple2, mapping, mappable, nodeTest);
    }

    private static final IndentedWriter debugIndentedWriter() {
        IndentedWriter iout = null;
        return iout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean matcher(Collection<Tuple<Node>> tuples1, Collection<Tuple<Node>> tuples2, IsoMapping mapping, IsoLib.Mappable mappable, EqualityTest nodeTest) {
        tuples2 = new HashSet<Tuple<Node>>(tuples2);
        ArrayList<Tuple<Node>> tuples1$ = new ArrayList<Tuple<Node>>();
        for (Tuple<Node> t1 : tuples1) {
            if (!IsoAlgTuple.containsMappable(t1)) {
                boolean wasPresent = tuples2.remove(t1);
                if (wasPresent) continue;
                return false;
            }
            tuples1$.add(t1);
        }
        tuples1 = tuples1$;
        if (tuples1.size() != tuples2.size()) {
            return false;
        }
        Iterator<Tuple<Node>> iterator = tuples1.iterator();
        if (!iterator.hasNext()) {
            return true;
        }
        Tuple<Node> t1 = iterator.next();
        tuples1.remove(t1);
        List<Possibility> causes = IsoAlgTuple.matcher(t1, tuples2, mapping, mappable, nodeTest);
        Iterator<Possibility> iterator2 = causes.iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                return false;
            }
            Possibility c = iterator2.next();
            Tuple<Node> t2 = c.tuple;
            tuples2.remove(t2);
            if (tuples1.isEmpty() && tuples2.isEmpty()) {
                return true;
            }
            if (IsoAlgTuple.matcher(tuples1, tuples2, c.mapping, mappable, nodeTest)) {
                return true;
            }
            tuples2.add(t2);
        }
    }

    private static boolean containsMappable(Tuple<Node> tuple) {
        for (Node n : tuple) {
            Tuple<Node> tuple1;
            boolean b;
            if (n.isBlank()) {
                return true;
            }
            if (n.isVariable()) {
                return true;
            }
            if (!n.isTripleTerm() || !(b = IsoAlgTuple.containsMappable(tuple1 = tripleToTuple.apply(n.getTriple())))) continue;
            return true;
        }
        return false;
    }

    private static List<Possibility> matcher(Tuple<Node> t1, Collection<Tuple<Node>> g2, IsoMapping mapping, IsoLib.Mappable mappable, EqualityTest nodeTest) {
        ArrayList<Possibility> matches = new ArrayList<Possibility>();
        for (Tuple<Node> t2 : g2) {
            IsoMapping step = IsoAlgTuple.matchTuples(t1, t2, mapping, mappable, nodeTest);
            if (step == null) continue;
            Possibility c = new Possibility(t2, step);
            matches.add(c);
        }
        return matches;
    }

    private static IsoMapping matchTuples(Tuple<Node> t1, Tuple<Node> t2, IsoMapping _mapping, IsoLib.Mappable mappable, EqualityTest nodeTest) {
        if (t1.len() != t2.len()) {
            return null;
        }
        IsoMapping mapping = _mapping;
        for (int i = 0; i < t1.len(); ++i) {
            Node n2;
            Node n1 = t1.get(i);
            IsoMapping mapping2 = IsoAlgTuple.matchTerms(n1, n2 = t2.get(i), mapping, mappable, nodeTest);
            if (mapping2 == null) {
                return null;
            }
            mapping = mapping2;
        }
        return mapping;
    }

    static IsoMapping matchTerms(Node n1, Node n2, IsoMapping _mapping, IsoLib.Mappable mappable, EqualityTest nodeTest) {
        IsoMapping mapping = _mapping;
        Node n1m = mapping.map(n1);
        if (n1m != null) {
            if (n1m.equals(n2)) {
                return mapping;
            }
            return null;
        }
        if (n1.isTripleTerm()) {
            if (n2.isTripleTerm()) {
                Triple t1 = n1.getTriple();
                Triple t2 = n2.getTriple();
                Tuple<Node> tuple1 = tripleToTuple.apply(t1);
                Tuple<Node> tuple2 = tripleToTuple.apply(t2);
                return IsoAlgTuple.matchTuples(tuple1, tuple2, mapping, mappable, nodeTest);
            }
        } else if (n2.isTripleTerm()) {
            return null;
        }
        if (mappable.mappable(n1, n2)) {
            if (mapping.reverseMapped(n2)) {
                return null;
            }
            mapping = new IsoMapping(mapping, n1, n2);
            return mapping;
        }
        if (!nodeTest.equal(n1, n2)) {
            return null;
        }
        return mapping;
    }

    private record Possibility(Tuple<Node> tuple, IsoMapping mapping) {
        @Override
        public String toString() {
            return String.format("Poss|%s %s|", this.tuple, this.mapping);
        }
    }
}

