/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.coverage;

import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Geometry;

class VertexRingCounter
implements CoordinateSequenceFilter {
    private Map<Coordinate, Integer> vertexRingCount;

    public static Map<Coordinate, Integer> count(Geometry[] geoms) {
        HashMap<Coordinate, Integer> vertexRingCount = new HashMap<Coordinate, Integer>();
        VertexRingCounter counter = new VertexRingCounter(vertexRingCount);
        for (Geometry geom : geoms) {
            geom.apply(counter);
        }
        return vertexRingCount;
    }

    public VertexRingCounter(Map<Coordinate, Integer> vertexRingCount) {
        this.vertexRingCount = vertexRingCount;
    }

    @Override
    public void filter(CoordinateSequence seq2, int i) {
        if (CoordinateSequences.isRing(seq2) && i == 0) {
            return;
        }
        Coordinate v = seq2.getCoordinate(i);
        int count = this.vertexRingCount.containsKey(v) ? this.vertexRingCount.get(v) : 0;
        this.vertexRingCount.put(v, ++count);
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean isGeometryChanged() {
        return false;
    }
}

