/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

public class EntityValidator {
    private final String value;
    private final boolean isWeak;

    protected EntityValidator(String value) {
        value = value.trim();
        this.isWeak = value.startsWith("W/");
        if (this.isWeak) {
            value = value.substring(2);
        }
        if (value.length() > 1 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            value = value.substring(1, value.length() - 1);
        }
        this.value = value;
    }

    public String asString() {
        return this.value;
    }

    public boolean isWeak() {
        return this.isWeak;
    }

    public boolean isAny() {
        return "*".equals(this.value);
    }

    public String toString() {
        return (this.isWeak ? "W/" : "") + (this.isAny() ? "*" : '\"' + this.value + '\"');
    }
}

