/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.common.internal.StringUtils;

public enum Enablement {
    ALWAYS,
    CONDITIONAL,
    NEVER;

    private static final Map<String, Enablement> MAP;

    public static Enablement fromString(String s) {
        return MAP.get(StringUtils.emptyIfNull(s).toUpperCase());
    }

    public boolean isOneOf(Enablement ... values) {
        for (Enablement v : values) {
            if (this != v) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled(boolean def) {
        if (this == ALWAYS) {
            return true;
        }
        if (this == NEVER) {
            return false;
        }
        return def;
    }

    static {
        MAP = new HashMap<String, Enablement>();
        MAP.put("TRUE", ALWAYS);
        MAP.put("ALWAYS", ALWAYS);
        MAP.put("FALSE", NEVER);
        MAP.put("NEVER", NEVER);
        MAP.put("CONDITIONAL", CONDITIONAL);
    }
}

