/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.annotation;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.function.Predicate;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.Enablement;
import org.apache.juneau.MediaType;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.annotation.OpSwagger;
import org.apache.juneau.rest.annotation.OpSwaggerAnnotation;
import org.apache.juneau.rest.annotation.RestOp;
import org.apache.juneau.rest.converter.RestConverter;
import org.apache.juneau.rest.guard.RestGuard;
import org.apache.juneau.rest.httppart.BasicNamedAttribute;
import org.apache.juneau.rest.httppart.NamedAttribute;
import org.apache.juneau.rest.matcher.RestMatcher;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.svl.VarResolverSession;

public class RestOpAnnotation {
    public static final RestOp DEFAULT = RestOpAnnotation.create().build();
    public static final Predicate<AnnotationInfo<?>> REST_OP_GROUP = x -> x.isInGroup(RestOp.class);

    public static Builder create() {
        return new Builder();
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderM {
        private String[] description = new String[0];
        private Class<? extends RestConverter>[] converters = new Class[0];
        private Class<? extends RestGuard>[] guards = new Class[0];
        private Class<? extends RestMatcher>[] matchers = new Class[0];
        private Class<? extends Encoder>[] encoders = new Class[0];
        private Class<? extends Serializer>[] serializers = new Class[0];
        private Class<?>[] parsers = new Class[0];
        private OpSwagger swagger = OpSwaggerAnnotation.DEFAULT;
        private String clientVersion = "";
        private String debug = "";
        private String defaultAccept = "";
        private String defaultCharset = "";
        private String defaultContentType = "";
        private String maxInput = "";
        private String method = "";
        private String rolesDeclared = "";
        private String roleGuard = "";
        private String summary = "";
        private String value = "";
        private String[] consumes = new String[0];
        private String[] defaultRequestFormData = new String[0];
        private String[] defaultRequestQueryData = new String[0];
        private String[] defaultRequestAttributes = new String[0];
        private String[] defaultRequestHeaders = new String[0];
        private String[] defaultResponseHeaders = new String[0];
        private String[] path = new String[0];
        private String[] produces = new String[0];

        protected Builder() {
            super(RestOp.class);
        }

        public RestOp build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder clientVersion(String value) {
            this.clientVersion = value;
            return this;
        }

        public Builder consumes(String ... value) {
            this.consumes = value;
            return this;
        }

        @SafeVarargs
        public final Builder converters(Class<? extends RestConverter> ... value) {
            this.converters = value;
            return this;
        }

        public Builder debug(String value) {
            this.debug = value;
            return this;
        }

        public Builder defaultAccept(String value) {
            this.defaultAccept = value;
            return this;
        }

        public Builder defaultCharset(String value) {
            this.defaultCharset = value;
            return this;
        }

        public Builder defaultContentType(String value) {
            this.defaultContentType = value;
            return this;
        }

        public Builder defaultRequestAttributes(String ... value) {
            this.defaultRequestAttributes = value;
            return this;
        }

        public Builder defaultRequestFormData(String ... value) {
            this.defaultRequestFormData = value;
            return this;
        }

        public Builder defaultRequestHeaders(String ... value) {
            this.defaultRequestHeaders = value;
            return this;
        }

        public Builder defaultRequestQueryData(String ... value) {
            this.defaultRequestQueryData = value;
            return this;
        }

        public Builder defaultResponseHeaders(String ... value) {
            this.defaultResponseHeaders = value;
            return this;
        }

        @SafeVarargs
        public final Builder encoders(Class<? extends Encoder> ... value) {
            this.encoders = value;
            return this;
        }

        @SafeVarargs
        public final Builder guards(Class<? extends RestGuard> ... value) {
            this.guards = value;
            return this;
        }

        @SafeVarargs
        public final Builder matchers(Class<? extends RestMatcher> ... value) {
            this.matchers = value;
            return this;
        }

        public Builder maxInput(String value) {
            this.maxInput = value;
            return this;
        }

        public Builder method(String value) {
            this.method = value;
            return this;
        }

        public Builder parsers(Class<?> ... value) {
            this.parsers = value;
            return this;
        }

        public Builder path(String ... value) {
            this.path = value;
            return this;
        }

        public Builder produces(String ... value) {
            this.produces = value;
            return this;
        }

        public Builder roleGuard(String value) {
            this.roleGuard = value;
            return this;
        }

        public Builder rolesDeclared(String value) {
            this.rolesDeclared = value;
            return this;
        }

        @SafeVarargs
        public final Builder serializers(Class<? extends Serializer> ... value) {
            this.serializers = value;
            return this;
        }

        public Builder summary(String value) {
            this.summary = value;
            return this;
        }

        public Builder swagger(OpSwagger value) {
            this.swagger = value;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }

        public Builder on(MethodInfo ... value) {
            super.on(value);
            return this;
        }
    }

    private static class Object
    extends AppliedAnnotationObject
    implements RestOp {
        private final String[] description;
        private final Class<? extends RestConverter>[] converters;
        private final Class<? extends RestGuard>[] guards;
        private final Class<? extends RestMatcher>[] matchers;
        private final Class<? extends Encoder>[] encoders;
        private final Class<? extends Serializer>[] serializers;
        private final Class<?>[] parsers;
        private final OpSwagger swagger;
        private final String clientVersion;
        private final String debug;
        private final String defaultAccept;
        private final String defaultCharset;
        private final String defaultContentType;
        private final String maxInput;
        private final String method;
        private final String rolesDeclared;
        private final String roleGuard;
        private final String summary;
        private final String value;
        private final String[] consumes;
        private final String[] defaultRequestFormData;
        private final String[] defaultRequestQueryData;
        private final String[] defaultRequestAttributes;
        private final String[] defaultRequestHeaders;
        private final String[] defaultResponseHeaders;
        private final String[] path;
        private final String[] produces;

        Object(Builder b) {
            super((AppliedAnnotationObject.Builder)b);
            this.description = (String[])CollectionUtils.copyOf((java.lang.Object[])b.description);
            this.clientVersion = b.clientVersion;
            this.consumes = (String[])CollectionUtils.copyOf((java.lang.Object[])b.consumes);
            this.converters = (Class[])CollectionUtils.copyOf((java.lang.Object[])b.converters);
            this.debug = b.debug;
            this.defaultAccept = b.defaultAccept;
            this.defaultCharset = b.defaultCharset;
            this.defaultContentType = b.defaultContentType;
            this.defaultRequestFormData = (String[])CollectionUtils.copyOf((java.lang.Object[])b.defaultRequestFormData);
            this.defaultRequestQueryData = (String[])CollectionUtils.copyOf((java.lang.Object[])b.defaultRequestQueryData);
            this.defaultRequestAttributes = (String[])CollectionUtils.copyOf((java.lang.Object[])b.defaultRequestAttributes);
            this.defaultRequestHeaders = (String[])CollectionUtils.copyOf((java.lang.Object[])b.defaultRequestHeaders);
            this.defaultResponseHeaders = (String[])CollectionUtils.copyOf((java.lang.Object[])b.defaultResponseHeaders);
            this.encoders = (Class[])CollectionUtils.copyOf((java.lang.Object[])b.encoders);
            this.guards = (Class[])CollectionUtils.copyOf((java.lang.Object[])b.guards);
            this.matchers = (Class[])CollectionUtils.copyOf((java.lang.Object[])b.matchers);
            this.maxInput = b.maxInput;
            this.method = b.method;
            this.parsers = (Class[])CollectionUtils.copyOf((java.lang.Object[])b.parsers);
            this.path = (String[])CollectionUtils.copyOf((java.lang.Object[])b.path);
            this.produces = (String[])CollectionUtils.copyOf((java.lang.Object[])b.produces);
            this.roleGuard = b.roleGuard;
            this.rolesDeclared = b.rolesDeclared;
            this.serializers = (Class[])CollectionUtils.copyOf((java.lang.Object[])b.serializers);
            this.summary = b.summary;
            this.swagger = b.swagger;
            this.value = b.value;
        }

        @Override
        public String clientVersion() {
            return this.clientVersion;
        }

        @Override
        public String[] consumes() {
            return this.consumes;
        }

        @Override
        public Class<? extends RestConverter>[] converters() {
            return this.converters;
        }

        @Override
        public String debug() {
            return this.debug;
        }

        @Override
        public String defaultAccept() {
            return this.defaultAccept;
        }

        @Override
        public String defaultCharset() {
            return this.defaultCharset;
        }

        @Override
        public String defaultContentType() {
            return this.defaultContentType;
        }

        @Override
        public String[] defaultRequestAttributes() {
            return this.defaultRequestAttributes;
        }

        @Override
        public String[] defaultRequestFormData() {
            return this.defaultRequestFormData;
        }

        @Override
        public String[] defaultRequestHeaders() {
            return this.defaultRequestHeaders;
        }

        @Override
        public String[] defaultRequestQueryData() {
            return this.defaultRequestQueryData;
        }

        @Override
        public String[] defaultResponseHeaders() {
            return this.defaultResponseHeaders;
        }

        @Override
        public Class<? extends Encoder>[] encoders() {
            return this.encoders;
        }

        @Override
        public Class<? extends RestGuard>[] guards() {
            return this.guards;
        }

        @Override
        public Class<? extends RestMatcher>[] matchers() {
            return this.matchers;
        }

        @Override
        public String maxInput() {
            return this.maxInput;
        }

        @Override
        public String method() {
            return this.method;
        }

        @Override
        public Class<?>[] parsers() {
            return this.parsers;
        }

        @Override
        public String[] path() {
            return this.path;
        }

        @Override
        public String[] produces() {
            return this.produces;
        }

        @Override
        public String roleGuard() {
            return this.roleGuard;
        }

        @Override
        public String rolesDeclared() {
            return this.rolesDeclared;
        }

        @Override
        public Class<? extends Serializer>[] serializers() {
            return this.serializers;
        }

        @Override
        public String summary() {
            return this.summary;
        }

        @Override
        public OpSwagger swagger() {
            return this.swagger;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    public static class RestOpContextApply
    extends AnnotationApplier<RestOp, RestOpContext.Builder> {
        public RestOpContextApply(VarResolverSession vr) {
            super(RestOp.class, RestOpContext.Builder.class, vr);
        }

        public void apply(AnnotationInfo<RestOp> ai, RestOpContext.Builder b) {
            RestOp a = (RestOp)ai.inner();
            this.classes(a.serializers()).ifPresent(x -> b.serializers().set(x));
            this.classes(a.parsers()).ifPresent(x -> b.parsers().set(x));
            this.classes(a.encoders()).ifPresent(x -> b.encoders().set(x));
            this.stream(a.produces()).map(MediaType::of).forEach(x -> b.produces((MediaType)x));
            this.stream(a.consumes()).map(MediaType::of).forEach(x -> b.consumes((MediaType)x));
            this.stream(a.defaultRequestHeaders()).map(HttpHeaders::stringHeader).forEach(x -> b.defaultRequestHeaders().setDefault(new Header[]{x}));
            this.stream(a.defaultResponseHeaders()).map(HttpHeaders::stringHeader).forEach(x -> b.defaultResponseHeaders().setDefault(new Header[]{x}));
            this.stream(a.defaultRequestAttributes()).map(BasicNamedAttribute::ofPair).forEach(x -> b.defaultRequestAttributes().add((NamedAttribute)x));
            this.stream(a.defaultRequestQueryData()).map(HttpParts::basicPart).forEach(x -> b.defaultRequestQueryData().setDefault(new NameValuePair[]{x}));
            this.stream(a.defaultRequestFormData()).map(HttpParts::basicPart).forEach(x -> b.defaultRequestFormData().setDefault(new NameValuePair[]{x}));
            this.string(a.defaultAccept()).map(HttpHeaders::accept).ifPresent(x -> b.defaultRequestHeaders().setDefault(new Header[]{x}));
            this.string(a.defaultContentType()).map(HttpHeaders::contentType).ifPresent(x -> b.defaultRequestHeaders().setDefault(new Header[]{x}));
            b.converters().append(a.converters());
            b.guards().append(a.guards());
            b.matchers().append(a.matchers());
            this.string(a.clientVersion()).ifPresent(x -> b.clientVersion((String)x));
            this.string(a.defaultCharset()).map(Charset::forName).ifPresent(x -> b.defaultCharset((Charset)x));
            this.string(a.maxInput()).ifPresent(x -> b.maxInput((String)x));
            this.stream(a.path()).forEach(x -> b.path((String)x));
            this.cdl(a.rolesDeclared()).forEach(x -> b.rolesDeclared((String)x));
            this.string(a.roleGuard()).ifPresent(x -> b.roleGuard((String)x));
            this.string(a.method()).ifPresent(x -> b.httpMethod((String)x));
            this.string(a.debug()).map(Enablement::fromString).ifPresent(x -> b.debug((Enablement)x));
            String v = StringUtils.trim((String)this.string(a.value()).orElse(null));
            if (Utils.nn((java.lang.Object)v)) {
                int i = v.indexOf(32);
                if (i == -1) {
                    b.httpMethod(v);
                } else {
                    b.httpMethod(v.substring(0, i).trim());
                    b.path(v.substring(i).trim());
                }
            }
        }
    }
}

