/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.junit.bct;

import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.juneau.junit.bct.Swapper;

public class Swappers {
    public static Swapper<Future> futureSwapper() {
        return (bc, future) -> {
            if (future.isDone() && !future.isCancelled()) {
                try {
                    return future.get();
                }
                catch (Exception e) {
                    return "<error: " + e.getMessage() + ">";
                }
            }
            return future.isCancelled() ? "<cancelled>" : "<pending>";
        };
    }

    public static Swapper<Optional> optionalSwapper() {
        return (bc, optional) -> optional.orElse(null);
    }

    public static Swapper<Supplier> supplierSwapper() {
        return (bc, supplier) -> supplier.get();
    }

    private Swappers() {
    }
}

