/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configurator.impl.logger;

import org.apache.felix.configurator.impl.logger.InternalLogger;
import org.apache.felix.configurator.impl.logger.LogServiceSupport;
import org.apache.felix.configurator.impl.logger.StdOutLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class LogServiceEnabledLogger {
    private static final String LOGSERVICE_CLASS = "org.osgi.service.log.LogService";
    protected final ServiceTracker<Object, Object> logServiceTracker;
    private volatile InternalLogger currentLogger;
    protected volatile int trackingCount = -2;

    public LogServiceEnabledLogger(final BundleContext bundleContext) {
        this.logServiceTracker = new ServiceTracker(bundleContext, LOGSERVICE_CLASS, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Object, Object>(){
            private volatile boolean hasService = false;

            public Object addingService(ServiceReference<Object> reference) {
                Object logService;
                if (!this.hasService && (logService = bundleContext.getService(reference)) != null) {
                    this.hasService = true;
                    LogServiceSupport lsl = new LogServiceSupport(logService);
                    return lsl;
                }
                return null;
            }

            public void modifiedService(ServiceReference<Object> reference, Object service) {
            }

            public void removedService(ServiceReference<Object> reference, Object service) {
                this.hasService = false;
                bundleContext.ungetService(reference);
            }
        });
        this.logServiceTracker.open();
    }

    public void close() {
        this.logServiceTracker.close();
    }

    public void log(int level, String message, Throwable ex) {
        this.getLogger().log(level, message, ex);
    }

    private InternalLogger getLogger() {
        if (this.trackingCount < this.logServiceTracker.getTrackingCount()) {
            Object logServiceSupport = this.logServiceTracker.getService();
            this.currentLogger = logServiceSupport == null ? this.getDefaultLogger() : ((LogServiceSupport)logServiceSupport).getLogger();
            this.trackingCount = this.logServiceTracker.getTrackingCount();
        }
        return this.currentLogger;
    }

    private InternalLogger getDefaultLogger() {
        return new StdOutLogger();
    }
}

