/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.DelayProcessorSupport;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;

public class Delayer
extends DelayProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private String routeId;
    private String id;
    private Expression delay;
    private long delayValue;

    public Delayer(CamelContext camelContext, Processor processor, Expression delay, ScheduledExecutorService executorService, boolean shutdownExecutorService) {
        super(camelContext, processor, executorService, shutdownExecutorService);
        this.delay = delay;
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getTraceLabel() {
        return "delay[" + this.delay + "]";
    }

    public Expression getDelay() {
        return this.delay;
    }

    public long getDelayValue() {
        return this.delayValue;
    }

    public void setDelay(Expression delay) {
        this.delay = delay;
    }

    @Override
    protected long calculateDelay(Exchange exchange) {
        long time = 0L;
        if (this.delay != null) {
            Long longValue = (Long)this.delay.evaluate(exchange, Long.class);
            if (longValue != null) {
                this.delayValue = longValue;
                time = longValue;
            } else {
                this.delayValue = 0L;
            }
        }
        if (time <= 0L) {
            return 0L;
        }
        return time;
    }
}

