/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.region;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.karaf.features.internal.resolver.ResolverUtil;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public class CandidateComparator
implements Comparator<Capability> {
    private final Set<Resource> mandatory;

    public CandidateComparator(Set<Resource> mandatory) {
        this.mandatory = mandatory;
    }

    @Override
    public int compare(Capability cap1, Capability cap2) {
        int c = 0;
        if (cap1 instanceof BundleCapability && !(cap2 instanceof BundleCapability)) {
            c = -1;
        } else if (!(cap1 instanceof BundleCapability) && cap2 instanceof BundleCapability) {
            c = 1;
        }
        if (c == 0) {
            if (this.mandatory.contains(cap1.getResource()) && !this.mandatory.contains(cap2.getResource())) {
                c = -1;
            } else if (!this.mandatory.contains(cap1.getResource()) && this.mandatory.contains(cap2.getResource())) {
                c = 1;
            }
        }
        if (c == 0 && cap1.getNamespace().equals("osgi.wiring.bundle")) {
            c = this.compareNames(cap1, cap2, "osgi.wiring.bundle");
            if (c == 0) {
                c = this.compareVersions(cap1, cap2, "bundle-version");
            }
        } else if (c == 0 && cap1.getNamespace().equals("osgi.wiring.package")) {
            c = this.compareNames(cap1, cap2, "osgi.wiring.package");
            if (c == 0 && (c = this.compareVersions(cap1, cap2, "version")) == 0) {
                c = this.compareVersions(cap1, cap2, "bundle-version");
            }
        } else if (c == 0 && cap1.getNamespace().equals("osgi.identity") && (c = this.compareNames(cap1, cap2, "osgi.identity")) == 0) {
            c = this.compareVersions(cap1, cap2, "version");
        }
        if (c == 0) {
            String n1 = ResolverUtil.getSymbolicName(cap1.getResource());
            String n2 = ResolverUtil.getSymbolicName(cap2.getResource());
            c = n1.compareTo(n2);
        }
        return c;
    }

    private int compareNames(Capability cap1, Capability cap2, String attribute) {
        Object o1 = cap1.getAttributes().get(attribute);
        Object o2 = cap2.getAttributes().get(attribute);
        if (o1 instanceof List || o2 instanceof List) {
            List<String> l1 = o1 instanceof List ? (List<String>)o1 : Collections.singletonList((String)o1);
            List<String> l2 = o2 instanceof List ? (List<String>)o2 : Collections.singletonList((String)o2);
            for (String s : l1) {
                if (!l2.contains(s)) continue;
                return 0;
            }
            return l1.get(0).compareTo(l2.get(0));
        }
        return ((String)o1).compareTo((String)o2);
    }

    private int compareVersions(Capability cap1, Capability cap2, String attribute) {
        Version v1 = !cap1.getAttributes().containsKey(attribute) ? Version.emptyVersion : (Version)cap1.getAttributes().get(attribute);
        Version v2 = !cap2.getAttributes().containsKey(attribute) ? Version.emptyVersion : (Version)cap2.getAttributes().get(attribute);
        return v2.compareTo(v1);
    }
}

