/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.pretty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.ImportTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.tools.javac.comp.Modules;
import jpt.sun.tools.javac.model.JavacElements;
import jpt.sun.tools.javac.util.Context;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.ModuleElement;
import jpt30.lang.model.element.PackageElement;
import jpt30.lang.model.element.QualifiedNameable;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.util.ElementFilter;
import jpt30.lang.model.util.Elements;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.TreeFactory;
import org.netbeans.modules.java.source.save.DiffContext;
import org.netbeans.modules.java.source.save.ElementOverlay;

public class ImportAnalysis2 {
    private final ElementOverlay.FQNComputer currentFQN = new ElementOverlay.FQNComputer();
    private Elements elements;
    private ElementUtilities elementUtils;
    private TreeFactory make;
    private Set<Element> imports;
    private Set<Element> imported;
    private LinkedList<Set<Element>> visibleThroughClasses;
    private Map<String, List<Element>> simpleNames2Elements;
    private PackageElement unnamedPackage;
    private Element pack;
    private ASTService model;
    private final ElementOverlay overlay;
    private CompilationUnitTree cut;
    private Map<String, Element> usedImplicitlyImportedClassesCache;
    private Set<String> implicitlyImportedClassNames;
    private Element javaLang;
    private CodeStyle cs;
    private ModuleElement modle;

    public ImportAnalysis2(CompilationInfo info) {
        this(JavaSourceAccessor.getINSTANCE().getJavacTask(info).getContext());
        this.cs = DiffContext.getCodeStyle(info);
        this.elementUtils = info.getElementUtilities();
    }

    public ImportAnalysis2(Context env) {
        this.elements = JavacElements.instance(env);
        this.make = TreeFactory.instance(env);
        this.model = ASTService.instance(env);
        this.modle = Modules.instance(env).getDefaultModule();
        this.overlay = env.get(ElementOverlay.class);
        this.unnamedPackage = this.overlay != null ? this.overlay.unnamedPackage(this.model, this.elements, this.modle) : (this.modle != null ? this.elements.getPackageElement(this.modle, "") : this.elements.getPackageElement(""));
    }

    public void setCompilationUnit(CompilationUnitTree cut) {
        this.cut = cut;
    }

    public void setPackage(ExpressionTree packageNameTree) {
        this.currentFQN.setPackageNameTree(packageNameTree);
        if (packageNameTree == null) {
            this.pack = this.unnamedPackage;
            return;
        }
        String packageName = this.getFQN(packageNameTree);
        this.pack = this.overlay.resolve(this.model, this.elements, packageName);
    }

    public void setImports(List<? extends ImportTree> importsToAdd) {
        this.imports = new HashSet<Element>();
        this.imported = new HashSet<Element>();
        this.simpleNames2Elements = new HashMap<String, List<Element>>();
        this.visibleThroughClasses = new LinkedList();
        this.usedImplicitlyImportedClassesCache = null;
        ArrayList<ImportTree> moduleImports = new ArrayList<ImportTree>();
        ArrayList<ImportTree> onDemandImports = new ArrayList<ImportTree>();
        ArrayList<ImportTree> namedImports = new ArrayList<ImportTree>();
        for (ImportTree importTree : importsToAdd) {
            if (importTree.isModule()) {
                moduleImports.add(importTree);
                continue;
            }
            if (this.getFQN(importTree.getQualifiedIdentifier()).endsWith(".*")) {
                onDemandImports.add(importTree);
                continue;
            }
            namedImports.add(importTree);
        }
        HashSet defined = new HashSet();
        HashSet hashSet = new HashSet();
        moduleImports.forEach(imp -> this.addImport((ImportTree)imp, defined, clashing));
        hashSet.clear();
        onDemandImports.forEach(imp -> this.addImport((ImportTree)imp, defined, clashing));
        hashSet.clear();
        namedImports.forEach(imp -> this.addImport((ImportTree)imp, defined, clashing));
        this.implicitlyImportedClassNames = new HashSet<String>();
        this.javaLang = this.overlay.resolve(this.model, this.elements, "java.lang");
        if (this.javaLang != null) {
            for (Element element : this.javaLang.getEnclosedElements()) {
                this.implicitlyImportedClassNames.add(element.getSimpleName().toString());
            }
        }
        if (this.pack != null) {
            for (Element element : this.pack.getEnclosedElements()) {
                this.implicitlyImportedClassNames.add(element.getSimpleName().toString());
            }
        }
    }

    public Set<? extends Element> getImports() {
        return this.imports;
    }

    public void classEntered(ClassTree clazz, boolean isAnonymous) {
        Element currentClassElement;
        this.currentFQN.enterClass(clazz, isAnonymous);
        HashSet<Element> visible = new HashSet<Element>();
        String what = this.currentFQN.getFQN();
        Element element = currentClassElement = what != null ? this.overlay.resolve(this.model, this.elements, what) : null;
        if (currentClassElement != null) {
            visible.add(currentClassElement);
        }
        this.visibleThroughClasses.addFirst(visible);
    }

    public void enterVisibleThroughClasses(ClassTree clazz) {
        Set<Element> visible = this.visibleThroughClasses.getFirst();
        visible.addAll(this.overlay.getAllVisibleThrough(this.model, this.elements, this.currentFQN.getFQN(), clazz, this.pack, this.modle));
    }

    public void classLeft() {
        this.visibleThroughClasses.removeFirst();
        this.currentFQN.leaveClass();
    }

    private String getFQN(ImportTree imp) {
        return this.getFQN(imp.getQualifiedIdentifier());
    }

    private String getFQN(Tree expression) {
        final StringBuffer result = new StringBuffer();
        new ErrorAwareTreeScanner<Void, Void>(){

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, Void p) {
                super.visitMemberSelect(tree, p);
                result.append('.');
                result.append(tree.getIdentifier().toString());
                return null;
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void p) {
                result.append(tree.getName().toString());
                return null;
            }
        }.scan(expression, null);
        return result.toString();
    }

    private void addImport(ImportTree imp, Set<String> currentTypeImportedNames, Set<String> currentTypeClashingNames) {
        block8: {
            String fqn;
            block9: {
                block10: {
                    block7: {
                        fqn = this.getFQN(imp);
                        if (!imp.isModule()) break block7;
                        Element resolved = this.overlay.resolve(this.model, this.elements, fqn);
                        if (resolved == null || resolved.getKind() != ElementKind.MODULE) break block8;
                        for (PackageElement pack : this.elementUtils.transitivelyExportedPackages((ModuleElement)resolved)) {
                            for (Element element : pack.getEnclosedElements()) {
                                this.addImportedElement(this.overlay.wrap(this.model, this.elements, element), false, currentTypeImportedNames, currentTypeClashingNames);
                            }
                        }
                        break block8;
                    }
                    if (imp.isStatic()) break block9;
                    Element resolve = this.overlay.resolve(this.model, this.elements, fqn);
                    if (resolve == null) break block10;
                    this.addImportedElement(resolve, false, currentTypeImportedNames, currentTypeClashingNames);
                    break block8;
                }
                if (!fqn.endsWith(".*")) break block8;
                fqn = fqn.substring(0, fqn.length() - 2);
                List<Object> classes = Collections.emptyList();
                Element clazz = this.overlay.resolve(this.model, this.elements, fqn);
                if (clazz != null) {
                    classes = ElementFilter.typesIn(clazz.getEnclosedElements());
                }
                for (TypeElement typeElement : classes) {
                    this.addImportedElement(typeElement, false, currentTypeImportedNames, currentTypeClashingNames);
                }
                break block8;
            }
            int dot = fqn.lastIndexOf(46);
            if (dot != -1) {
                String className = fqn.substring(0, dot);
                String memberName = fqn.substring(dot + 1);
                boolean isStarred = "*".equals(memberName);
                Element element = this.overlay.resolve(this.model, this.elements, className);
                if (element != null) {
                    boolean added = false;
                    for (Element element2 : element.getEnclosedElements()) {
                        if (!element2.getModifiers().contains((Object)Modifier.STATIC) || !isStarred && !memberName.contains(element2.getSimpleName().toString())) continue;
                        this.addImportedElement(element2, true, currentTypeImportedNames, currentTypeClashingNames);
                    }
                }
            }
        }
    }

    private void addImportedElement(Element el, boolean staticImport, Set<String> currentTypeImportedNames, Set<String> currentTypeClashingNames) {
        String simpleName = el.getSimpleName().toString();
        if (currentTypeClashingNames.contains(simpleName)) {
            return;
        }
        List existing = this.simpleNames2Elements.computeIfAbsent(simpleName, x -> new ArrayList());
        if (!existing.isEmpty() && !existing.contains(el)) {
            if (!currentTypeImportedNames.contains(simpleName)) {
                this.imported.removeAll(existing);
            } else if (!staticImport) {
                this.imported.removeAll(existing);
                existing.clear();
                currentTypeClashingNames.add(simpleName);
                return;
            }
        }
        this.imported.add(el);
        existing.add(el);
        currentTypeImportedNames.add(simpleName);
    }

    /*
     * WARNING - void declaration
     */
    public ExpressionTree resolveImport(MemberSelectTree orig, Element element) {
        List<Element> alreadyImported;
        if (this.visibleThroughClasses == null || element == null || this.cs != null && this.cs.useFQNs()) {
            return orig;
        }
        if (element.getKind() == ElementKind.PACKAGE) {
            return this.make.MemberSelect(orig.getExpression(), orig.getIdentifier());
        }
        String simpleName = element.getSimpleName().toString();
        boolean clash = false;
        for (Set set : this.visibleThroughClasses) {
            if (set.contains(element)) {
                return this.make.Identifier(element.getSimpleName());
            }
            if (!set.stream().anyMatch(el -> el.getSimpleName().contentEquals(simpleName))) continue;
            clash = true;
            break;
        }
        if (!(clash |= (alreadyImported = this.simpleNames2Elements.get(simpleName)) != null && !alreadyImported.isEmpty() && !alreadyImported.contains(element)) && (element.getKind().isClass() || element.getKind().isInterface())) {
            Element element2 = element.getEnclosingElement();
            if (this.pack != null && this.pack.equals(element2)) {
                return this.make.Identifier(element.getSimpleName());
            }
        }
        if (!clash && this.imported.contains(element)) {
            return this.make.Identifier(element.getSimpleName());
        }
        if (this.overlay.packageOf(element) != null && this.overlay.packageOf(element).isUnnamed()) {
            if (orig.getExpression().getKind() == Tree.Kind.MEMBER_SELECT) {
                return this.make.MemberSelect(this.resolveImport((MemberSelectTree)orig.getExpression(), element.getEnclosingElement()), element.getSimpleName());
            }
            return orig;
        }
        if (!clash && this.implicitlyImportedClassNames.contains(simpleName)) {
            Element element3 = this.getUsedImplicitlyImportedClasses().get(simpleName);
            boolean bl = clash = element3 != null && !element.equals(element3);
        }
        if (clash) {
            if (element.getEnclosingElement().getKind().isClass() || element.getEnclosingElement().getKind().isInterface() && orig.getExpression().getKind() == Tree.Kind.MEMBER_SELECT) {
                Element element4 = this.overlay.wrap(this.model, this.elements, element.getEnclosingElement());
                return this.make.MemberSelect(this.resolveImport((MemberSelectTree)orig.getExpression(), element4), orig.getIdentifier());
            }
            return this.make.MemberSelect(orig.getExpression(), orig.getIdentifier());
        }
        if (!element.getKind().isClass() && !element.getKind().isInterface()) {
            void var6_14;
            ExpressionTree expressionTree = orig.getExpression();
            if (expressionTree.getKind() == Tree.Kind.MEMBER_SELECT) {
                ExpressionTree expressionTree2 = this.resolveImport((MemberSelectTree)expressionTree, this.overlay.wrap(this.model, this.elements, element.getEnclosingElement()));
            }
            return this.make.MemberSelect((ExpressionTree)var6_14, orig.getIdentifier());
        }
        TypeElement typeElement = (TypeElement)element;
        Element parent = typeElement.getEnclosingElement();
        if (parent != null) {
            if ((parent.getKind().isClass() || parent.getKind().isInterface()) && !this.cs.importInnerClasses()) {
                ExpressionTree clazz = orig.getExpression();
                if (clazz.getKind() == Tree.Kind.MEMBER_SELECT) {
                    clazz = this.resolveImport((MemberSelectTree)clazz, this.overlay.wrap(this.model, this.elements, parent));
                }
                return this.make.MemberSelect(clazz, orig.getIdentifier());
            }
            if (parent.getKind() == ElementKind.PACKAGE && "java.lang".equals(((PackageElement)parent).getQualifiedName().toString())) {
                return this.make.Identifier(element.getSimpleName());
            }
        }
        IdentifierTree imp = this.make.Identifier(((QualifiedNameable)element).getQualifiedName());
        this.addImport(this.make.Import(imp, false), new HashSet<String>(), new HashSet<String>());
        Element original = this.overlay.getOriginal(element);
        if (original.getEnclosingElement().getKind() == ElementKind.PACKAGE && (!this.cs.useSingleClassImport() || this.checkPackagesForStarImport(((PackageElement)original.getEnclosingElement()).getQualifiedName().toString(), this.cs))) {
            original = original.getEnclosingElement();
        }
        this.imports.add(original);
        return this.make.Identifier(element.getSimpleName());
    }

    private boolean checkPackagesForStarImport(String pkgName, CodeStyle cs) {
        for (String s : cs.getPackagesForStarImport()) {
            if (!(s.endsWith(".*") ? pkgName.startsWith(s = s.substring(0, s.length() - 2)) : pkgName.equals(s))) continue;
            return true;
        }
        return false;
    }

    private Map<String, Element> getUsedImplicitlyImportedClasses() {
        if (this.usedImplicitlyImportedClassesCache != null) {
            return this.usedImplicitlyImportedClassesCache;
        }
        this.usedImplicitlyImportedClassesCache = new HashMap<String, Element>();
        new ErrorAwareTreeScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Void p) {
                Element e = ImportAnalysis2.this.overlay.wrap(ImportAnalysis2.this.model, ImportAnalysis2.this.elements, ImportAnalysis2.this.model.getElement(node));
                if (e != null && (ImportAnalysis2.this.javaLang != null && ImportAnalysis2.this.javaLang.equals(e.getEnclosingElement()) || ImportAnalysis2.this.pack != null && ImportAnalysis2.this.pack.equals(e.getEnclosingElement()))) {
                    ImportAnalysis2.this.usedImplicitlyImportedClassesCache.put(e.getSimpleName().toString(), e);
                }
                return null;
            }
        }.scan(this.cut, null);
        return this.usedImplicitlyImportedClassesCache;
    }
}

