/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Set;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.ConnectableComponent;
import org.apache.nifi.flow.Position;
import org.apache.nifi.flow.VersionedComponent;

public class VersionedConnection
extends VersionedComponent {
    private ConnectableComponent source;
    private ConnectableComponent destination;
    private Integer labelIndex;
    private Long zIndex;
    private Set<String> selectedRelationships;
    private Long backPressureObjectThreshold;
    private String backPressureDataSizeThreshold;
    private String flowFileExpiration;
    private List<String> prioritizers;
    private List<Position> bends;
    private String loadBalanceStrategy;
    private String partitioningAttribute;
    private String loadBalanceCompression;

    @Schema(description="The source of the connection.")
    public ConnectableComponent getSource() {
        return this.source;
    }

    public void setSource(ConnectableComponent source) {
        this.source = source;
    }

    @Schema(description="The destination of the connection.")
    public ConnectableComponent getDestination() {
        return this.destination;
    }

    public void setDestination(ConnectableComponent destination) {
        this.destination = destination;
    }

    @Schema(description="The bend points on the connection.")
    public List<Position> getBends() {
        return this.bends;
    }

    public void setBends(List<Position> bends) {
        this.bends = bends;
    }

    @Schema(description="The index of the bend point where to place the connection label.")
    public Integer getLabelIndex() {
        return this.labelIndex;
    }

    public void setLabelIndex(Integer labelIndex) {
        this.labelIndex = labelIndex;
    }

    @Schema(description="The z index of the connection.", name="zIndex")
    public Long getzIndex() {
        return this.zIndex;
    }

    public void setzIndex(Long zIndex) {
        this.zIndex = zIndex;
    }

    @Schema(description="The selected relationship that comprise the connection.")
    public Set<String> getSelectedRelationships() {
        return this.selectedRelationships;
    }

    public void setSelectedRelationships(Set<String> relationships) {
        this.selectedRelationships = relationships;
    }

    @Schema(description="The object count threshold for determining when back pressure is applied. Updating this value is a passive change in the sense that it won't impact whether existing files over the limit are affected but it does help feeder processors to stop pushing too much into this work queue.")
    public Long getBackPressureObjectThreshold() {
        return this.backPressureObjectThreshold;
    }

    public void setBackPressureObjectThreshold(Long backPressureObjectThreshold) {
        this.backPressureObjectThreshold = backPressureObjectThreshold;
    }

    @Schema(description="The object data size threshold for determining when back pressure is applied. Updating this value is a passive change in the sense that it won't impact whether existing files over the limit are affected but it does help feeder processors to stop pushing too much into this work queue.")
    public String getBackPressureDataSizeThreshold() {
        return this.backPressureDataSizeThreshold;
    }

    public void setBackPressureDataSizeThreshold(String backPressureDataSizeThreshold) {
        this.backPressureDataSizeThreshold = backPressureDataSizeThreshold;
    }

    @Schema(description="The amount of time a flow file may be in the flow before it will be automatically aged out of the flow. Once a flow file reaches this age it will be terminated from the flow the next time a processor attempts to start work on it.")
    public String getFlowFileExpiration() {
        return this.flowFileExpiration;
    }

    public void setFlowFileExpiration(String flowFileExpiration) {
        this.flowFileExpiration = flowFileExpiration;
    }

    @Schema(description="The comparators used to prioritize the queue.")
    public List<String> getPrioritizers() {
        return this.prioritizers;
    }

    public void setPrioritizers(List<String> prioritizers) {
        this.prioritizers = prioritizers;
    }

    @Schema(description="The Strategy to use for load balancing data across the cluster, or null, if no Load Balance Strategy has been specified. Possible returned values: DO_NOT_LOAD_BALANCE, PARTITION_BY_ATTRIBUTE, ROUND_ROBIN, SINGLE_NODE. See LoadBalanceStrategy.class for more details.")
    public String getLoadBalanceStrategy() {
        return this.loadBalanceStrategy;
    }

    public void setLoadBalanceStrategy(String loadBalanceStrategy) {
        this.loadBalanceStrategy = loadBalanceStrategy;
    }

    @Schema(description="The attribute to use for partitioning data as it is load balanced across the cluster. If the Load Balance Strategy is configured to use PARTITION_BY_ATTRIBUTE, the value returned by this method is the name of the FlowFile Attribute that will be used to determine which node in the cluster should receive a given FlowFile. If the Load Balance Strategy is unset or is set to any other value, the Partitioning Attribute has no effect.")
    public String getPartitioningAttribute() {
        return this.partitioningAttribute;
    }

    public void setPartitioningAttribute(String partitioningAttribute) {
        this.partitioningAttribute = partitioningAttribute;
    }

    @Schema(description="Whether or not compression should be used when transferring FlowFiles between nodes Possible returned values: DO_NOT_COMPRESS, COMPRESS_ATTRIBUTES_ONLY, COMPRESS_ATTRIBUTES_AND_CONTENT. See LoadBalanceCompression.class for more details.")
    public String getLoadBalanceCompression() {
        return this.loadBalanceCompression;
    }

    public void setLoadBalanceCompression(String compression) {
        this.loadBalanceCompression = compression;
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.CONNECTION;
    }
}

