/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.process;

import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.bootstrap.process.AbstractFileBasedRuntimeValidator;
import org.apache.nifi.bootstrap.process.RuntimeValidatorResult;

public class Swappiness
extends AbstractFileBasedRuntimeValidator {
    private static final String FILE_PATH = "/proc/sys/vm/swappiness";
    private static final Pattern PATTERN = Pattern.compile("\\d+");
    private static final int RECOMMENDED_SWAPPINESS = 0;

    public Swappiness() {
        super(new File(FILE_PATH));
    }

    Swappiness(File configurationFile) {
        super(configurationFile);
    }

    @Override
    protected Pattern getPattern() {
        return PATTERN;
    }

    @Override
    protected void performChecks(Matcher matcher, List<RuntimeValidatorResult> results) {
        String configurationPath = this.getConfigurationFile().getAbsolutePath();
        if (matcher.find()) {
            int swappiness = Integer.parseInt(matcher.group());
            if (swappiness > 0) {
                RuntimeValidatorResult result = this.getResultBuilder(RuntimeValidatorResult.Outcome.FAILED).explanation(String.format("Swappiness [%d] more than recommended [%d] according to [%s]", swappiness, 0, configurationPath)).build();
                results.add(result);
            }
        } else {
            RuntimeValidatorResult result = this.getResultBuilder(RuntimeValidatorResult.Outcome.FAILED).explanation(String.format("Configuration file [%s] cannot be parsed", configurationPath)).build();
            results.add(result);
        }
    }
}

