/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.net.ssl.TrustManagerFactory;
import org.apache.nifi.security.ssl.BuilderConfigurationException;
import org.apache.nifi.security.ssl.TrustManagerFactoryBuilder;

public class StandardTrustManagerFactoryBuilder
implements TrustManagerFactoryBuilder {
    private KeyStore trustStore;

    @Override
    public TrustManagerFactory build() {
        TrustManagerFactory trustManagerFactory;
        if (this.trustStore == null) {
            trustManagerFactory = null;
        } else {
            trustManagerFactory = this.getTrustManagerFactory();
            try {
                trustManagerFactory.init(this.trustStore);
            }
            catch (KeyStoreException e) {
                throw new BuilderConfigurationException("Trust Manager Factory initialization failed", e);
            }
        }
        return trustManagerFactory;
    }

    public StandardTrustManagerFactoryBuilder trustStore(KeyStore trustStore) {
        this.trustStore = Objects.requireNonNull(trustStore, "Trust Store required");
        return this;
    }

    private TrustManagerFactory getTrustManagerFactory() {
        String algorithm = TrustManagerFactory.getDefaultAlgorithm();
        try {
            return TrustManagerFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            String message = String.format("TrustManagerFactory creation failed with algorithm [%s]", algorithm);
            throw new BuilderConfigurationException(message, e);
        }
    }
}

