/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.model.request;

import com.github.caldav4j.CalDAVConstants;
import com.github.caldav4j.exceptions.DOMValidationException;
import com.github.caldav4j.model.request.CalDAVProp;
import com.github.caldav4j.model.request.PropProperty;
import com.github.caldav4j.xml.OutputsDOMBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;

public class Comp
extends OutputsDOMBase {
    public static final String ELEMENT_NAME = "comp";
    public static final String ELEM_ALLPROP = "allprop";
    public static final String ELEM_PROP = "prop";
    public static final String ELEM_ALLCOMP = "allcomp";
    public static final String ATTR_NAME = "name";
    private List<Comp> comps = new ArrayList<Comp>();
    private List<CalDAVProp> props = new ArrayList<CalDAVProp>();
    private boolean allComp = false;
    private boolean allProp = false;
    private String name = null;

    public Comp() {
    }

    public Comp(String name) {
        this(name, false, false);
    }

    public Comp(String name, boolean allComp, boolean allProp, List<Comp> comps, List<CalDAVProp> props) {
        this.name = name;
        if (allComp) {
            this.allComp = true;
        } else if (comps != null) {
            this.comps.addAll(comps);
        }
        if (allProp) {
            this.allProp = true;
        } else if (props != null) {
            this.props.addAll(props);
        }
    }

    public Comp(String name, List<Comp> comps, List<CalDAVProp> props) {
        this(name, false, false, comps, props);
    }

    public Comp(String name, boolean allComp, boolean allProp) {
        this.name = name;
        this.allComp = allComp;
        this.allProp = allProp;
    }

    public boolean isAllComp() {
        return this.allComp;
    }

    public void setAllComp(boolean allComp) {
        this.allComp = allComp;
    }

    public boolean isAllProp() {
        return this.allProp;
    }

    public void setAllProp(boolean allProp) {
        this.allProp = allProp;
    }

    public List<Comp> getComps() {
        return this.comps;
    }

    public void setComps(List<Comp> comps) {
        this.comps = comps;
    }

    public void addComp(Comp comp) {
        this.comps.add(comp);
    }

    public void addComp(String name) {
        this.comps.add(new Comp(name));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<CalDAVProp> getProps() {
        return this.props;
    }

    public void setProps(List<CalDAVProp> props) {
        this.props = props;
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected Namespace getNamespace() {
        return CalDAVConstants.NAMESPACE_CALDAV;
    }

    @Override
    protected Collection<? extends XmlSerializable> getChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.allComp) {
            children.add((Object)new PropProperty(ELEM_ALLCOMP, CalDAVConstants.NAMESPACE_CALDAV));
        } else if (this.comps != null) {
            children.addAll(this.comps);
        }
        if (this.allProp) {
            children.add((Object)new PropProperty(ELEM_ALLPROP, CalDAVConstants.NAMESPACE_CALDAV));
        } else if (this.props != null) {
            children.addAll(this.props);
        }
        return children;
    }

    @Override
    protected String getTextContent() {
        return null;
    }

    @Override
    protected Map<String, String> getAttributes() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(ATTR_NAME, this.name);
        return m;
    }

    public void addProp(CalDAVProp prop) {
        this.props.add(prop);
    }

    public void addProp(String propName, boolean novalue) {
        this.props.add(new CalDAVProp(propName, novalue));
    }

    public void addProp(String propName) {
        this.props.add(new CalDAVProp(propName));
    }

    @Override
    public void validate() throws DOMValidationException {
        if (this.name == null) {
            this.throwValidationException("Name is a required property");
        }
        if (this.allComp && this.comps != null && this.comps.size() > 0) {
            this.throwValidationException("allComp and comp* are mutually exclusive");
        }
        if (this.comps != null) {
            this.validate(this.comps);
        }
        if (this.allProp && this.props != null && this.props.size() > 0) {
            this.throwValidationException("allProp and prop* are mutually exclusive");
        }
        if (this.props != null) {
            this.validate(this.props);
        }
    }
}

