/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.memcache;

import com.hazelcast.internal.ascii.AbstractTextCommand;
import com.hazelcast.internal.ascii.TextCommandConstants;
import java.nio.ByteBuffer;

public class IncrementCommand
extends AbstractTextCommand {
    private final String key;
    private final long value;
    private final boolean noReply;
    private ByteBuffer response;

    public IncrementCommand(TextCommandConstants.TextCommandType type, String key, long value, boolean noReply) {
        super(type);
        this.key = key;
        this.value = value;
        this.noReply = noReply;
    }

    @Override
    public boolean writeTo(ByteBuffer dst) {
        while (dst.hasRemaining() && this.response.hasRemaining()) {
            dst.put(this.response.get());
        }
        return !this.response.hasRemaining();
    }

    @Override
    public boolean readFrom(ByteBuffer src) {
        return true;
    }

    @Override
    public boolean shouldReply() {
        return !this.noReply;
    }

    public String getKey() {
        return this.key;
    }

    public long getValue() {
        return this.value;
    }

    public void setResponse(byte[] value) {
        this.response = ByteBuffer.wrap(value);
    }
}

