/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact.zeroconfig;

import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializer;
import com.hazelcast.internal.serialization.impl.compact.CompactUtil;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.zeroconfig.ValueReaderWriter;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.compact.CompactReader;
import com.hazelcast.nio.serialization.compact.CompactWriter;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class ValueReaderWriters {
    private static final Map<Class<?>, Function<String, ValueReaderWriter<?>>> CONSTRUCTORS = new HashMap();
    private static final Map<Class<?>, Function<String, ValueReaderWriter<?>>> ARRAY_CONSTRUCTORS = new HashMap();

    private ValueReaderWriters() {
    }

    public static ValueReaderWriter<?> readerWriterFor(CompactStreamSerializer compactStreamSerializer, Class<?> clazz, Class<?> type, Type genericType, String fieldName) {
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return ValueReaderWriters.createReaderWriterForArray(compactStreamSerializer, clazz, componentType, fieldName);
        }
        if (ValueReaderWriters.isList(type)) {
            Class<?> componentType = ValueReaderWriters.getSingleComponentType(genericType);
            ValueReaderWriter readerWriter = ValueReaderWriters.createReaderWriterForArray(compactStreamSerializer, clazz, componentType, fieldName);
            return new ArrayListReaderWriter(fieldName, componentType, readerWriter);
        }
        if (ValueReaderWriters.isSet(type)) {
            Class<?> componentType = ValueReaderWriters.getSingleComponentType(genericType);
            ValueReaderWriter readerWriter = ValueReaderWriters.createReaderWriterForArray(compactStreamSerializer, clazz, componentType, fieldName);
            return new HashSetReaderWriter(fieldName, componentType, readerWriter);
        }
        if (ValueReaderWriters.isMap(type)) {
            BiTuple<Class<?>, Class<?>> componentTypes = ValueReaderWriters.getTupleComponentTypes(genericType);
            ValueReaderWriter keyReaderWriter = ValueReaderWriters.createReaderWriterForArray(compactStreamSerializer, clazz, (Class)componentTypes.element1, fieldName + "!keys");
            ValueReaderWriter valueReaderWriter = ValueReaderWriters.createReaderWriterForArray(compactStreamSerializer, clazz, (Class)componentTypes.element2, fieldName + "!values");
            return new HashMapReaderWriter(fieldName, (Class)componentTypes.element1, (Class)componentTypes.element2, keyReaderWriter, valueReaderWriter);
        }
        if (type.isEnum()) {
            return new EnumReaderWriter(fieldName, type);
        }
        Function<String, ValueReaderWriter<?>> constructor = CONSTRUCTORS.get(type);
        if (constructor != null) {
            return constructor.apply(fieldName);
        }
        boolean isRegisteredAsCompact = compactStreamSerializer.isRegisteredAsCompact(type);
        if (!isRegisteredAsCompact) {
            CompactUtil.verifyFieldClassIsCompactSerializable(type, clazz);
            CompactUtil.verifyFieldClassShouldBeSerializedAsCompact(compactStreamSerializer, type, clazz);
        }
        return new CompactReaderWriter(fieldName);
    }

    private static ValueReaderWriter createReaderWriterForArray(CompactStreamSerializer compactStreamSerializer, Class<?> clazz, Class<?> componentType, String fieldName) {
        if (componentType.isEnum()) {
            return new EnumArrayReaderWriter(fieldName, componentType);
        }
        Function<String, ValueReaderWriter<?>> constructor = ARRAY_CONSTRUCTORS.get(componentType);
        if (constructor != null) {
            return constructor.apply(fieldName);
        }
        boolean isRegisteredAsCompact = compactStreamSerializer.isRegisteredAsCompact(componentType);
        if (!isRegisteredAsCompact) {
            CompactUtil.verifyFieldClassIsCompactSerializable(componentType, clazz);
            CompactUtil.verifyFieldClassShouldBeSerializedAsCompact(compactStreamSerializer, componentType, clazz);
        }
        return new CompactArrayReaderWriter(fieldName, componentType);
    }

    private static boolean isList(Class<?> clazz) {
        return List.class.equals(clazz) || ArrayList.class.equals(clazz);
    }

    private static boolean isSet(Class<?> clazz) {
        return Set.class.equals(clazz) || HashSet.class.equals(clazz);
    }

    private static boolean isMap(Class<?> clazz) {
        return Map.class.equals(clazz) || HashMap.class.equals(clazz);
    }

    private static Class<?> getSingleComponentType(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            throw new HazelcastSerializationException("It is required that the type " + genericType + " must be parameterized.");
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments.length != 1) {
            throw new HazelcastSerializationException("Expected type " + genericType + " to have a single type argument.");
        }
        Type typeArgument = typeArguments[0];
        if (!(typeArgument instanceof Class)) {
            throw new HazelcastSerializationException("Expected type argument of type " + genericType + " to be a class");
        }
        return (Class)typeArgument;
    }

    private static BiTuple<Class<?>, Class<?>> getTupleComponentTypes(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            throw new HazelcastSerializationException("Expected the type " + genericType + " to be parameterized.");
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments.length != 2) {
            throw new HazelcastSerializationException("Expected type " + genericType + " to have two type arguments.");
        }
        Type keyTypeArgument = typeArguments[0];
        Type valueTypeArgument = typeArguments[1];
        if (!(keyTypeArgument instanceof Class) || !(valueTypeArgument instanceof Class)) {
            throw new HazelcastSerializationException("Expected type arguments of type " + genericType + " to be classes");
        }
        return BiTuple.of((Class)keyTypeArgument, (Class)valueTypeArgument);
    }

    static {
        CONSTRUCTORS.put(String.class, StringReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(String.class, StringArrayReaderWriter::new);
        CONSTRUCTORS.put(BigDecimal.class, BigDecimalReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(BigDecimal.class, BigDecimalArrayReaderWriter::new);
        CONSTRUCTORS.put(LocalTime.class, LocalTimeReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(LocalTime.class, LocalTimeArrayReaderWriter::new);
        CONSTRUCTORS.put(LocalDate.class, LocalDateReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(LocalDate.class, LocalDateArrayReaderWriter::new);
        CONSTRUCTORS.put(LocalDateTime.class, LocalDateTimeReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(LocalDateTime.class, LocalDateTimeArrayReaderWriter::new);
        CONSTRUCTORS.put(OffsetDateTime.class, OffsetDateTimeReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(OffsetDateTime.class, OffsetDateTimeArrayReaderWriter::new);
        CONSTRUCTORS.put(Boolean.class, NullableBooleanReaderWriter::new);
        CONSTRUCTORS.put(Boolean.TYPE, BooleanReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(Boolean.class, NullableBooleanArrayReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(Boolean.TYPE, BooleanArrayReaderWriter::new);
        CONSTRUCTORS.put(Byte.class, NullableByteReaderWriter::new);
        CONSTRUCTORS.put(Byte.TYPE, ByteReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(Byte.class, NullableByteArrayReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(Byte.TYPE, ByteArrayReaderWriter::new);
        CONSTRUCTORS.put(Character.class, NullableCharacterReaderWriter::new);
        CONSTRUCTORS.put(Character.TYPE, CharacterReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(Character.class, NullableCharacterArrayReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(Character.TYPE, CharArrayReaderWriter::new);
        CONSTRUCTORS.put(Short.class, NullableShortReaderWriter::new);
        CONSTRUCTORS.put(Short.TYPE, ShortReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(Short.class, NullableShortArrayReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(Short.TYPE, ShortArrayReaderWriter::new);
        CONSTRUCTORS.put(Integer.class, NullableIntegerReaderWriter::new);
        CONSTRUCTORS.put(Integer.TYPE, IntegerReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(Integer.class, NullableIntegerArrayReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(Integer.TYPE, IntArrayReaderWriter::new);
        CONSTRUCTORS.put(Long.class, NullableLongReaderWriter::new);
        CONSTRUCTORS.put(Long.TYPE, LongReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(Long.class, NullableLongArrayReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(Long.TYPE, LongArrayReaderWriter::new);
        CONSTRUCTORS.put(Float.class, NullableFloatReaderWriter::new);
        CONSTRUCTORS.put(Float.TYPE, FloatReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(Float.class, NullableFloatArrayReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(Float.TYPE, FloatArrayReaderWriter::new);
        CONSTRUCTORS.put(Double.class, NullableDoubleReaderWriter::new);
        CONSTRUCTORS.put(Double.TYPE, DoubleReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(Double.class, NullableDoubleArrayReaderWriter::new);
        ARRAY_CONSTRUCTORS.put(Double.TYPE, DoubleArrayReaderWriter::new);
    }

    private static final class ArrayListReaderWriter
    extends ValueReaderWriter<List> {
        private final Class<?> componentType;
        private final ValueReaderWriter valueReaderWriter;

        private ArrayListReaderWriter(String fieldName, Class<?> componentType, ValueReaderWriter valueReaderWriter) {
            super(fieldName);
            this.componentType = componentType;
            this.valueReaderWriter = valueReaderWriter;
        }

        @Override
        public List read(CompactReader reader, Schema schema) {
            Object[] value = (Object[])this.valueReaderWriter.read(reader, schema);
            if (value == null) {
                return null;
            }
            return new ArrayList<Object>(Arrays.asList(value));
        }

        @Override
        public void write(CompactWriter writer, List value) {
            if (value == null) {
                this.valueReaderWriter.write(writer, null);
                return;
            }
            Object o = Array.newInstance(this.componentType, value.size());
            Object[] array = value.toArray((Object[])o);
            this.valueReaderWriter.write(writer, array);
        }
    }

    private static final class HashSetReaderWriter
    extends ValueReaderWriter<Set> {
        private final Class<?> componentType;
        private final ValueReaderWriter valueReaderWriter;

        private HashSetReaderWriter(String fieldName, Class<?> componentType, ValueReaderWriter valueReaderWriter) {
            super(fieldName);
            this.componentType = componentType;
            this.valueReaderWriter = valueReaderWriter;
        }

        @Override
        public Set read(CompactReader reader, Schema schema) {
            Object[] value = (Object[])this.valueReaderWriter.read(reader, schema);
            if (value == null) {
                return null;
            }
            return new HashSet<Object>(Arrays.asList(value));
        }

        @Override
        public void write(CompactWriter writer, Set value) {
            if (value == null) {
                this.valueReaderWriter.write(writer, null);
                return;
            }
            Object o = Array.newInstance(this.componentType, value.size());
            Object[] array = value.toArray((Object[])o);
            this.valueReaderWriter.write(writer, array);
        }
    }

    private static final class HashMapReaderWriter
    extends ValueReaderWriter<Map> {
        private final Class<?> keyComponentType;
        private final Class<?> valueComponentType;
        private final ValueReaderWriter keyReaderWriter;
        private final ValueReaderWriter valueReaderWriter;

        private HashMapReaderWriter(String fieldName, Class<?> keyComponentType, Class<?> valueComponentType, ValueReaderWriter keyReaderWriter, ValueReaderWriter valueReaderWriter) {
            super(fieldName);
            this.keyComponentType = keyComponentType;
            this.valueComponentType = valueComponentType;
            this.keyReaderWriter = keyReaderWriter;
            this.valueReaderWriter = valueReaderWriter;
        }

        @Override
        public Map read(CompactReader reader, Schema schema) {
            Object[] keys = (Object[])this.keyReaderWriter.read(reader, schema);
            Object[] values = (Object[])this.valueReaderWriter.read(reader, schema);
            if (keys == null || values == null) {
                return null;
            }
            HashMap<Object, Object> map = new HashMap<Object, Object>(keys.length);
            for (int i = 0; i < keys.length; ++i) {
                map.put(keys[i], values[i]);
            }
            return map;
        }

        @Override
        public void write(CompactWriter writer, Map value) {
            if (value == null) {
                this.keyReaderWriter.write(writer, null);
                this.valueReaderWriter.write(writer, null);
                return;
            }
            Object[] keys = Array.newInstance(this.keyComponentType, value.size());
            Object[] values = Array.newInstance(this.valueComponentType, value.size());
            keys = value.keySet().toArray((Object[])keys);
            values = value.values().toArray((Object[])values);
            this.keyReaderWriter.write(writer, keys);
            this.valueReaderWriter.write(writer, values);
        }
    }

    private static final class EnumReaderWriter
    extends ValueReaderWriter<Enum> {
        private final Class<? extends Enum> clazz;

        private EnumReaderWriter(String fieldName, Class<? extends Enum> clazz) {
            super(fieldName);
            this.clazz = clazz;
        }

        @Override
        public Enum read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.STRING)) {
                return null;
            }
            String value = reader.readString(this.fieldName);
            return CompactUtil.enumFromStringName(this.clazz, value);
        }

        @Override
        public void write(CompactWriter writer, Enum value) {
            writer.writeString(this.fieldName, CompactUtil.enumAsStringName(value));
        }
    }

    private static final class CompactReaderWriter
    extends ValueReaderWriter<Object> {
        private CompactReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Object read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.COMPACT)) {
                return null;
            }
            return reader.readCompact(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Object value) {
            writer.writeCompact(this.fieldName, value);
        }
    }

    private static final class EnumArrayReaderWriter
    extends ValueReaderWriter<Enum[]> {
        private final Class<? extends Enum> clazz;

        private EnumArrayReaderWriter(String fieldName, Class<? extends Enum> clazz) {
            super(fieldName);
            this.clazz = clazz;
        }

        @Override
        public Enum[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_STRING)) {
                return null;
            }
            String[] values = reader.readArrayOfString(this.fieldName);
            return CompactUtil.enumArrayFromStringNameArray(this.clazz, values);
        }

        @Override
        public void write(CompactWriter writer, Enum[] value) {
            writer.writeArrayOfString(this.fieldName, CompactUtil.enumArrayAsStringNameArray(value));
        }
    }

    private static final class CompactArrayReaderWriter
    extends ValueReaderWriter<Object[]> {
        private final Class<?> clazz;

        private CompactArrayReaderWriter(String fieldName, Class<?> clazz) {
            super(fieldName);
            this.clazz = clazz;
        }

        @Override
        public Object[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_COMPACT)) {
                return null;
            }
            return reader.readArrayOfCompact(this.fieldName, this.clazz);
        }

        @Override
        public void write(CompactWriter writer, Object[] value) {
            writer.writeArrayOfCompact(this.fieldName, value);
        }
    }

    private static final class DoubleArrayReaderWriter
    extends ValueReaderWriter<double[]> {
        private DoubleArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public double[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_FLOAT64, FieldKind.ARRAY_OF_NULLABLE_FLOAT64)) {
                return null;
            }
            return reader.readArrayOfFloat64(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, double[] value) {
            writer.writeArrayOfFloat64(this.fieldName, value);
        }
    }

    private static final class NullableDoubleArrayReaderWriter
    extends ValueReaderWriter<Double[]> {
        private NullableDoubleArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Double[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_NULLABLE_FLOAT64, FieldKind.ARRAY_OF_FLOAT64)) {
                return null;
            }
            return reader.readArrayOfNullableFloat64(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Double[] value) {
            writer.writeArrayOfNullableFloat64(this.fieldName, value);
        }
    }

    private static final class DoubleReaderWriter
    extends ValueReaderWriter<Double> {
        private DoubleReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Double read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.FLOAT64, FieldKind.NULLABLE_FLOAT64)) {
                return 0.0;
            }
            return reader.readFloat64(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Double value) {
            writer.writeFloat64(this.fieldName, value);
        }
    }

    private static final class NullableDoubleReaderWriter
    extends ValueReaderWriter<Double> {
        private NullableDoubleReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Double read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.NULLABLE_FLOAT64, FieldKind.FLOAT64)) {
                return null;
            }
            return reader.readNullableFloat64(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Double value) {
            writer.writeNullableFloat64(this.fieldName, value);
        }
    }

    private static final class FloatArrayReaderWriter
    extends ValueReaderWriter<float[]> {
        private FloatArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public float[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_FLOAT32, FieldKind.ARRAY_OF_NULLABLE_FLOAT32)) {
                return null;
            }
            return reader.readArrayOfFloat32(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, float[] value) {
            writer.writeArrayOfFloat32(this.fieldName, value);
        }
    }

    private static final class NullableFloatArrayReaderWriter
    extends ValueReaderWriter<Float[]> {
        private NullableFloatArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Float[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_NULLABLE_FLOAT32, FieldKind.ARRAY_OF_FLOAT32)) {
                return null;
            }
            return reader.readArrayOfNullableFloat32(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Float[] value) {
            writer.writeArrayOfNullableFloat32(this.fieldName, value);
        }
    }

    private static final class FloatReaderWriter
    extends ValueReaderWriter<Float> {
        private FloatReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Float read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.FLOAT32, FieldKind.NULLABLE_FLOAT32)) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf(reader.readFloat32(this.fieldName));
        }

        @Override
        public void write(CompactWriter writer, Float value) {
            writer.writeFloat32(this.fieldName, value.floatValue());
        }
    }

    private static final class NullableFloatReaderWriter
    extends ValueReaderWriter<Float> {
        private NullableFloatReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Float read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.NULLABLE_FLOAT32, FieldKind.FLOAT32)) {
                return null;
            }
            return reader.readNullableFloat32(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Float value) {
            writer.writeNullableFloat32(this.fieldName, value);
        }
    }

    private static final class LongArrayReaderWriter
    extends ValueReaderWriter<long[]> {
        private LongArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public long[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_INT64, FieldKind.ARRAY_OF_NULLABLE_INT64)) {
                return null;
            }
            return reader.readArrayOfInt64(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, long[] value) {
            writer.writeArrayOfInt64(this.fieldName, value);
        }
    }

    private static final class NullableLongArrayReaderWriter
    extends ValueReaderWriter<Long[]> {
        private NullableLongArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Long[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_NULLABLE_INT64, FieldKind.ARRAY_OF_INT64)) {
                return null;
            }
            return reader.readArrayOfNullableInt64(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Long[] value) {
            writer.writeArrayOfNullableInt64(this.fieldName, value);
        }
    }

    private static final class LongReaderWriter
    extends ValueReaderWriter<Long> {
        private LongReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Long read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.INT64, FieldKind.NULLABLE_INT64)) {
                return 0L;
            }
            return reader.readInt64(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Long value) {
            writer.writeInt64(this.fieldName, value);
        }
    }

    private static final class NullableLongReaderWriter
    extends ValueReaderWriter<Long> {
        private NullableLongReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Long read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.NULLABLE_INT64, FieldKind.INT64)) {
                return null;
            }
            return reader.readNullableInt64(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Long value) {
            writer.writeNullableInt64(this.fieldName, value);
        }
    }

    private static final class IntArrayReaderWriter
    extends ValueReaderWriter<int[]> {
        private IntArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public int[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_INT32, FieldKind.ARRAY_OF_NULLABLE_INT32)) {
                return null;
            }
            return reader.readArrayOfInt32(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, int[] value) {
            writer.writeArrayOfInt32(this.fieldName, value);
        }
    }

    private static final class NullableIntegerArrayReaderWriter
    extends ValueReaderWriter<Integer[]> {
        private NullableIntegerArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Integer[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_NULLABLE_INT32, FieldKind.ARRAY_OF_INT32)) {
                return null;
            }
            return reader.readArrayOfNullableInt32(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Integer[] value) {
            writer.writeArrayOfNullableInt32(this.fieldName, value);
        }
    }

    private static final class IntegerReaderWriter
    extends ValueReaderWriter<Integer> {
        private IntegerReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Integer read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.INT32, FieldKind.NULLABLE_INT32)) {
                return 0;
            }
            return reader.readInt32(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Integer value) {
            writer.writeInt32(this.fieldName, value);
        }
    }

    private static final class NullableIntegerReaderWriter
    extends ValueReaderWriter<Integer> {
        private NullableIntegerReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Integer read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.NULLABLE_INT32, FieldKind.INT32)) {
                return null;
            }
            return reader.readNullableInt32(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Integer value) {
            writer.writeNullableInt32(this.fieldName, value);
        }
    }

    private static final class ShortArrayReaderWriter
    extends ValueReaderWriter<short[]> {
        private ShortArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public short[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_INT16, FieldKind.ARRAY_OF_NULLABLE_INT16)) {
                return null;
            }
            return reader.readArrayOfInt16(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, short[] value) {
            writer.writeArrayOfInt16(this.fieldName, value);
        }
    }

    private static final class NullableShortArrayReaderWriter
    extends ValueReaderWriter<Short[]> {
        private NullableShortArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Short[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_NULLABLE_INT16, FieldKind.ARRAY_OF_INT16)) {
                return null;
            }
            return reader.readArrayOfNullableInt16(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Short[] value) {
            writer.writeArrayOfNullableInt16(this.fieldName, value);
        }
    }

    private static final class ShortReaderWriter
    extends ValueReaderWriter<Short> {
        private ShortReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Short read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.INT16, FieldKind.NULLABLE_INT16)) {
                return (short)0;
            }
            return reader.readInt16(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Short value) {
            writer.writeInt16(this.fieldName, value);
        }
    }

    private static final class NullableShortReaderWriter
    extends ValueReaderWriter<Short> {
        private NullableShortReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Short read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.NULLABLE_INT16, FieldKind.INT16)) {
                return null;
            }
            return reader.readNullableInt16(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Short value) {
            writer.writeNullableInt16(this.fieldName, value);
        }
    }

    private static final class CharArrayReaderWriter
    extends ValueReaderWriter<char[]> {
        private CharArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public char[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_INT16, FieldKind.ARRAY_OF_NULLABLE_INT16)) {
                return null;
            }
            return CompactUtil.charArrayFromShortArray(reader.readArrayOfInt16(this.fieldName));
        }

        @Override
        public void write(CompactWriter writer, char[] value) {
            writer.writeArrayOfInt16(this.fieldName, CompactUtil.charArrayAsShortArray(value));
        }
    }

    private static final class NullableCharacterArrayReaderWriter
    extends ValueReaderWriter<Character[]> {
        private NullableCharacterArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Character[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_NULLABLE_INT16, FieldKind.ARRAY_OF_INT16)) {
                return null;
            }
            return CompactUtil.characterArrayFromShortArray(reader.readArrayOfNullableInt16(this.fieldName));
        }

        @Override
        public void write(CompactWriter writer, Character[] value) {
            writer.writeArrayOfNullableInt16(this.fieldName, CompactUtil.characterArrayAsShortArray(value));
        }
    }

    private static final class CharacterReaderWriter
    extends ValueReaderWriter<Character> {
        private CharacterReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Character read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.INT16, FieldKind.NULLABLE_INT16)) {
                return Character.valueOf('\u0000');
            }
            return Character.valueOf((char)reader.readInt16(this.fieldName));
        }

        @Override
        public void write(CompactWriter writer, Character value) {
            writer.writeInt16(this.fieldName, (short)value.charValue());
        }
    }

    private static final class NullableCharacterReaderWriter
    extends ValueReaderWriter<Character> {
        private NullableCharacterReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Character read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.NULLABLE_INT16, FieldKind.INT16)) {
                return null;
            }
            return CompactUtil.characterFromShort(reader.readNullableInt16(this.fieldName));
        }

        @Override
        public void write(CompactWriter writer, Character value) {
            writer.writeNullableInt16(this.fieldName, CompactUtil.characterAsShort(value));
        }
    }

    private static final class ByteArrayReaderWriter
    extends ValueReaderWriter<byte[]> {
        private ByteArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public byte[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_INT8, FieldKind.ARRAY_OF_NULLABLE_INT8)) {
                return null;
            }
            return reader.readArrayOfInt8(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, byte[] value) {
            writer.writeArrayOfInt8(this.fieldName, value);
        }
    }

    private static final class NullableByteArrayReaderWriter
    extends ValueReaderWriter<Byte[]> {
        private NullableByteArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Byte[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_NULLABLE_INT8, FieldKind.ARRAY_OF_INT8)) {
                return null;
            }
            return reader.readArrayOfNullableInt8(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Byte[] value) {
            writer.writeArrayOfNullableInt8(this.fieldName, value);
        }
    }

    private static final class ByteReaderWriter
    extends ValueReaderWriter<Byte> {
        private ByteReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Byte read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.INT8, FieldKind.NULLABLE_INT8)) {
                return (byte)0;
            }
            return reader.readInt8(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Byte value) {
            writer.writeInt8(this.fieldName, value);
        }
    }

    private static final class NullableByteReaderWriter
    extends ValueReaderWriter<Byte> {
        private NullableByteReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Byte read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.NULLABLE_INT8, FieldKind.INT8)) {
                return null;
            }
            return reader.readNullableInt8(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Byte value) {
            writer.writeNullableInt8(this.fieldName, value);
        }
    }

    private static final class BooleanArrayReaderWriter
    extends ValueReaderWriter<boolean[]> {
        private BooleanArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public boolean[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_BOOLEAN, FieldKind.ARRAY_OF_NULLABLE_BOOLEAN)) {
                return null;
            }
            return reader.readArrayOfBoolean(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, boolean[] value) {
            writer.writeArrayOfBoolean(this.fieldName, value);
        }
    }

    private static final class NullableBooleanArrayReaderWriter
    extends ValueReaderWriter<Boolean[]> {
        private NullableBooleanArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Boolean[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_NULLABLE_BOOLEAN, FieldKind.ARRAY_OF_BOOLEAN)) {
                return null;
            }
            return reader.readArrayOfNullableBoolean(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Boolean[] value) {
            writer.writeArrayOfNullableBoolean(this.fieldName, value);
        }
    }

    private static final class BooleanReaderWriter
    extends ValueReaderWriter<Boolean> {
        private BooleanReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Boolean read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.BOOLEAN, FieldKind.NULLABLE_BOOLEAN)) {
                return false;
            }
            return reader.readBoolean(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Boolean value) {
            writer.writeBoolean(this.fieldName, value);
        }
    }

    private static final class NullableBooleanReaderWriter
    extends ValueReaderWriter<Boolean> {
        private NullableBooleanReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public Boolean read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.NULLABLE_BOOLEAN, FieldKind.BOOLEAN)) {
                return null;
            }
            return reader.readNullableBoolean(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, Boolean value) {
            writer.writeNullableBoolean(this.fieldName, value);
        }
    }

    private static final class OffsetDateTimeArrayReaderWriter
    extends ValueReaderWriter<OffsetDateTime[]> {
        private OffsetDateTimeArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public OffsetDateTime[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_TIMESTAMP_WITH_TIMEZONE)) {
                return null;
            }
            return reader.readArrayOfTimestampWithTimezone(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, OffsetDateTime[] value) {
            writer.writeArrayOfTimestampWithTimezone(this.fieldName, value);
        }
    }

    private static final class OffsetDateTimeReaderWriter
    extends ValueReaderWriter<OffsetDateTime> {
        private OffsetDateTimeReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public OffsetDateTime read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.TIMESTAMP_WITH_TIMEZONE)) {
                return null;
            }
            return reader.readTimestampWithTimezone(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, OffsetDateTime value) {
            writer.writeTimestampWithTimezone(this.fieldName, value);
        }
    }

    private static final class LocalDateTimeArrayReaderWriter
    extends ValueReaderWriter<LocalDateTime[]> {
        private LocalDateTimeArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public LocalDateTime[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_TIMESTAMP)) {
                return null;
            }
            return reader.readArrayOfTimestamp(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, LocalDateTime[] value) {
            writer.writeArrayOfTimestamp(this.fieldName, value);
        }
    }

    private static final class LocalDateTimeReaderWriter
    extends ValueReaderWriter<LocalDateTime> {
        private LocalDateTimeReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public LocalDateTime read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.TIMESTAMP)) {
                return null;
            }
            return reader.readTimestamp(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, LocalDateTime value) {
            writer.writeTimestamp(this.fieldName, value);
        }
    }

    private static final class LocalDateArrayReaderWriter
    extends ValueReaderWriter<LocalDate[]> {
        private LocalDateArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public LocalDate[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_DATE)) {
                return null;
            }
            return reader.readArrayOfDate(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, LocalDate[] value) {
            writer.writeArrayOfDate(this.fieldName, value);
        }
    }

    private static final class LocalDateReaderWriter
    extends ValueReaderWriter<LocalDate> {
        private LocalDateReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public LocalDate read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.DATE)) {
                return null;
            }
            return reader.readDate(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, LocalDate value) {
            writer.writeDate(this.fieldName, value);
        }
    }

    private static final class LocalTimeArrayReaderWriter
    extends ValueReaderWriter<LocalTime[]> {
        private LocalTimeArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public LocalTime[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_TIME)) {
                return null;
            }
            return reader.readArrayOfTime(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, LocalTime[] value) {
            writer.writeArrayOfTime(this.fieldName, value);
        }
    }

    private static final class LocalTimeReaderWriter
    extends ValueReaderWriter<LocalTime> {
        private LocalTimeReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public LocalTime read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.TIME)) {
                return null;
            }
            return reader.readTime(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, LocalTime value) {
            writer.writeTime(this.fieldName, value);
        }
    }

    private static final class BigDecimalArrayReaderWriter
    extends ValueReaderWriter<BigDecimal[]> {
        private BigDecimalArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public BigDecimal[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_DECIMAL)) {
                return null;
            }
            return reader.readArrayOfDecimal(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, BigDecimal[] value) {
            writer.writeArrayOfDecimal(this.fieldName, value);
        }
    }

    private static final class BigDecimalReaderWriter
    extends ValueReaderWriter<BigDecimal> {
        private BigDecimalReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public BigDecimal read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.DECIMAL)) {
                return null;
            }
            return reader.readDecimal(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, BigDecimal value) {
            writer.writeDecimal(this.fieldName, value);
        }
    }

    private static final class StringArrayReaderWriter
    extends ValueReaderWriter<String[]> {
        private StringArrayReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public String[] read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.ARRAY_OF_STRING)) {
                return null;
            }
            return reader.readArrayOfString(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, String[] value) {
            writer.writeArrayOfString(this.fieldName, value);
        }
    }

    private static final class StringReaderWriter
    extends ValueReaderWriter<String> {
        private StringReaderWriter(String fieldName) {
            super(fieldName);
        }

        @Override
        public String read(CompactReader reader, Schema schema) {
            if (!CompactUtil.isFieldExist(schema, this.fieldName, FieldKind.STRING)) {
                return null;
            }
            return reader.readString(this.fieldName);
        }

        @Override
        public void write(CompactWriter writer, String value) {
            writer.writeString(this.fieldName, value);
        }
    }
}

