/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.diagnostics.StoreLatencyPlugin;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.map.EntryLoader;
import com.hazelcast.map.MapLoader;
import com.hazelcast.map.MapLoaderLifecycleSupport;
import com.hazelcast.map.MapStore;
import com.hazelcast.map.PostProcessingMapStore;
import com.hazelcast.map.impl.LatencyTrackingMapLoader;
import com.hazelcast.map.impl.LatencyTrackingMapStore;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;

public class MapStoreWrapper
implements MapStore,
MapLoaderLifecycleSupport {
    private MapLoader mapLoader;
    private MapStore mapStore;
    private boolean withExpirationTime;
    private final String mapName;
    private final Object impl;
    @Nullable
    private final String namespace;
    private final NodeEngine nodeEngine;

    public MapStoreWrapper(NodeEngine nodeEngine, String mapName, Object impl, @Nullable String namespace) {
        this.mapName = mapName;
        this.impl = impl;
        MapLoader loader = null;
        MapStore store = null;
        if (impl instanceof MapStore) {
            MapStore mapStore;
            store = mapStore = (MapStore)impl;
        }
        if (impl instanceof MapLoader) {
            MapLoader mapLoader;
            loader = mapLoader = (MapLoader)impl;
        }
        if (impl instanceof EntryLoader) {
            this.withExpirationTime = true;
        }
        this.mapLoader = loader;
        this.mapStore = store;
        this.namespace = namespace;
        this.nodeEngine = nodeEngine;
    }

    public MapStore getMapStore() {
        return this.mapStore;
    }

    @Override
    public void destroy() {
        NamespaceUtil.runWithNamespace(this.nodeEngine, this.namespace, () -> {
            Object patt2793$temp = this.impl;
            if (patt2793$temp instanceof MapLoaderLifecycleSupport) {
                MapLoaderLifecycleSupport support = (MapLoaderLifecycleSupport)patt2793$temp;
                support.destroy();
            }
        });
    }

    @Override
    public void init(HazelcastInstance hazelcastInstance, Properties properties, String mapName) {
        NamespaceUtil.runWithNamespace(this.nodeEngine, this.namespace, () -> {
            Object patt3113$temp = this.impl;
            if (patt3113$temp instanceof MapLoaderLifecycleSupport) {
                MapLoaderLifecycleSupport support = (MapLoaderLifecycleSupport)patt3113$temp;
                support.init(hazelcastInstance, properties, mapName);
            }
        });
    }

    private boolean isMapStore() {
        return this.mapStore != null;
    }

    public boolean isMapLoader() {
        return this.mapLoader != null;
    }

    public void instrument(NodeEngine nodeEngine) {
        Diagnostics diagnostics = ((NodeEngineImpl)nodeEngine).getDiagnostics();
        StoreLatencyPlugin storeLatencyPlugin = diagnostics.getPlugin(StoreLatencyPlugin.class);
        if (storeLatencyPlugin == null) {
            return;
        }
        if (this.mapLoader != null) {
            this.mapLoader = new LatencyTrackingMapLoader(this.mapLoader, storeLatencyPlugin, this.mapName);
        }
        if (this.mapStore != null) {
            this.mapStore = new LatencyTrackingMapStore(this.mapStore, storeLatencyPlugin, this.mapName);
        }
    }

    public void delete(Object key) {
        if (this.isMapStore()) {
            NamespaceUtil.runWithOwnClassLoader(this.mapStore, () -> this.mapStore.delete(key));
        }
    }

    public void store(Object key, Object value) {
        if (this.isMapStore()) {
            NamespaceUtil.runWithOwnClassLoader(this.mapStore, () -> this.mapStore.store(key, value));
        }
    }

    public void storeAll(Map map) {
        if (this.isMapStore()) {
            NamespaceUtil.runWithOwnClassLoader(this.mapStore, () -> this.mapStore.storeAll(map));
        }
    }

    public void deleteAll(Collection keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        if (this.isMapStore()) {
            NamespaceUtil.runWithOwnClassLoader(this.mapStore, () -> this.mapStore.deleteAll(keys));
        }
    }

    @Override
    public Iterable<Object> loadAllKeys() {
        if (this.isMapLoader()) {
            return NamespaceUtil.callWithOwnClassLoader(this.mapLoader, () -> this.mapLoader.loadAllKeys());
        }
        return null;
    }

    @Override
    public Object load(Object key) {
        if (this.isMapLoader()) {
            return NamespaceUtil.callWithOwnClassLoader(this.mapLoader, () -> this.mapLoader.load(key));
        }
        return null;
    }

    @Override
    public Map loadAll(Collection keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        if (this.isMapLoader()) {
            return NamespaceUtil.callWithOwnClassLoader(this.mapLoader, () -> this.mapLoader.loadAll(keys));
        }
        return null;
    }

    public Object getImpl() {
        return this.impl;
    }

    public boolean isPostProcessingMapStore() {
        return this.isMapStore() && this.mapStore instanceof PostProcessingMapStore;
    }

    public boolean isWithExpirationTime() {
        return this.withExpirationTime;
    }

    public String toString() {
        return "MapStoreWrapper{mapName='" + this.mapName + "', mapStore=" + this.mapStore + ", mapLoader=" + this.mapLoader + "}";
    }
}

