/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.operation.GetAllOperation;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.MultipleEntryOpSteps;
import com.hazelcast.map.impl.operation.steps.UtilSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum GetAllOpSteps implements IMapOpStep
{
    READ{

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            GetAllOperation operation = (GetAllOperation)state.getOperation();
            Set<Data> partitionKeySet = operation.getPartitionKeySet((List)state.getKeys());
            MapEntries entries = recordStore.getInMemoryEntries(partitionKeySet, state.getNow());
            state.setKeysToLoad(partitionKeySet);
            state.setMapEntries(entries);
        }

        @Override
        public Step nextStep(State state) {
            return !state.getKeysToLoad().isEmpty() ? LOAD_ALL : PROCESS;
        }
    }
    ,
    LOAD_ALL{

        @Override
        public boolean isLoadStep() {
            return true;
        }

        @Override
        public void runStep(State state) {
            MultipleEntryOpSteps.LOAD_ALL.runStep(state);
        }

        @Override
        public Step nextStep(State state) {
            return PROCESS;
        }
    }
    ,
    PROCESS{

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            MapEntries mapEntries = state.getMapEntries();
            List loadedKeyAndOldValueWithExpiryPairs = state.loadedKeyAndOldValueWithExpiryPairs();
            Map<Data, Object> loaded = recordStore.putAndGetLoadedEntries(loadedKeyAndOldValueWithExpiryPairs, state.getCallerAddress(), state.getNow());
            recordStore.addToMapEntrySet(mapEntries, loaded);
            state.setMapEntries(mapEntries);
        }

        @Override
        public Step nextStep(State state) {
            return UtilSteps.FINAL_STEP;
        }
    };

}

