/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.wav;

import com.drew.imaging.riff.RiffHandler;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.wav.WavDirectory;
import java.io.IOException;

public class WavRiffHandler
implements RiffHandler {
    @NotNull
    private final WavDirectory _directory = new WavDirectory();
    @NotNull
    private String _currentList = "";

    public WavRiffHandler(@NotNull Metadata metadata) {
        metadata.addDirectory(this._directory);
    }

    @Override
    public boolean shouldAcceptRiffIdentifier(@NotNull String identifier) {
        return identifier.equals("WAVE");
    }

    @Override
    public boolean shouldAcceptChunk(@NotNull String fourCC) {
        return fourCC.equals("fmt ") || this._currentList.equals("INFO") && WavDirectory._tagIntegerMap.containsKey(fourCC) || fourCC.equals("data");
    }

    @Override
    public boolean shouldAcceptList(@NotNull String fourCC) {
        if (fourCC.equals("INFO")) {
            this._currentList = "INFO";
            return true;
        }
        this._currentList = "";
        return false;
    }

    @Override
    public void processChunk(@NotNull String fourCC, @NotNull byte[] payload) {
        block12: {
            try {
                if (fourCC.equals("fmt ")) {
                    ByteArrayReader reader = new ByteArrayReader(payload);
                    reader.setMotorolaByteOrder(false);
                    short wFormatTag = reader.getInt16(0);
                    short wChannels = reader.getInt16(2);
                    int dwSamplesPerSec = reader.getInt32(4);
                    int dwAvgBytesPerSec = reader.getInt32(8);
                    short wBlockAlign = reader.getInt16(12);
                    switch (wFormatTag) {
                        case 1: {
                            short wBitsPerSample = reader.getInt16(14);
                            this._directory.setInt(6, wBitsPerSample);
                            this._directory.setString(1, WavDirectory._audioEncodingMap.get(wFormatTag));
                            break;
                        }
                        default: {
                            if (WavDirectory._audioEncodingMap.containsKey(wFormatTag)) {
                                this._directory.setString(1, WavDirectory._audioEncodingMap.get(wFormatTag));
                                break;
                            }
                            this._directory.setString(1, "Unknown");
                        }
                    }
                    this._directory.setInt(2, wChannels);
                    this._directory.setInt(3, dwSamplesPerSec);
                    this._directory.setInt(4, dwAvgBytesPerSec);
                    this._directory.setInt(5, wBlockAlign);
                    break block12;
                }
                if (fourCC.equals("data")) {
                    try {
                        if (this._directory.containsTag(4)) {
                            double duration = (double)payload.length / this._directory.getDouble(4);
                            Integer hours = (int)duration / (int)Math.pow(60.0, 2.0);
                            Integer minutes = (int)duration / (int)Math.pow(60.0, 1.0) - hours * 60;
                            Integer seconds = (int)Math.round(duration / Math.pow(60.0, 0.0) - (double)(minutes * 60));
                            String time = String.format("%1$02d:%2$02d:%3$02d", hours, minutes, seconds);
                            this._directory.setString(16, time);
                        }
                        break block12;
                    }
                    catch (MetadataException ex) {
                        this._directory.addError("Error calculating duration: bytes per second not found");
                    }
                    break block12;
                }
                if (WavDirectory._tagIntegerMap.containsKey(fourCC)) {
                    this._directory.setString(WavDirectory._tagIntegerMap.get(fourCC), new String(payload).substring(0, payload.length - 1));
                }
            }
            catch (IOException ex) {
                this._directory.addError(ex.getMessage());
            }
        }
    }

    @Override
    public void addError(@NotNull String message) {
        this._directory.addError(message);
    }
}

