/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.publish;

import java.util.ArrayList;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.foundation.common.utils.StringBuilderUtils;
import org.apache.servicecomb.foundation.metrics.publish.MeasurementNode;
import org.apache.servicecomb.foundation.metrics.publish.MeasurementTree;
import org.apache.servicecomb.metrics.core.publish.AbstractMeasurementNodeLogPublisher;

public class ClientEndpointsLogPublisher
extends AbstractMeasurementNodeLogPublisher {
    public ClientEndpointsLogPublisher(MeasurementTree tree, StringBuilder sb, String meterName) {
        super(tree, sb, "servicecomb.vertx.endpoints", meterName);
    }

    @Override
    public void print(boolean printDetail) {
        if (!printDetail) {
            return;
        }
        StringBuilderUtils.appendLine((StringBuilder)this.sb, (String)"    client.endpoints:", (Object[])new Object[0]);
        StringBuilderUtils.appendLine((StringBuilder)this.sb, (String)"      connectCount disconnectCount queue         connections requests latency send(Bps) receive(Bps) remote", (Object[])new Object[0]);
        ArrayList measurements = new ArrayList(this.measurementNode.getChildren().size());
        measurements.addAll(this.measurementNode.getChildren().values());
        measurements.sort(MeasurementNode::compareTo);
        for (MeasurementNode address : measurements) {
            StringBuilderUtils.appendLine((StringBuilder)this.sb, (String)"      %-12.0f %-15.0f %-13.0f %-11.0f %-8.0f %-7.0f %-9s %-12s %s", (Object[])new Object[]{address.findChild("connectCount").summary(), address.findChild("disconnectCount").summary(), address.findChild("queueCount").summary(), address.findChild("connections").summary(), address.findChild("requests").summary(), address.findChild("latency").summary(), NetUtils.humanReadableBytes((long)((long)address.findChild("bytesWritten").summary())), NetUtils.humanReadableBytes((long)((long)address.findChild("bytesRead").summary())), address.getName()});
        }
    }
}

