/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.geometry.wrapper.GeometryType;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.metadata.sql.internal.shared.SQLBuilder;
import org.apache.sis.metadata.sql.internal.shared.SQLUtilities;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.internal.shared.DefinitionVerifier;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.sql.feature.Analyzer;
import org.apache.sis.storage.sql.feature.CRSEncoding;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.GeometryTypeEncoding;
import org.apache.sis.storage.sql.feature.Resources;
import org.apache.sis.storage.sql.feature.SpatialSchema;
import org.apache.sis.storage.sql.feature.TableReference;
import org.apache.sis.system.CommonExecutor;
import org.apache.sis.util.Localized;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public class InfoStatements
implements Localized,
AutoCloseable {
    private static final int LOW_SRID_RANGE = 1000;
    private static final int HIGH_SRID_RANGE = 40000;
    protected final Database<?> database;
    private final Connection connection;
    protected PreparedStatement geometryColumns;
    protected boolean isAnalysisPrepared;
    private PreparedStatement sridForUnknownTable;
    private PreparedStatement sridFromCRS;
    private PreparedStatement wktFromSrid;
    private WKTFormat wktFormat;
    private boolean cannotReadGeometryType;

    protected InfoStatements(Database<?> database, Connection connection) {
        this.database = database;
        this.connection = connection;
    }

    public final Locale getLocale() {
        return this.database.listeners.getLocale();
    }

    private SQLBuilder builder() throws SQLException {
        SQLBuilder builder = new SQLBuilder(this.database);
        builder.setCatalogAndSchema(this.connection);
        return builder;
    }

    private void appendFrom(SQLBuilder sql, String table) {
        this.database.formatTableName(sql.append(" FROM "), table);
        sql.append(" WHERE ");
    }

    private static SQLBuilder appendColumn(SQLBuilder sql, boolean raster, String column) {
        if (raster && column.startsWith("F_")) {
            return sql.append('R').append(column, 1, column.length());
        }
        return sql.append(column);
    }

    protected final PreparedStatement prepareIntrospectionStatement(Analyzer analyzer, String table, boolean raster, String geomColNameColumn, String geomTypeColumn) throws SQLException {
        if (analyzer.skipInfoTable(table)) {
            return null;
        }
        SpatialSchema schema = this.database.getSpatialSchema().orElseThrow();
        SQLBuilder sql = this.builder().append("SELECT ");
        if (geomColNameColumn == null) {
            geomColNameColumn = schema.geomColNameColumn;
        }
        InfoStatements.appendColumn(sql, raster, geomColNameColumn).append(", ").append(schema.crsIdentifierColumn);
        if (geomTypeColumn == null) {
            geomTypeColumn = schema.geomTypeColumn;
        }
        if (geomTypeColumn != null && !geomTypeColumn.isEmpty()) {
            sql.append(", ").append(geomTypeColumn);
        }
        this.appendFrom(sql, table);
        if (this.database.supportsCatalogs) {
            InfoStatements.appendColumn(sql, raster, schema.geomCatalogColumn).append(" LIKE ? AND ");
        }
        if (this.database.supportsSchemas) {
            InfoStatements.appendColumn(sql, raster, schema.geomSchemaColumn).append(" LIKE ? AND ");
        }
        InfoStatements.appendColumn(sql, raster, schema.geomTableColumn).append("=?");
        return this.connection.prepareStatement(sql.toString());
    }

    private void setCatalogOrSchema(PreparedStatement columnQuery, int p, String source) throws SQLException {
        source = source == null || source.isEmpty() ? "%" : this.database.escapeWildcards(source);
        columnQuery.setString(p, source);
    }

    public void completeIntrospection(Analyzer analyzer, TableReference source, Map<String, Column> columns) throws Exception {
        SpatialSchema schema = this.database.getSpatialSchema().orElseThrow();
        if (!this.isAnalysisPrepared) {
            this.isAnalysisPrepared = true;
            this.geometryColumns = this.prepareIntrospectionStatement(analyzer, schema.geometryColumns, false, null, null);
        }
        this.configureSpatialColumns(this.geometryColumns, source, columns, schema.typeEncoding);
    }

    protected final void configureSpatialColumns(PreparedStatement columnQuery, TableReference source, Map<String, Column> columns, GeometryTypeEncoding typeValueKind) throws Exception {
        if (columnQuery == null || columns.isEmpty()) {
            return;
        }
        int p = 0;
        if (this.database.supportsCatalogs) {
            this.setCatalogOrSchema(columnQuery, ++p, source.catalog);
        }
        if (this.database.supportsSchemas) {
            this.setCatalogOrSchema(columnQuery, ++p, source.schema);
        }
        columnQuery.setString(++p, source.table);
        try (ResultSet result = columnQuery.executeQuery();){
            while (result.next()) {
                Column target = columns.get(result.getString(1));
                if (target == null) continue;
                GeometryType type = null;
                if (typeValueKind != null) {
                    block14: {
                        try {
                            type = typeValueKind.parse(result, 3);
                        }
                        catch (IllegalArgumentException e) {
                            if (this.cannotReadGeometryType) break block14;
                            this.cannotReadGeometryType = true;
                            this.database.warning((short)17, e);
                        }
                    }
                    if (type == null) {
                        type = GeometryType.GEOMETRY;
                    }
                }
                target.makeSpatial(this.database, type, this.fetchCRS(result.getInt(2)));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final CoordinateReferenceSystem guessCRS(String column) throws Exception {
        if (this.sridForUnknownTable == null) {
            if (this.geometryColumns == null) {
                return null;
            }
            SpatialSchema schema = this.database.getSpatialSchema().orElseThrow();
            SQLBuilder sql = this.builder().append("SELECT ").append("DISTINCT ").appendIdentifier(schema.crsIdentifierColumn).append(" FROM ").appendIdentifier(schema.geometryColumns).append(" WHERE ").appendIdentifier(schema.geomColNameColumn).append("=?");
            this.sridForUnknownTable = this.connection.prepareStatement(sql.toString());
        }
        this.sridForUnknownTable.setString(1, column);
        CoordinateReferenceSystem first = null;
        try (ResultSet result = this.sridForUnknownTable.executeQuery();){
            block12: {
                while (result.next()) {
                    CoordinateReferenceSystem crs;
                    int srid = result.getInt(1);
                    if (result.wasNull() || (crs = this.fetchCRS(srid)) == null) continue;
                    if (first == null) {
                        first = crs;
                        continue;
                    }
                    if (CRS.equivalent((CoordinateReferenceSystem)first, (CoordinateReferenceSystem)crs)) {
                        continue;
                    }
                    break block12;
                }
                return first;
            }
            CoordinateReferenceSystem coordinateReferenceSystem = null;
            return coordinateReferenceSystem;
        }
    }

    public final CoordinateReferenceSystem fetchCRS(int srid) throws Exception {
        if (srid <= 0) {
            return null;
        }
        return (CoordinateReferenceSystem)this.database.cacheOfCRS.getOrCreate((Object)srid, () -> this.parseCRS(srid));
    }

    private PreparedStatement prepareSearchCRS(boolean byAuthorityCode) throws SQLException {
        String get;
        String search;
        SpatialSchema schema = this.database.getSpatialSchema().orElseThrow();
        if (byAuthorityCode) {
            search = schema.crsAuthorityCodeColumn;
            get = schema.crsIdentifierColumn;
        } else {
            search = schema.crsIdentifierColumn;
            get = schema.crsAuthorityCodeColumn;
        }
        SQLBuilder sql = this.builder().append("SELECT ").append(schema.crsAuthorityNameColumn).append(", ").append(get);
        for (CRSEncoding encoding : this.database.crsEncodings) {
            sql.append(", ").append(schema.crsDefinitionColumn.get((Object)encoding));
        }
        this.appendFrom(sql, schema.crsTable);
        sql.append(search).append("=?");
        if (byAuthorityCode) {
            sql.append(" AND LOWER(").append(schema.crsAuthorityNameColumn).append(") LIKE ?");
        }
        return this.connection.prepareStatement(sql.toString());
    }

    private CoordinateReferenceSystem parseCRS(int srid) throws Exception {
        if (this.wktFromSrid == null) {
            this.wktFromSrid = this.prepareSearchCRS(false);
        }
        this.wktFromSrid.setInt(1, srid);
        CoordinateReferenceSystem crs = null;
        NoSuchAuthorityCodeException authorityError = null;
        LogRecord warning = null;
        try (ResultSet result = this.wktFromSrid.executeQuery();){
            while (result.next()) {
                Warnings w;
                CoordinateReferenceSystem fromDefinition;
                CoordinateReferenceSystem fromAuthority = null;
                String authority = result.getString(1);
                if (authority != null && !authority.isEmpty()) {
                    int code = result.getInt(2);
                    if (!result.wasNull()) {
                        try {
                            CRSAuthorityFactory factory = CRS.getAuthorityFactory((String)authority);
                            fromAuthority = factory.createCoordinateReferenceSystem(Integer.toString(code));
                        }
                        catch (NoSuchAuthorityCodeException e) {
                            authorityError = e;
                        }
                    }
                }
                try {
                    Object parsed = this.parseDefinition(result, 3);
                    if (parsed != null && !(parsed instanceof CoordinateReferenceSystem)) {
                        throw this.invalidSRID((short)11, ReferencingUtilities.getInterface((Object)parsed), srid, authorityError);
                    }
                    fromDefinition = (CoordinateReferenceSystem)parsed;
                }
                catch (ParseException e) {
                    if (authorityError != null) {
                        e.addSuppressed(authorityError);
                    }
                    throw e;
                }
                DefinitionVerifier v = DefinitionVerifier.compare((CoordinateReferenceSystem)fromDefinition, fromAuthority, (Locale)this.getLocale());
                if (v.recommendation == null) continue;
                if (crs == null) {
                    crs = v.recommendation;
                } else if (!crs.equals((Object)v.recommendation)) {
                    SpatialSchema schema = this.database.getSpatialSchema().orElseThrow();
                    throw this.invalidSRID((short)9, schema.crsTable, srid, authorityError);
                }
                if ((warning = v.warning(false)) != null || fromDefinition == null || (w = this.wktFormat.getWarnings()) == null) continue;
                warning = new LogRecord(Level.WARNING, w.toString(this.getLocale()));
            }
        }
        if (crs == null) {
            if (authorityError != null) {
                throw authorityError;
            }
            SpatialSchema schema = this.database.getSpatialSchema().orElseThrow();
            throw this.invalidSRID((short)10, schema.crsTable, srid, null);
        }
        this.log("fetchCRS", warning);
        return crs;
    }

    private void log(String method, LogRecord warning) {
        if (warning != null) {
            warning.setLoggerName("org.apache.sis.sql");
            warning.setSourceClassName(this.getClass().getCanonicalName());
            warning.setSourceMethodName(method);
            this.database.listeners.warning(warning);
        }
    }

    private DataStoreContentException invalidSRID(short message, Object complement, int srid, NoSuchAuthorityCodeException suppressed) {
        DataStoreContentException e = new DataStoreContentException(Resources.forLocale(this.getLocale()).getString(message, complement, srid));
        if (suppressed != null) {
            e.addSuppressed((Throwable)suppressed);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int findSRID(CoordinateReferenceSystem crs) throws Exception {
        SRID result;
        if (crs == null) {
            return 0;
        }
        WeakHashMap<CoordinateReferenceSystem, Integer> weakHashMap = this.database.cacheOfSRID;
        synchronized (weakHashMap) {
            Integer cached = this.database.cacheOfSRID.get(crs);
            if (cached != null) {
                return cached;
            }
            try {
                result = this.findOrAddCRS(crs);
            }
            catch (BackingStoreException e) {
                throw (FactoryException)((Object)e.unwrapOrRethrow(FactoryException.class));
            }
            this.database.cacheOfSRID.put(crs, result.srid);
        }
        CommonExecutor.instance().submit(result);
        return result.srid;
    }

    private SRID findOrAddCRS(CoordinateReferenceSystem crs) throws Exception {
        Exception error = null;
        boolean tryWithGivenCRS = true;
        HashSet<Integer> sridFounInUse = new HashSet<Integer>();
        LinkedHashMap<SRID, Boolean> done = new LinkedHashMap<SRID, Boolean>();
        Iterator<Object> it = Set.of(crs).iterator();
        while (it.hasNext()) {
            IdentifiedObject candidate = (IdentifiedObject)it.next();
            for (ReferenceIdentifier id : candidate.getIdentifiers()) {
                int code;
                String authority = id.getCodeSpace();
                if (authority == null) continue;
                try {
                    code = Integer.parseInt(id.getCode());
                }
                catch (NumberFormatException e) {
                    if (!tryWithGivenCRS) continue;
                    if (error == null) {
                        error = e;
                        continue;
                    }
                    error.addSuppressed(e);
                    continue;
                }
                SRID search = new SRID(crs, authority, code);
                if (done.putIfAbsent(search, code > 0) != null) continue;
                if (this.sridFromCRS == null) {
                    this.sridFromCRS = this.prepareSearchCRS(true);
                }
                this.sridFromCRS.setInt(1, code);
                this.sridFromCRS.setString(2, SQLUtilities.toLikePattern((String)authority, (boolean)true, (String)this.database.wildcardEscape));
                ResultSet result = this.sridFromCRS.executeQuery();
                try {
                    while (result.next()) {
                        if (!SQLUtilities.filterFalsePositive((String)authority, (String)result.getString(1))) continue;
                        int srid = result.getInt(2);
                        if (sridFounInUse.add(srid)) {
                            try {
                                Object parsed = this.parseDefinition(result, 3);
                                if (Utilities.equalsApproximately((Object)parsed, (Object)crs)) {
                                    search.srid = srid;
                                    SRID sRID = search;
                                    return sRID;
                                }
                            }
                            catch (ParseException e) {
                                if (error == null) {
                                    error = e;
                                }
                                error.addSuppressed(e);
                            }
                        }
                        done.put(search, Boolean.FALSE);
                    }
                }
                finally {
                    if (result == null) continue;
                    result.close();
                }
            }
            if (!tryWithGivenCRS) continue;
            tryWithGivenCRS = false;
            IdentifiedObjectFinder finder = IdentifiedObjects.newFinder((String)"EPSG");
            finder.setIgnoringAxes(true);
            it = finder.find((IdentifiedObject)crs).iterator();
        }
        if (!this.connection.isReadOnly()) {
            SRID fallback = null;
            for (Map.Entry entry : done.entrySet()) {
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                SRID search = (SRID)entry.getKey();
                if ("EPSG".equalsIgnoreCase(search.authority)) {
                    search.srid = this.addCRS(search, sridFounInUse);
                    return search;
                }
                if (fallback != null) continue;
                fallback = search;
            }
            if (fallback != null) {
                fallback.srid = this.addCRS(fallback, sridFounInUse);
                return fallback;
            }
        }
        Locale locale = this.getLocale();
        throw new DataStoreReferencingException(Resources.forLocale(locale).getString((short)15, IdentifiedObjects.getDisplayName((IdentifiedObject)crs, (Locale)locale)), error);
    }

    /*
     * Exception decompiling
     */
    private int addCRS(SRID search, Set<Integer> sridFounInUse) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void filterConstraintViolation(SQLException e) throws SQLException {
        String state = e.getSQLState();
        if (state == null || !state.equals("23505")) {
            throw e;
        }
    }

    private int findFreeSRID(SpatialSchema schema, SQLBuilder sql) throws SQLException {
        this.appendFrom(sql.append("MAX(").append(schema.crsIdentifierColumn).append(')'), schema.crsTable);
        sql.append(schema.crsIdentifierColumn).append('<').append(1000);
        try (Statement stmt = this.connection.createStatement();){
            boolean high = false;
            while (true) {
                block19: {
                    ResultSet result = stmt.executeQuery(sql.toString());
                    if (!result.next()) break block19;
                    int srid = result.getInt(1) + 1;
                    if (high) {
                        int n = Math.max(srid, 40000);
                        return n;
                    }
                    if (srid >= 1000) break block19;
                    int n = Math.max(srid, 1);
                    return n;
                    finally {
                        if (result != null) {
                            result.close();
                        }
                    }
                }
                if (high) {
                    int n = 1;
                    return n;
                }
                high = true;
                sql.removeWhereClause();
            }
        }
    }

    private Object parseDefinition(ResultSet result, int column) throws SQLException, ParseException {
        for (CRSEncoding encoding : this.database.crsEncodings) {
            String def;
            if ((def = result.getString(column++)) == null || def.isBlank() || def.equalsIgnoreCase("undefined")) continue;
            switch (encoding) {
                default: 
            }
            return this.wktFormat().parseObject(def);
        }
        return null;
    }

    private WKTFormat wktFormat() {
        if (this.wktFormat == null) {
            this.wktFormat = new WKTFormat();
            this.wktFormat.setIndentation(-1);
            this.wktFormat.setConvention(Convention.WKT1_COMMON_UNITS);
        }
        return this.wktFormat;
    }

    @Override
    public void close() throws SQLException {
        if (this.geometryColumns != null) {
            this.geometryColumns.close();
            this.geometryColumns = null;
        }
        if (this.wktFromSrid != null) {
            this.wktFromSrid.close();
            this.wktFromSrid = null;
        }
        if (this.sridFromCRS != null) {
            this.sridFromCRS.close();
            this.sridFromCRS = null;
        }
    }

    private final class SRID
    implements Callable<CoordinateReferenceSystem>,
    Runnable {
        final CoordinateReferenceSystem crs;
        final String authority;
        final int code;
        int srid;

        SRID(CoordinateReferenceSystem crs, String authority, int code) {
            this.crs = crs;
            this.authority = authority;
            this.code = code;
        }

        @Override
        public void run() {
            try {
                InfoStatements.this.database.cacheOfCRS.getOrCreate((Object)this.srid, (Callable)this);
            }
            catch (Exception e) {
                InfoStatements.this.log("findSRID", new LogRecord(Level.FINER, e.toString()));
            }
        }

        @Override
        public CoordinateReferenceSystem call() throws FactoryException {
            CoordinateReferenceSystem fromAuthority;
            try {
                CRSAuthorityFactory factory = CRS.getAuthorityFactory((String)this.authority);
                fromAuthority = factory.createCoordinateReferenceSystem(Integer.toString(this.code));
            }
            catch (NoSuchAuthorityCodeException e) {
                return this.crs;
            }
            int i = 0;
            while (true) {
                CoordinateReferenceSystem candidate;
                switch (i) {
                    case 0: {
                        candidate = fromAuthority;
                        break;
                    }
                    case 1: {
                        candidate = AbstractCRS.castOrCopy((CoordinateReferenceSystem)fromAuthority).forConvention(AxesConvention.RIGHT_HANDED);
                        break;
                    }
                    case 2: {
                        candidate = AbstractCRS.castOrCopy((CoordinateReferenceSystem)fromAuthority).forConvention(AxesConvention.DISPLAY_ORIENTED);
                        break;
                    }
                    default: {
                        return this.crs;
                    }
                }
                if (Utilities.equalsApproximately((Object)this.crs, (Object)candidate)) {
                    return candidate;
                }
                ++i;
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof SRID) {
                SRID other = (SRID)obj;
                return other.code == this.code && this.authority.equals(other.authority);
            }
            return false;
        }

        public int hashCode() {
            return this.authority.hashCode() + this.code;
        }

        public String toString() {
            return this.authority + ":" + this.code + " \u2192 " + this.srid;
        }
    }
}

