/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.storage.CoverageQuery;
import org.apache.sis.storage.DataSet;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Query;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.UnsupportedQueryException;
import org.apache.sis.util.ArraysExt;
import org.opengis.geometry.Envelope;

public interface GridCoverageResource
extends DataSet {
    @Override
    default public Optional<Envelope> getEnvelope() throws DataStoreException {
        GridGeometry gg = this.getGridGeometry();
        if (gg != null && gg.isDefined(2)) {
            return Optional.of(gg.getEnvelope());
        }
        return Optional.empty();
    }

    public GridGeometry getGridGeometry() throws DataStoreException;

    public List<SampleDimension> getSampleDimensions() throws DataStoreException;

    default public List<double[]> getResolutions() throws DataStoreException {
        double[] resolution;
        GridGeometry gg = this.getGridGeometry();
        if (gg != null && gg.isDefined(16) && !ArraysExt.allEquals((double[])(resolution = gg.getResolution(false)), (double)Double.NaN)) {
            return List.of(resolution);
        }
        return List.of();
    }

    default public GridCoverageResource subset(Query query) throws UnsupportedQueryException, DataStoreException {
        if (Objects.requireNonNull(query) instanceof CoverageQuery) {
            try {
                return ((CoverageQuery)query).execute(this);
            }
            catch (RuntimeException e) {
                throw new UnsupportedQueryException(e);
            }
        }
        throw new UnsupportedQueryException();
    }

    public GridCoverage read(GridGeometry var1, int ... var2) throws DataStoreException;

    default public RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        return RasterLoadingStrategy.AT_READ_TIME;
    }

    default public boolean setLoadingStrategy(RasterLoadingStrategy strategy) throws DataStoreException {
        return Objects.requireNonNull(strategy) == this.getLoadingStrategy();
    }
}

