/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.provider.AbridgedMolodensky;
import org.apache.sis.referencing.operation.provider.Molodensky;
import org.apache.sis.referencing.operation.transform.AbridgedMolodenskyTransform2D;
import org.apache.sis.referencing.operation.transform.DatumShiftTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.MolodenskyTransform2D;
import org.apache.sis.referencing.operation.transform.TransformJoiner;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.internal.shared.Numerics;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class MolodenskyTransform
extends DatumShiftTransform {
    private static final long serialVersionUID = 1741638055238886288L;
    private static ParameterDescriptorGroup DESCRIPTOR;
    static final double ANGULAR_SCALE = 1.0000000000039175;
    private final boolean isSource3D;
    private final boolean isTarget3D;
    private final boolean isAbridged;
    protected final double tX;
    protected final double tY;
    protected final double tZ;
    private final double \u0394a;
    final double \u0394fmod;
    protected final double semiMajor;
    protected final double eccentricitySquared;
    private MolodenskyTransform inverse;

    public MolodenskyTransform(Ellipsoid source, boolean isSource3D, Ellipsoid target, boolean isTarget3D, double tX, double tY, double tZ, boolean isAbridged) {
        this(source, isSource3D, target, isTarget3D, tX, tY, tZ, null, isAbridged, isAbridged ? AbridgedMolodensky.PARAMETERS : Molodensky.PARAMETERS);
        this.inverse = !isSource3D && !isTarget3D ? (isAbridged && tX == 0.0 && tY == 0.0 && tZ == 0.0 ? new AbridgedMolodenskyTransform2D(this, source, target) : new MolodenskyTransform2D(this, source, target)) : new MolodenskyTransform(this, source, target);
    }

    MolodenskyTransform(MolodenskyTransform inverse, Ellipsoid source, Ellipsoid target) {
        this(target, inverse.isTarget3D, source, inverse.isSource3D, -inverse.tX, -inverse.tY, -inverse.tZ, inverse.grid, inverse.isAbridged, inverse.context.getDescriptor());
        this.inverse = inverse;
    }

    private MolodenskyTransform(MolodenskyTransform other, boolean isSource3D, boolean isTarget3D, boolean createInverse) {
        super(other, isSource3D ? 3 : 2, isTarget3D ? 3 : 2);
        this.isSource3D = isSource3D;
        this.isTarget3D = isTarget3D;
        this.isAbridged = other.isAbridged;
        this.tX = other.tX;
        this.tY = other.tY;
        this.tZ = other.tZ;
        this.\u0394a = other.\u0394a;
        this.\u0394fmod = other.\u0394fmod;
        this.semiMajor = other.semiMajor;
        this.eccentricitySquared = other.eccentricitySquared;
        if (createInverse) {
            this.inverse = new MolodenskyTransform(other.inverse, isTarget3D, isSource3D, false);
            this.inverse.inverse = this;
        }
    }

    private MolodenskyTransform(Ellipsoid source, boolean isSource3D, Ellipsoid target, boolean isTarget3D, double tX, double tY, double tZ, DatumShiftGrid<?, ?> grid, boolean isAbridged, ParameterDescriptorGroup descriptor) {
        super(descriptor, isSource3D, isTarget3D, grid);
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        ArgumentChecks.ensureNonNull((String)"target", (Object)target);
        DefaultEllipsoid src = DefaultEllipsoid.castOrCopy(source);
        this.isSource3D = isSource3D;
        this.isTarget3D = isTarget3D;
        this.isAbridged = isAbridged;
        this.semiMajor = src.getSemiMajorAxis();
        this.\u0394a = src.semiMajorAxisDifference(target);
        this.tX = tX;
        this.tY = tY;
        this.tZ = tZ;
        double semiMinor = src.getSemiMinorAxis();
        double \u0394f = src.flatteningDifference(target);
        this.eccentricitySquared = src.getEccentricitySquared();
        this.\u0394fmod = isAbridged ? this.semiMajor * \u0394f + (this.semiMajor - semiMinor) * (this.\u0394a / this.semiMajor) : semiMinor * \u0394f;
        Unit<Length> unit = src.getAxisUnit();
        this.setContextParameters(this.semiMajor, semiMinor, unit, target);
        this.completeParameters(this.context, unit, \u0394f);
        this.context.normalizeGeographicInputs(0.0);
        this.context.denormalizeGeographicOutputs(0.0);
    }

    private void completeParameters(Parameters pg, Unit<?> unit, double \u0394f) {
        if (Double.isNaN(\u0394f)) {
            \u0394f = this.context.doubleValue(Molodensky.FLATTENING_DIFFERENCE);
        }
        pg.getOrCreate(Molodensky.DIMENSION).setValue(this.getSourceDimensions());
        pg.getOrCreate(Molodensky.TX).setValue(this.tX, unit);
        pg.getOrCreate(Molodensky.TY).setValue(this.tY, unit);
        pg.getOrCreate(Molodensky.TZ).setValue(this.tZ, unit);
        pg.getOrCreate(Molodensky.AXIS_LENGTH_DIFFERENCE).setValue(this.\u0394a, unit);
        pg.getOrCreate(Molodensky.FLATTENING_DIFFERENCE).setValue(\u0394f, Units.UNITY);
        if (pg != this.context) {
            pg.parameter("abridged").setValue(this.isAbridged);
        }
    }

    public static MathTransform createGeodeticTransformation(MathTransformFactory factory, Ellipsoid source, boolean isSource3D, Ellipsoid target, boolean isTarget3D, double tX, double tY, double tZ, boolean isAbridged) throws FactoryException {
        MolodenskyTransform tr = !isSource3D && !isTarget3D ? (isAbridged && tX == 0.0 && tY == 0.0 && tZ == 0.0 ? new AbridgedMolodenskyTransform2D(source, target) : new MolodenskyTransform2D(source, target, tX, tY, tZ, isAbridged)) : new MolodenskyTransform(source, isSource3D, target, isTarget3D, tX, tY, tZ, isAbridged);
        tr.inverse.context.completeTransform(factory, null);
        return tr.context.completeTransform(factory, tr);
    }

    @Override
    protected void tryConcatenate(TransformJoiner context) throws FactoryException {
        if (!(this.isSource3D && context.removeUnusedDimensions(-1, 2, 3, d -> d == 2 ? new MolodenskyTransform(this, false, this.isTarget3D, true) : null) || this.isTarget3D && context.removeUnusedDimensions(1, 2, 3, d -> d == 2 ? new MolodenskyTransform(this, this.isSource3D, false, true) : null))) {
            super.tryConcatenate(context);
        }
    }

    @Override
    public boolean isIdentity() {
        return this.tX == 0.0 && this.tY == 0.0 && this.tZ == 0.0 && this.\u0394a == 0.0 && this.\u0394fmod == 0.0 && this.getSourceDimensions() == this.getTargetDimensions();
    }

    @Override
    public final int getSourceDimensions() {
        return this.isSource3D ? 3 : 2;
    }

    @Override
    public final int getTargetDimensions() {
        return this.isTarget3D ? 3 : 2;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        double \u03bb = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double h = this.isSource3D ? srcPts[srcOff + 2] : 0.0;
        double sin\u03bb = Math.sin(\u03bb);
        double cos\u03bb = Math.cos(\u03bb);
        double sin\u03c6 = Math.sin(\u03c6);
        double cos\u03c6 = Math.cos(\u03c6);
        double sin2\u03c6 = sin\u03c6 * sin\u03c6;
        double \u03bd2den = 1.0 - this.eccentricitySquared * sin2\u03c6;
        double \u03bdden = Math.sqrt(\u03bd2den);
        double \u03c1den = \u03bd2den * \u03bdden;
        double \u03c1 = this.semiMajor * (1.0 - this.eccentricitySquared) / \u03c1den;
        double \u03bd = this.semiMajor / \u03bdden;
        double t = this.\u0394fmod * 2.0;
        if (!this.isAbridged) {
            \u03c1 += h;
            \u03bd += h;
            t = t * (0.5 / \u03bdden + 0.5 / \u03c1den) + this.\u0394a * this.eccentricitySquared / \u03bdden;
        }
        double spc\u03bb = this.tY * sin\u03bb + this.tX * cos\u03bb;
        double cms\u03bb = this.tY * cos\u03bb - this.tX * sin\u03bb;
        double cms\u03c6 = (this.tZ + t * sin\u03c6) * cos\u03c6 - spc\u03bb * sin\u03c6;
        double scaleX = 1.0000000000039175 / (\u03bd * cos\u03c6);
        double scaleY = 1.0000000000039175 / \u03c1;
        double \u03bbt = \u03bb + cms\u03bb * scaleX;
        double \u03c6t = \u03c6 + cms\u03c6 * scaleY;
        if (dstPts != null) {
            dstPts[dstOff++] = \u03bbt;
            dstPts[dstOff++] = \u03c6t;
            if (this.isTarget3D) {
                double t1 = this.\u0394fmod * sin2\u03c6;
                double t2 = this.\u0394a;
                if (!this.isAbridged) {
                    t1 /= \u03bdden;
                    t2 *= \u03bdden;
                }
                dstPts[dstOff++] = h + spc\u03bb * cos\u03c6 + this.tZ * sin\u03c6 + t1 - t2;
            }
        }
        if (!derivate) {
            return null;
        }
        MatrixSIS matrix = Matrices.createDiagonal(this.getTargetDimensions(), this.getSourceDimensions());
        double sin\u03c6cos\u03c6 = sin\u03c6 * cos\u03c6;
        double d\u03bd = this.eccentricitySquared * sin\u03c6cos\u03c6 / \u03bd2den;
        double d\u03bd3\u03c1 = 3.0 * d\u03bd * (1.0 - this.eccentricitySquared) / \u03bd2den;
        double dYd\u03bb = cms\u03bb * sin\u03c6;
        double dZd\u03bb = cms\u03bb * cos\u03c6;
        double dXd\u03c6 = dYd\u03bb / cos\u03c6;
        double dYd\u03c6 = -this.tZ * sin\u03c6 - cos\u03c6 * spc\u03bb + t * (1.0 - 2.0 * sin2\u03c6);
        double dZd\u03c6 = this.tZ * cos\u03c6 - sin\u03c6 * spc\u03bb;
        if (this.isAbridged) {
            dXd\u03c6 -= cms\u03bb * d\u03bd;
            dYd\u03c6 -= cms\u03c6 * d\u03bd3\u03c1;
            dZd\u03c6 += t * cos\u03c6 * sin\u03c6;
        } else {
            double d\u03c1 = d\u03bd3\u03c1 * \u03bdden * (this.semiMajor / \u03c1);
            dXd\u03c6 -= d\u03bd * cms\u03bb * this.semiMajor / (\u03bdden * \u03bd);
            dYd\u03c6 -= d\u03c1 * dZd\u03c6 - (this.\u0394fmod * (d\u03bd * 2.0 / (1.0 - this.eccentricitySquared) + (1.0 + 1.0 / \u03bd2den) * (d\u03bd - d\u03c1)) + this.\u0394a * (d\u03bd + 1.0) * this.eccentricitySquared) * sin\u03c6cos\u03c6 / \u03bdden;
            if (this.isSource3D) {
                double dXdh = cms\u03bb / \u03bd;
                double dYdh = -cms\u03c6 / \u03c1;
                matrix.setElement(0, 2, -dXdh * scaleX);
                matrix.setElement(1, 2, dYdh * scaleY);
            }
            double t1 = this.\u0394fmod * (d\u03bd * sin2\u03c6 + 2.0 * sin\u03c6cos\u03c6);
            double t2 = this.\u0394a * d\u03bd;
            dZd\u03c6 += t1 / \u03bdden + t2 * \u03bdden;
        }
        matrix.setElement(0, 0, 1.0 - spc\u03bb * scaleX);
        matrix.setElement(1, 1, 1.0 + dYd\u03c6 * scaleY);
        matrix.setElement(0, 1, dXd\u03c6 * scaleX);
        matrix.setElement(1, 0, -dYd\u03bb * scaleY);
        if (this.isTarget3D) {
            matrix.setElement(2, 0, dZd\u03bb);
            matrix.setElement(2, 1, dZd\u03c6);
        }
        return matrix;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcInc = 0;
        int dstInc = 0;
        int offFinal = 0;
        double[] dstFinal = null;
        if (srcPts == dstPts) {
            int srcDim = this.isSource3D ? 3 : 2;
            int dstDim = this.isTarget3D ? 3 : 2;
            switch (IterationStrategy.suggest(srcOff, srcDim, dstOff, dstDim, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * srcDim;
                    dstOff += (numPts - 1) * dstDim;
                    srcInc = -2 * srcDim;
                    dstInc = -2 * dstDim;
                    break;
                }
                default: {
                    int upper = srcOff + numPts * srcDim;
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, upper);
                    srcOff = 0;
                    break;
                }
                case BUFFER_TARGET: {
                    dstFinal = dstPts;
                    dstPts = new double[numPts * dstDim];
                    offFinal = dstOff;
                    dstOff = 0;
                }
            }
        }
        while (--numPts >= 0) {
            double \u03bb = srcPts[srcOff++];
            double \u03c6 = srcPts[srcOff++];
            double h = this.isSource3D ? srcPts[srcOff++] : 0.0;
            double sin\u03bb = Math.sin(\u03bb);
            double cos\u03bb = Math.cos(\u03bb);
            double sin\u03c6 = Math.sin(\u03c6);
            double cos\u03c6 = Math.cos(\u03c6);
            double sin2\u03c6 = sin\u03c6 * sin\u03c6;
            double \u03c1den = 1.0 - this.eccentricitySquared * sin2\u03c6;
            double \u03bdden = Math.sqrt(\u03c1den);
            double \u03c1 = this.semiMajor * (1.0 - this.eccentricitySquared) / (\u03c1den *= \u03bdden);
            double \u03bd = this.semiMajor / \u03bdden;
            double t = this.\u0394fmod * 2.0;
            if (!this.isAbridged) {
                \u03c1 += h;
                \u03bd += h;
                t = t * (0.5 / \u03bdden + 0.5 / \u03c1den) + this.\u0394a * this.eccentricitySquared / \u03bdden;
            }
            double spc\u03bb = this.tY * sin\u03bb + this.tX * cos\u03bb;
            dstPts[dstOff++] = \u03bb + 1.0000000000039175 * (this.tY * cos\u03bb - this.tX * sin\u03bb) / (\u03bd * cos\u03c6);
            dstPts[dstOff++] = \u03c6 + 1.0000000000039175 * ((t * cos\u03c6 - spc\u03bb) * sin\u03c6 + this.tZ * cos\u03c6) / \u03c1;
            if (this.isTarget3D) {
                t = this.\u0394fmod * sin2\u03c6;
                double d = this.\u0394a;
                if (!this.isAbridged) {
                    t /= \u03bdden;
                    d *= \u03bdden;
                }
                dstPts[dstOff++] = h + spc\u03bb * cos\u03c6 + this.tZ * sin\u03c6 + t - d;
            }
            srcOff += srcInc;
            dstOff += dstInc;
        }
        if (dstFinal != null) {
            System.arraycopy(dstPts, 0, dstFinal, offFinal, dstPts.length);
        }
    }

    @Override
    public MathTransform inverse() {
        return this.inverse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        Class<MolodenskyTransform> clazz = MolodenskyTransform.class;
        synchronized (MolodenskyTransform.class) {
            if (DESCRIPTOR == null) {
                DESCRIPTOR = Molodensky.internal();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DESCRIPTOR;
        }
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Unit unit = this.context.getOrCreate(Molodensky.SRC_SEMI_MAJOR).getUnit();
        double semiMinor = this.context.getOrCreate(Molodensky.SRC_SEMI_MINOR).doubleValue(unit);
        Parameters pg = Parameters.castOrWrap(this.getParameterDescriptors().createValue());
        pg.getOrCreate(Molodensky.SRC_SEMI_MAJOR).setValue(this.semiMajor, unit);
        pg.getOrCreate(Molodensky.SRC_SEMI_MINOR).setValue(semiMinor, unit);
        this.completeParameters(pg, unit, Double.NaN);
        return pg;
    }

    @Override
    protected int computeHashCode() {
        int code = super.computeHashCode() + Long.hashCode(Double.doubleToLongBits(this.\u0394a) + Double.doubleToLongBits(this.\u0394fmod) + 31L * (Double.doubleToLongBits(this.tX) + 31L * (Double.doubleToLongBits(this.tY) + 31L * Double.doubleToLongBits(this.tZ))));
        if (this.isAbridged) {
            code ^= 0xFFFFFFFF;
        }
        return code;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            MolodenskyTransform that = (MolodenskyTransform)object;
            return this.isSource3D == that.isSource3D && this.isTarget3D == that.isTarget3D && this.isAbridged == that.isAbridged && Numerics.epsilonEqual((double)this.tX, (double)that.tX, (ComparisonMode)mode) && Numerics.epsilonEqual((double)this.tY, (double)that.tY, (ComparisonMode)mode) && Numerics.epsilonEqual((double)this.tZ, (double)that.tZ, (ComparisonMode)mode) && Numerics.epsilonEqual((double)this.\u0394a, (double)that.\u0394a, (ComparisonMode)mode) && Numerics.epsilonEqual((double)this.\u0394fmod, (double)that.\u0394fmod, (ComparisonMode)mode) && Numerics.epsilonEqual((double)this.semiMajor, (double)that.semiMajor, (ComparisonMode)mode) && Numerics.epsilonEqual((double)this.eccentricitySquared, (double)that.eccentricitySquared, (ComparisonMode)mode);
        }
        return false;
    }
}

