/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.sis.metadata.sql.internal.shared.Initializer;
import org.apache.sis.referencing.factory.ConcurrentAuthorityFactory;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.apache.sis.referencing.factory.sql.EPSGInstaller;
import org.apache.sis.referencing.factory.sql.InstallationScriptProvider;
import org.apache.sis.referencing.factory.sql.SQLTranslator;
import org.apache.sis.referencing.internal.DeferredCoordinateOperation;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.ReferencingFactoryContainer;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Messages;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;
import org.opengis.util.NameFactory;

public class EPSGFactory
extends ConcurrentAuthorityFactory<EPSGDataAccess>
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory,
Localized {
    private static final Set<String> CODESPACES = Set.of("EPSG");
    protected final DataSource dataSource;
    protected final NameFactory nameFactory;
    protected final DatumFactory datumFactory;
    protected final CSFactory csFactory;
    protected final CRSFactory crsFactory;
    protected final CoordinateOperationFactory copFactory;
    protected final MathTransformFactory mtFactory;
    private final String catalog;
    private final String schema;
    private final InstallationScriptProvider scriptProvider;
    private volatile SQLTranslator translator;
    final boolean showDeprecated;
    private final Locale locale;

    public EPSGFactory(Map<String, ?> properties) throws UnavailableFactoryException {
        super(EPSGDataAccess.class);
        if (properties == null) {
            properties = Map.of();
        }
        Locale locale = (Locale)properties.get("locale");
        DataSource ds = (DataSource)properties.get("dataSource");
        this.schema = (String)properties.get("schema");
        this.catalog = (String)properties.get("catalog");
        this.scriptProvider = (InstallationScriptProvider)((Object)properties.get("scriptProvider"));
        this.showDeprecated = Boolean.TRUE.equals(properties.get("showDeprecated"));
        if (locale == null) {
            locale = Locale.getDefault(Locale.Category.DISPLAY);
        }
        this.locale = locale;
        if (ds == null) {
            try {
                ds = Initializer.getDataSource();
            }
            catch (Exception e) {
                throw new UnavailableFactoryException(this.canNotUse(e), e);
            }
        }
        if (ds == null) {
            throw new UnavailableFactoryException(String.valueOf(Initializer.unspecified((Locale)locale, (boolean)false)));
        }
        ReferencingFactoryContainer c = new ReferencingFactoryContainer(properties);
        this.dataSource = ds;
        this.nameFactory = c.getNameFactory();
        this.datumFactory = c.getDatumFactory();
        this.csFactory = c.getCSFactory();
        this.crsFactory = c.getCRSFactory();
        this.copFactory = c.getCoordinateOperationFactory();
        this.mtFactory = c.getMathTransformFactory();
        super.setTimeout(10L, TimeUnit.SECONDS);
    }

    private String canNotUse(Exception e) {
        String message = Exceptions.getLocalizedMessage((Throwable)e, (Locale)this.locale);
        if (message == null) {
            message = Classes.getShortClassName((Object)e);
        }
        return Resources.forLocale(this.locale).getString((short)9, "EPSG", message);
    }

    @Override
    public Set<String> getCodeSpaces() {
        return CODESPACES;
    }

    public Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void install(Connection connection) throws UnavailableFactoryException {
        String message = null;
        Exception failure = null;
        boolean success = false;
        try {
            boolean autoCommit;
            if (this.catalog != null) {
                connection.setCatalog(this.catalog);
            }
            if (autoCommit = connection.getAutoCommit()) {
                connection.setAutoCommit(false);
            }
            try (EPSGInstaller installer = new EPSGInstaller(connection, this.schema);){
                try {
                    success = installer.run(this.scriptProvider, this.locale);
                }
                catch (IOException | SQLException e) {
                    message = installer.failure(this.locale);
                    failure = e;
                }
            }
            finally {
                if (autoCommit) {
                    if (success) {
                        connection.commit();
                    } else {
                        connection.rollback();
                    }
                    connection.setAutoCommit(true);
                }
            }
        }
        catch (SQLException e) {
            if (failure != null) {
                failure.addSuppressed(e);
            } else {
                failure = e;
            }
            success = false;
        }
        if (!success) {
            if (message == null) {
                message = Messages.forLocale((Locale)this.locale).getString(failure != null ? (short)2 : 37, (Object)"EPSG");
            }
            UnavailableFactoryException exception = new UnavailableFactoryException(message, Exceptions.unwrap((Exception)failure));
            exception.setUnavailableFactory(this);
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected EPSGDataAccess newDataAccess() throws FactoryException {
        UnavailableFactoryException exception;
        Connection connection = null;
        try {
            String cause;
            connection = this.dataSource.getConnection();
            Initializer.connected((DatabaseMetaData)connection.getMetaData(), EPSGFactory.class, (String)"newDataAccess");
            SQLTranslator tr = this.translator;
            if (tr == null) {
                EPSGFactory ePSGFactory = this;
                synchronized (ePSGFactory) {
                    tr = this.translator;
                    if (tr == null) {
                        tr = new SQLTranslator(connection.getMetaData(), this.catalog, this.schema);
                        try {
                            if (!tr.isSchemaFound()) {
                                this.install(connection);
                                tr.setup(connection.getMetaData());
                            }
                        }
                        finally {
                            this.translator = tr;
                        }
                    }
                }
            }
            if (tr.isSchemaFound()) {
                return this.newDataAccess(connection, tr);
            }
            try {
                cause = SQLTranslator.tableNotFound(connection.getMetaData(), this.locale);
            }
            finally {
                connection.close();
            }
            exception = new UnavailableFactoryException(cause);
        }
        catch (Exception e) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e2) {
                    e.addSuppressed(e2);
                }
            }
            if (e instanceof FactoryException) {
                throw (FactoryException)((Object)e);
            }
            exception = new UnavailableFactoryException(this.canNotUse(e), Exceptions.unwrap((Exception)e));
        }
        exception.setUnavailableFactory(this);
        throw exception;
    }

    protected EPSGDataAccess newDataAccess(Connection connection, SQLTranslator translator) throws SQLException {
        return new EPSGDataAccess(this, connection, translator);
    }

    @Override
    protected boolean canClose(EPSGDataAccess factory) {
        return factory.canClose();
    }

    @Override
    protected boolean isCacheable(String code, Object object) {
        return !(object instanceof DeferredCoordinateOperation);
    }
}

