/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper;

import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.fsprovider.internal.ContentFileExtensions;
import org.apache.sling.fsprovider.internal.FileStatCache;
import org.apache.sling.fsprovider.internal.mapper.ContentFileResourceMapper;
import org.apache.sling.fsprovider.internal.mapper.Escape;
import org.apache.sling.fsprovider.internal.mapper.FileNameComparator;
import org.apache.sling.fsprovider.internal.mapper.FileResource;
import org.apache.sling.fsprovider.internal.parser.ContentFileCache;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileResourceMapper {
    private final String providerRoot;
    private final String providerRootPrefix;
    protected final File providerFile;
    private final ContentFileExtensions contentFileExtensions;
    protected final ContentFileCache contentFileCache;
    protected final FileStatCache fileStatCache;
    private final ContentFileResourceMapper contentFileMapper;
    protected final boolean overlayParentResourceProvider;

    public FileResourceMapper(String providerRoot, File providerFile, ContentFileExtensions contentFileExtensions, ContentFileCache contentFileCache, FileStatCache fileStatCache, boolean overlayParentResourceProvider, boolean createContentFileMapper) {
        this.providerRoot = providerRoot;
        this.providerRootPrefix = providerRoot.concat("/");
        this.providerFile = providerFile;
        this.contentFileExtensions = contentFileExtensions;
        this.contentFileCache = contentFileCache;
        this.fileStatCache = fileStatCache;
        this.overlayParentResourceProvider = overlayParentResourceProvider;
        this.contentFileMapper = contentFileExtensions != null && createContentFileMapper ? new ContentFileResourceMapper(this.providerRoot, this.providerFile, contentFileExtensions, this.contentFileCache, this.fileStatCache) : null;
    }

    protected Map.Entry<Resource, Boolean> resolveResource(ResourceResolver resolver, String path) {
        boolean askParentResourceProvider = this.overlayParentResourceProvider;
        Object rsrc = null;
        File file = this.getFile(path);
        if (file != null) {
            rsrc = new FileResource(resolver, path, file, this.contentFileExtensions, this.contentFileCache, this.fileStatCache);
        } else if (this.contentFileMapper != null) {
            rsrc = this.contentFileMapper.getResource(resolver, path);
        }
        return new AbstractMap.SimpleEntry<Resource, Boolean>((Resource)rsrc, askParentResourceProvider);
    }

    protected boolean resolveChildren(ResourceResolver resolver, Resource parent, List<Iterator<? extends Resource>> allChildren) {
        Iterator<Resource> children;
        boolean askParentResourceProvider = this.overlayParentResourceProvider;
        Iterator<Resource> iterator = children = this.contentFileMapper == null ? null : this.contentFileMapper.getChildren(resolver, parent);
        if (children != null) {
            allChildren.add(children);
        }
        if ((children = this.getChildren(resolver, parent)) != null) {
            allChildren.add(children);
        }
        return askParentResourceProvider;
    }

    public Resource getResource(@NotNull ResolveContext<Object> ctx, @NotNull String path, @NotNull ResourceContext resourceContext, @Nullable Resource parent) {
        ResourceResolver resolver = ctx.getResourceResolver();
        Map.Entry<Resource, Boolean> resolved = this.resolveResource(resolver, path);
        boolean askParentResourceProvider = resolved.getValue();
        Resource rsrc = resolved.getKey();
        if (askParentResourceProvider && (rsrc == null || rsrc.getResourceMetadata().containsKey((Object)":org.apache.sling.fsprovider.file.directory"))) {
            Resource resourceFromParentResourceProvider;
            ResourceProvider rp = ctx.getParentResourceProvider();
            ResolveContext resolveContext = ctx.getParentResolveContext();
            if (rp != null && resolveContext != null && (resourceFromParentResourceProvider = rp.getResource(resolveContext, path, resourceContext, parent)) != null) {
                rsrc = resourceFromParentResourceProvider;
            }
        }
        return rsrc;
    }

    protected void addChildren(List<Iterator<? extends Resource>> allChildren, Iterator<Resource> children) {
        allChildren.add(children);
    }

    public Iterator<Resource> listChildren(@NotNull ResolveContext<Object> ctx, @NotNull Resource parent) {
        ArrayList<Iterator<? extends Resource>> allChildren;
        ResourceResolver resolver = ctx.getResourceResolver();
        boolean askParentResourceProvider = this.resolveChildren(resolver, parent, allChildren = new ArrayList<Iterator<? extends Resource>>());
        if (askParentResourceProvider) {
            Iterator children;
            ResourceProvider parentResourceProvider = ctx.getParentResourceProvider();
            ResolveContext resolveContext = ctx.getParentResolveContext();
            if (parentResourceProvider != null && resolveContext != null && (children = parentResourceProvider.listChildren(resolveContext, parent)) != null) {
                this.addChildren(allChildren, children);
            }
        }
        if (allChildren.isEmpty()) {
            return null;
        }
        if (allChildren.size() == 1) {
            return (Iterator)allChildren.get(0);
        }
        return IteratorUtils.filteredIterator((Iterator)IteratorUtils.chainedIterator(allChildren), (Predicate)new Predicate<Resource>(){
            private Set<String> names = new HashSet<String>();

            public boolean evaluate(Resource resource) {
                return this.names.add(resource.getName());
            }
        });
    }

    private Iterator<Resource> getChildren(final ResourceResolver resolver, Resource parent) {
        final String parentPath = parent.getPath();
        File parentFile = (File)parent.adaptTo(File.class);
        if (parentFile == null && (parentFile = this.getFile(parentPath)) == null) {
            String relPath;
            String parentPathPrefix;
            if (!StringUtils.startsWith((CharSequence)parentPath, (CharSequence)this.providerRoot) && this.providerRoot.startsWith(parentPathPrefix = parentPath.concat("/")) && (relPath = this.providerRoot.substring(parentPathPrefix.length())).indexOf(47) < 0) {
                FileResource res = new FileResource(resolver, this.providerRoot, this.providerFile, this.contentFileExtensions, this.contentFileCache, this.fileStatCache);
                return IteratorUtils.singletonIterator((Object)((Object)res));
            }
            return null;
        }
        Object[] files = parentFile.listFiles();
        if (files == null) {
            return null;
        }
        Arrays.sort(files, FileNameComparator.INSTANCE);
        Iterator children = IteratorUtils.filteredIterator((Iterator)IteratorUtils.arrayIterator((Object[])files), (Predicate)new Predicate<File>(){

            public boolean evaluate(File file) {
                return FileResourceMapper.this.contentFileExtensions == null || !FileResourceMapper.this.contentFileExtensions.matchesSuffix(file);
            }
        });
        if (!children.hasNext()) {
            return null;
        }
        return IteratorUtils.transformedIterator((Iterator)children, (Transformer)new Transformer<File, Resource>(){

            public Resource transform(File file) {
                String path = parentPath + "/" + Escape.fileToResourceName(file.getName());
                return new FileResource(resolver, path, file, FileResourceMapper.this.contentFileExtensions, FileResourceMapper.this.contentFileCache, FileResourceMapper.this.fileStatCache);
            }
        });
    }

    private File getFile(String path) {
        if (path.equals(this.providerRoot)) {
            return this.providerFile;
        }
        if (path.startsWith(this.providerRootPrefix)) {
            String relPath = Escape.resourceToFileName(path.substring(this.providerRootPrefix.length()));
            File file = new File(this.providerFile, relPath);
            if ((this.contentFileExtensions == null || !this.contentFileExtensions.matchesSuffix(file)) && this.fileStatCache.exists(file)) {
                return file;
            }
        }
        return null;
    }

    public String transformPath(String path) {
        return path;
    }
}

