/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.mfa;

import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.wa.MfaTrustedDevice;
import org.apache.syncope.common.rest.api.beans.MfaTrustedDeviceQuery;
import org.apache.syncope.common.rest.api.service.wa.MfaTrustStorageService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apache.syncope.wa.starter.services.WAServiceRegistry;
import org.apereo.cas.configuration.model.support.mfa.trusteddevice.TrustedDevicesMultifactorProperties;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecordKeyGenerator;
import org.apereo.cas.trusted.authentication.storage.BaseMultifactorAuthenticationTrustStorage;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WAMultifactorAuthenticationTrustStorage
extends BaseMultifactorAuthenticationTrustStorage {
    private static final Logger LOG = LoggerFactory.getLogger(WAServiceRegistry.class);
    protected static final int PAGE_SIZE = 500;
    protected final WARestClient waRestClient;

    public WAMultifactorAuthenticationTrustStorage(TrustedDevicesMultifactorProperties trustedDevicesMultifactorProperties, CipherExecutor<Serializable, String> cipherExecutor, MultifactorAuthenticationTrustRecordKeyGenerator keyGenerationStrategy, WARestClient waRestClient) {
        super(trustedDevicesMultifactorProperties, cipherExecutor, keyGenerationStrategy);
        this.waRestClient = waRestClient;
    }

    protected MultifactorAuthenticationTrustRecord saveInternal(MultifactorAuthenticationTrustRecord record) {
        MfaTrustedDevice device = new MfaTrustedDevice();
        device.setRecordKey(record.getRecordKey());
        device.setId(record.getId());
        device.setName(record.getName());
        device.setDeviceFingerprint(record.getDeviceFingerprint());
        Optional.ofNullable(record.getExpirationDate()).ifPresent(date -> device.setExpirationDate(date.toInstant().atZone(ZoneId.systemDefault())));
        device.setRecordDate(record.getRecordDate());
        LOG.trace("Saving multifactor authentication trust record [{}]", (Object)device);
        ((MfaTrustStorageService)this.waRestClient.getService(MfaTrustStorageService.class)).create(record.getPrincipal(), device);
        return record;
    }

    public void remove(ZonedDateTime expirationDate) {
        ((MfaTrustStorageService)this.waRestClient.getService(MfaTrustStorageService.class)).delete((MfaTrustedDeviceQuery)new MfaTrustedDeviceQuery.Builder().expirationDate(expirationDate.toOffsetDateTime()).build());
    }

    public void remove(String recordKey) {
        ((MfaTrustStorageService)this.waRestClient.getService(MfaTrustStorageService.class)).delete((MfaTrustedDeviceQuery)new MfaTrustedDeviceQuery.Builder().recordKey(recordKey).build());
    }

    protected MultifactorAuthenticationTrustRecord translate(MfaTrustedDevice device) {
        MultifactorAuthenticationTrustRecord record = new MultifactorAuthenticationTrustRecord();
        record.setRecordKey(device.getRecordKey());
        record.setId(device.getId());
        record.setName(device.getName());
        record.setDeviceFingerprint(device.getDeviceFingerprint());
        Optional.ofNullable(device.getExpirationDate()).ifPresent(date -> record.setExpirationDate(Date.from(date.toInstant())));
        record.setRecordDate(device.getRecordDate());
        return record;
    }

    public Set<? extends MultifactorAuthenticationTrustRecord> getAll() {
        if (!this.waRestClient.isReady()) {
            LOG.debug("Syncope client is not yet ready to fetch MFA trusted device records");
            return Set.of();
        }
        int count = ((MfaTrustStorageService)this.waRestClient.getService(MfaTrustStorageService.class)).search((MfaTrustedDeviceQuery)((MfaTrustedDeviceQuery.Builder)((MfaTrustedDeviceQuery.Builder)new MfaTrustedDeviceQuery.Builder().page(Integer.valueOf(1))).size(Integer.valueOf(0))).build()).getTotalCount();
        HashSet result = new HashSet();
        for (int page = 1; page <= count / 500 + 1; ++page) {
            ((MfaTrustStorageService)this.waRestClient.getService(MfaTrustStorageService.class)).search((MfaTrustedDeviceQuery)((MfaTrustedDeviceQuery.Builder)((MfaTrustedDeviceQuery.Builder)((MfaTrustedDeviceQuery.Builder)new MfaTrustedDeviceQuery.Builder().page(Integer.valueOf(page))).size(Integer.valueOf(500))).orderBy("expirationDate")).build()).getResult().stream().map(this::translate).forEach(result::add);
        }
        return result;
    }

    public Set<? extends MultifactorAuthenticationTrustRecord> get(ZonedDateTime onOrAfterDate) {
        if (!this.waRestClient.isReady()) {
            LOG.debug("Syncope client is not yet ready to fetch MFA trusted device records");
            return Set.of();
        }
        return ((MfaTrustStorageService)this.waRestClient.getService(MfaTrustStorageService.class)).search((MfaTrustedDeviceQuery)new MfaTrustedDeviceQuery.Builder().recordDate(onOrAfterDate.toOffsetDateTime()).build()).getResult().stream().map(this::translate).collect(Collectors.toSet());
    }

    public Set<? extends MultifactorAuthenticationTrustRecord> get(String principal) {
        if (!this.waRestClient.isReady()) {
            LOG.debug("Syncope client is not yet ready to fetch MFA trusted device records");
            return Set.of();
        }
        return ((MfaTrustStorageService)this.waRestClient.getService(MfaTrustStorageService.class)).search((MfaTrustedDeviceQuery)new MfaTrustedDeviceQuery.Builder().principal(principal).build()).getResult().stream().map(this::translate).collect(Collectors.toSet());
    }

    public MultifactorAuthenticationTrustRecord get(long id) {
        if (!this.waRestClient.isReady()) {
            LOG.debug("Syncope client is not yet ready to fetch MFA trusted device records");
            return null;
        }
        return ((MfaTrustStorageService)this.waRestClient.getService(MfaTrustStorageService.class)).search((MfaTrustedDeviceQuery)new MfaTrustedDeviceQuery.Builder().id(Long.valueOf(id)).build()).getResult().stream().findFirst().map(this::translate).orElse(null);
    }
}

