/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.action;

import lombok.Generated;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.RememberMeCredential;
import org.apereo.cas.authentication.SurrogateUsernamePasswordCredential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SurrogateInitialAuthenticationAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateInitialAuthenticationAction.class);
    private final String separator;

    protected Event doExecute(RequestContext context) throws Exception {
        UsernamePasswordCredential up = (UsernamePasswordCredential)WebUtils.getCredential((RequestContext)context, UsernamePasswordCredential.class);
        if (up == null) {
            LOGGER.debug("Provided credentials cannot be found, or are already of type [{}]", (Object)SurrogateUsernamePasswordCredential.class.getName());
            return null;
        }
        if (up.getUsername().contains(this.separator)) {
            LOGGER.debug("Credential username includes the separator [{}]. Converting to surrogate...", (Object)this.separator);
            this.convertToSurrogateCredential(context, up);
        } else {
            SurrogateInitialAuthenticationAction.convertToUsernamePasswordCredential(context, up);
        }
        return null;
    }

    private void convertToSurrogateCredential(RequestContext context, UsernamePasswordCredential up) {
        String tUsername = up.getUsername();
        String surrogateUsername = tUsername.substring(0, tUsername.indexOf(this.separator));
        String realUsername = tUsername.substring(tUsername.indexOf(this.separator) + this.separator.length());
        LOGGER.debug("Converting to surrogate credential for username [{}], surrogate username [{}]", (Object)realUsername, (Object)surrogateUsername);
        if (StringUtils.isBlank((CharSequence)surrogateUsername)) {
            up.setUsername(realUsername);
            WebUtils.putSurrogateAuthenticationRequest((RequestContext)context, (Boolean)Boolean.TRUE);
            WebUtils.putCredential((RequestContext)context, (Credential)up);
            LOGGER.debug("No surrogate username is defined; Signal webflow to request for surrogate credentials");
            return;
        }
        SurrogateUsernamePasswordCredential sc = new SurrogateUsernamePasswordCredential();
        sc.setUsername(realUsername);
        sc.setSurrogateUsername(surrogateUsername);
        sc.assignPassword(up.toPassword());
        if (up instanceof RememberMeCredential) {
            sc.setRememberMe(((RememberMeCredential)up).isRememberMe());
        }
        WebUtils.putSurrogateAuthenticationRequest((RequestContext)context, (Boolean)Boolean.FALSE);
        LOGGER.debug("Converted credential to surrogate for username [{}] and assigned it to webflow", (Object)realUsername);
        WebUtils.putCredential((RequestContext)context, (Credential)sc);
    }

    private static void convertToUsernamePasswordCredential(RequestContext context, UsernamePasswordCredential up) throws Exception {
        if (up instanceof SurrogateUsernamePasswordCredential) {
            UsernamePasswordCredential sc = new UsernamePasswordCredential();
            BeanUtils.copyProperties((Object)sc, (Object)up);
            WebUtils.putCredential((RequestContext)context, (Credential)sc);
        }
    }

    @Generated
    public SurrogateInitialAuthenticationAction(String separator) {
        this.separator = separator;
    }
}

