/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.thymeleaf.util.NumberPointType;
import org.thymeleaf.util.Validate;

public final class NumberUtils {
    public static String format(Number target, Integer minIntegerDigits, Locale locale) {
        if (target == null) {
            return null;
        }
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, NumberPointType.NONE, 0, NumberPointType.NONE, locale);
    }

    public static String format(Number target, Integer minIntegerDigits, NumberPointType thousandsPointType, Locale locale) {
        if (target == null) {
            return null;
        }
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        Validate.notNull((Object)thousandsPointType, "Thousands point type cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, thousandsPointType, 0, NumberPointType.NONE, locale);
    }

    public static String format(Number target, Integer minIntegerDigits, Integer decimalDigits, Locale locale) {
        if (target == null) {
            return null;
        }
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        Validate.notNull(decimalDigits, "Decimal digits cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, NumberPointType.NONE, decimalDigits, NumberPointType.DEFAULT, locale);
    }

    public static String format(Number target, Integer minIntegerDigits, Integer decimalDigits, NumberPointType decimalPointType, Locale locale) {
        if (target == null) {
            return null;
        }
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        Validate.notNull(decimalDigits, "Decimal digits cannot be null");
        Validate.notNull((Object)decimalPointType, "Decimal point type cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, NumberPointType.NONE, decimalDigits, decimalPointType, locale);
    }

    public static String format(Number target, Integer minIntegerDigits, NumberPointType thousandsPointType, Integer decimalDigits, Locale locale) {
        if (target == null) {
            return null;
        }
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        Validate.notNull((Object)thousandsPointType, "Thousands point type cannot be null");
        Validate.notNull(decimalDigits, "Decimal digits cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, thousandsPointType, decimalDigits, NumberPointType.DEFAULT, locale);
    }

    public static String format(Number target, Integer minIntegerDigits, NumberPointType thousandsPointType, Integer decimalDigits, NumberPointType decimalPointType, Locale locale) {
        if (target == null) {
            return null;
        }
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        Validate.notNull((Object)thousandsPointType, "Thousands point type cannot be null");
        Validate.notNull(decimalDigits, "Decimal digits cannot be null");
        Validate.notNull((Object)decimalPointType, "Decimal point type cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, thousandsPointType, decimalDigits, decimalPointType, locale);
    }

    public static Integer[] sequence(Integer from, Integer to) {
        return NumberUtils.sequence(from, to, from <= to ? 1 : -1);
    }

    public static Integer[] sequence(Integer from, Integer to, Integer step) {
        ArrayList<Integer> values;
        block5: {
            int iStep;
            int iTo;
            int iFrom;
            block4: {
                Validate.notNull(from, "Value to start the sequence from cannot be null");
                Validate.notNull(to, "Value to generate the sequence up to cannot be null");
                Validate.notNull(step, "Step to generate the sequence cannot be null");
                iFrom = from;
                iTo = to;
                iStep = step;
                if (iFrom == iTo) {
                    return new Integer[]{iFrom};
                }
                if (iStep == 0) {
                    throw new IllegalArgumentException("Cannot create sequence from " + iFrom + " to " + iTo + " with step " + iStep);
                }
                values = new ArrayList<Integer>(10);
                if (iFrom >= iTo || iStep <= 0) break block4;
                for (int i = iFrom; i <= iTo; i += iStep) {
                    values.add(i);
                }
                break block5;
            }
            if (iFrom <= iTo || iStep >= 0) break block5;
            for (int i = iFrom; i >= iTo; i += iStep) {
                values.add(i);
            }
        }
        return values.toArray(new Integer[values.size()]);
    }

    private static String formatNumber(Number target, Integer minIntegerDigits, NumberPointType thousandsPointType, Integer fractionDigits, NumberPointType decimalPointType, Locale locale) {
        Validate.notNull(fractionDigits, "Fraction digits cannot be null");
        Validate.notNull((Object)decimalPointType, "Decimal point type cannot be null");
        Validate.notNull((Object)thousandsPointType, "Thousands point type cannot be null");
        Validate.notNull(locale, "Locale cannot be null");
        if (target == null) {
            return null;
        }
        DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        format.setMinimumFractionDigits(fractionDigits);
        format.setMaximumFractionDigits(fractionDigits);
        if (minIntegerDigits != null) {
            format.setMinimumIntegerDigits(minIntegerDigits);
        }
        format.setDecimalSeparatorAlwaysShown(decimalPointType != NumberPointType.NONE && fractionDigits > 0);
        format.setGroupingUsed(thousandsPointType != NumberPointType.NONE);
        format.setDecimalFormatSymbols(NumberUtils.computeDecimalFormatSymbols(decimalPointType, thousandsPointType, locale));
        return format.format(target);
    }

    private static DecimalFormatSymbols computeDecimalFormatSymbols(NumberPointType decimalPointType, NumberPointType thousandsPointType, Locale locale) {
        Validate.notNull((Object)decimalPointType, "Decimal point type cannot be null");
        Validate.notNull((Object)thousandsPointType, "Thousands point type cannot be null");
        Validate.notNull(locale, "Locale cannot be null");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        switch (decimalPointType) {
            case POINT: {
                symbols.setDecimalSeparator('.');
                break;
            }
            case COMMA: {
                symbols.setDecimalSeparator(',');
                break;
            }
            case WHITESPACE: {
                symbols.setDecimalSeparator(' ');
                break;
            }
            case DEFAULT: {
                break;
            }
            case NONE: {
                symbols.setDecimalSeparator('?');
            }
        }
        switch (thousandsPointType) {
            case POINT: {
                symbols.setGroupingSeparator('.');
                break;
            }
            case COMMA: {
                symbols.setGroupingSeparator(',');
                break;
            }
            case WHITESPACE: {
                symbols.setGroupingSeparator(' ');
                break;
            }
            case DEFAULT: {
                break;
            }
            case NONE: {
                symbols.setGroupingSeparator('?');
            }
        }
        return symbols;
    }

    public static String formatCurrency(Number target, Locale locale) {
        Validate.notNull(locale, "Locale cannot be null");
        if (target == null) {
            return null;
        }
        NumberFormat format = NumberFormat.getCurrencyInstance(locale);
        return format.format(target);
    }

    public static String formatPercent(Number target, Integer minIntegerDigits, Integer fractionDigits, Locale locale) {
        Validate.notNull(fractionDigits, "Fraction digits cannot be null");
        Validate.notNull(locale, "Locale cannot be null");
        if (target == null) {
            return null;
        }
        NumberFormat format = NumberFormat.getPercentInstance(locale);
        format.setMinimumFractionDigits(fractionDigits);
        format.setMaximumFractionDigits(fractionDigits);
        if (minIntegerDigits != null) {
            format.setMinimumIntegerDigits(minIntegerDigits);
        }
        return format.format(target);
    }

    private NumberUtils() {
    }
}

