/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import org.thymeleaf.util.Validate;

public final class VersionUtils {
    public static VersionSpec parseVersion(String version) {
        return VersionUtils.parseVersion(version, null);
    }

    public static VersionSpec parseVersion(String version, String buildTimestamp) {
        if (version == null || version.trim().length() == 0) {
            return new VersionSpec(buildTimestamp);
        }
        try {
            Integer patch;
            Integer minor;
            int major;
            String qualifier;
            Character qualifierSeparator;
            String numVer;
            String ver = version.trim();
            int endOfNumericVersionIdx = VersionUtils.findEndOfNumericVersion(ver);
            if (endOfNumericVersionIdx < 0) {
                numVer = ver;
                qualifierSeparator = null;
                qualifier = null;
            } else {
                numVer = ver.substring(0, endOfNumericVersionIdx);
                char c = ver.charAt(endOfNumericVersionIdx);
                if (Character.isLetter(c)) {
                    qualifierSeparator = null;
                    qualifier = ver.substring(endOfNumericVersionIdx);
                } else {
                    qualifierSeparator = Character.valueOf(ver.charAt(endOfNumericVersionIdx));
                    qualifier = ver.substring(endOfNumericVersionIdx + 1);
                    if (qualifier == null || qualifier.trim().length() == 0) {
                        return new VersionSpec(buildTimestamp);
                    }
                }
            }
            int separator1Idx = numVer.indexOf(46);
            if (separator1Idx < 0) {
                major = Integer.parseInt(numVer);
                minor = null;
                patch = null;
            } else {
                major = Integer.parseInt(numVer.substring(0, separator1Idx));
                int separator2Idx = numVer.indexOf(46, separator1Idx + 1);
                if (separator2Idx < 0) {
                    minor = Integer.valueOf(numVer.substring(separator1Idx + 1));
                    patch = null;
                } else {
                    minor = Integer.valueOf(numVer.substring(separator1Idx + 1, separator2Idx));
                    patch = Integer.valueOf(numVer.substring(separator2Idx + 1));
                }
            }
            return new VersionSpec(major, minor, patch, qualifierSeparator, qualifier, buildTimestamp);
        }
        catch (Exception e) {
            return new VersionSpec(buildTimestamp);
        }
    }

    private static int findEndOfNumericVersion(CharSequence sequence) {
        int seqLen = sequence.length();
        for (int i = 0; i < seqLen; ++i) {
            char c = sequence.charAt(i);
            if (c == '.' || Character.isDigit(c)) continue;
            if (i > 1 && sequence.charAt(i - 1) == '.') {
                return i - 1;
            }
            return i;
        }
        return -1;
    }

    private VersionUtils() {
    }

    public static final class VersionSpec {
        private static final String UNKNOWN_VERSION = "UNKNOWN";
        private boolean unknown;
        private int major;
        private int minor;
        private int patch;
        private String qualifier;
        private String buildTimestamp;
        private String versionCore;
        private String version;
        private String fullVersion;

        private VersionSpec(String buildTimestamp) {
            this.unknown = true;
            this.major = 0;
            this.minor = 0;
            this.patch = 0;
            this.qualifier = null;
            this.buildTimestamp = buildTimestamp;
            this.version = this.versionCore = UNKNOWN_VERSION;
            this.fullVersion = this.buildTimestamp != null ? String.format("%s (%s)", this.version, this.buildTimestamp) : this.version;
        }

        private VersionSpec(int major, Integer minor, Integer patch, Character qualifierSeparator, String qualifier, String buildTimestamp) {
            Validate.isTrue(major >= 0, "Major version must be >= 0");
            Validate.isTrue(minor == null || minor >= 0, "Minor version must be >= 0");
            Validate.isTrue(patch == null || patch >= 0, "Patch version must be >= 0");
            Validate.isTrue(patch == null || minor != null, "Patch version present without minor");
            this.unknown = false;
            this.major = major;
            this.minor = minor != null ? minor : 0;
            this.patch = patch != null ? patch : 0;
            this.qualifier = qualifier;
            this.buildTimestamp = buildTimestamp;
            String string = patch != null ? String.format("%d.%d.%d", major, minor, patch) : (this.versionCore = minor != null ? String.format("%d.%d", major, minor) : String.valueOf(major));
            this.version = qualifier == null ? this.versionCore : (qualifierSeparator != null ? String.format("%s%c%s", this.versionCore, qualifierSeparator, qualifier) : String.format("%s%s", this.versionCore, qualifier));
            this.fullVersion = buildTimestamp != null ? String.format("%s (%s)", this.version, this.buildTimestamp) : this.version;
        }

        public boolean isUnknown() {
            return this.unknown;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }

        public boolean hasQualifier() {
            return this.qualifier != null;
        }

        public String getQualifier() {
            return this.qualifier;
        }

        public String getVersionCore() {
            return this.versionCore;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean hasBuildTimestamp() {
            return this.buildTimestamp != null;
        }

        public String getBuildTimestamp() {
            return this.buildTimestamp;
        }

        public String getFullVersion() {
            return this.fullVersion;
        }

        public boolean isAtLeast(int major) {
            return this.isAtLeast(major, 0);
        }

        public boolean isAtLeast(int major, int minor) {
            return this.isAtLeast(major, minor, 0);
        }

        public boolean isAtLeast(int major, int minor, int patch) {
            return this.major > major || this.major == major && this.minor > minor || this.major == major && this.minor == minor && this.patch >= patch;
        }
    }
}

