/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.syncope.client.console.rest.SAML2IdPEntityRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.TextEditorPanel;
import org.apache.syncope.client.console.wizards.SAML2EntityWizardBuilder;
import org.apache.syncope.common.lib.to.SAML2EntityTO;
import org.apache.syncope.common.lib.to.SAML2IdPEntityTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class SAML2IdPEntityWizardBuilder
extends SAML2EntityWizardBuilder<SAML2IdPEntityTO> {
    private static final long serialVersionUID = -8013493490328546125L;
    protected final SAML2IdPEntityRestClient saml2IdPEntityRestClient;

    public SAML2IdPEntityWizardBuilder(SAML2IdPEntityTO defaultItem, SAML2IdPEntityRestClient saml2IdPEntityRestClient, PageReference pageRef) {
        super(defaultItem, pageRef);
        this.saml2IdPEntityRestClient = saml2IdPEntityRestClient;
    }

    protected Serializable onApplyInternal(SAML2IdPEntityTO modelObject) {
        if (modelObject.getMetadata() != null) {
            modelObject.setMetadata(Base64.getEncoder().encodeToString(modelObject.getMetadata().getBytes(StandardCharsets.UTF_8)));
        }
        if (modelObject.getSigningCertificate() != null) {
            modelObject.setSigningCertificate(Base64.getEncoder().encodeToString(modelObject.getSigningCertificate().getBytes(StandardCharsets.UTF_8)));
        }
        if (modelObject.getSigningKey() != null) {
            modelObject.setSigningKey(Base64.getEncoder().encodeToString(modelObject.getSigningKey().getBytes(StandardCharsets.UTF_8)));
        }
        if (modelObject.getEncryptionCertificate() != null) {
            modelObject.setEncryptionCertificate(Base64.getEncoder().encodeToString(modelObject.getEncryptionCertificate().getBytes(StandardCharsets.UTF_8)));
        }
        if (modelObject.getEncryptionKey() != null) {
            modelObject.setEncryptionKey(Base64.getEncoder().encodeToString(modelObject.getEncryptionKey().getBytes(StandardCharsets.UTF_8)));
        }
        this.saml2IdPEntityRestClient.set(modelObject);
        return modelObject;
    }

    protected WizardModel buildModelSteps(SAML2IdPEntityTO modelObject, WizardModel wizardModel) {
        if (modelObject.getMetadata() != null) {
            modelObject.setMetadata(new String(Base64.getDecoder().decode(modelObject.getMetadata()), StandardCharsets.UTF_8));
        }
        if (modelObject.getSigningCertificate() != null) {
            modelObject.setSigningCertificate(new String(Base64.getDecoder().decode(modelObject.getSigningCertificate()), StandardCharsets.UTF_8));
        }
        if (modelObject.getSigningKey() != null) {
            modelObject.setSigningKey(new String(Base64.getDecoder().decode(modelObject.getSigningKey()), StandardCharsets.UTF_8));
        }
        if (modelObject.getEncryptionCertificate() != null) {
            modelObject.setEncryptionCertificate(new String(Base64.getDecoder().decode(modelObject.getEncryptionCertificate()), StandardCharsets.UTF_8));
        }
        if (modelObject.getEncryptionKey() != null) {
            modelObject.setEncryptionKey(new String(Base64.getDecoder().decode(modelObject.getEncryptionKey()), StandardCharsets.UTF_8));
        }
        wizardModel.add((IWizardStep)new SAML2EntityWizardBuilder.Metadata((SAML2EntityWizardBuilder)this, (SAML2EntityTO)modelObject, this.pageRef));
        wizardModel.add((IWizardStep)new TextPem(modelObject, "signingCertificate", this.pageRef));
        wizardModel.add((IWizardStep)new TextPem(modelObject, "signingKey", this.pageRef));
        wizardModel.add((IWizardStep)new TextPem(modelObject, "encryptionCertificate", this.pageRef));
        wizardModel.add((IWizardStep)new TextPem(modelObject, "encryptionKey", this.pageRef));
        return wizardModel;
    }

    protected class TextPem
    extends SAML2EntityWizardBuilder.Pem {
        private static final long serialVersionUID = 1L;

        public TextPem(SAML2IdPEntityTO entity, String property, PageReference pageRef) {
            super(property);
            this.add(new Component[]{new TextEditorPanel(null, (IModel)new PropertyModel((Object)entity, property), false, pageRef)});
        }
    }
}

