/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.encoder.httpclient;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.encoder.httpclient.AbstractHttpClientRequestMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseHttpClientRequestXMLMessageEncoder
extends AbstractHttpClientRequestMessageEncoder {
    @Nonnull
    private Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseHttpClientRequestXMLMessageEncoder.class);

    @Override
    public void encode() throws MessageEncodingException {
        if (this.log.isDebugEnabled() && this.getMessageContext().getMessage() != null) {
            this.log.debug("Beginning encode of message of type: {}", (Object)this.getMessageContext().getMessage().getClass().getName());
        }
        super.encode();
        this.logEncodedMessage();
        this.log.debug("Successfully encoded message.");
    }

    protected void logEncodedMessage() {
        if (this.protocolMessageLog.isDebugEnabled()) {
            Object message = this.getMessageToLog();
            if (message == null || !(message instanceof XMLObject)) {
                this.log.warn("Encoded message was null or unsupported, nothing to log");
                return;
            }
            try {
                Element dom = XMLObjectSupport.marshall((XMLObject)((XMLObject)message));
                this.protocolMessageLog.debug("\n" + SerializeSupport.prettyPrintXML((Node)dom));
            }
            catch (MarshallingException e) {
                this.log.error("Unable to marshall message for logging purposes", (Throwable)e);
            }
        }
    }

    @Nullable
    protected Object getMessageToLog() {
        return this.getMessageContext().getMessage();
    }

    @Nonnull
    protected Element marshallMessage(@Nonnull XMLObject message) throws MessageEncodingException {
        this.log.debug("Marshalling message");
        try {
            return XMLObjectSupport.marshall((XMLObject)message);
        }
        catch (MarshallingException e) {
            this.log.error("Error marshalling message: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Error marshalling message", (Exception)((Object)e));
        }
    }
}

