/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.image;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Components;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class IconBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final IModel<IconType> type;
    private final IModel<String> value;

    public IconBehavior(IconType type) {
        this((IModel<IconType>)Model.of((Serializable)((Object)type)));
    }

    public IconBehavior(IModel<IconType> type) {
        this.type = type;
        this.value = Model.of((Serializable)((Object)""));
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Components.assertTag(component, tag, "i", "span");
        Attributes.addClass(tag, (String)this.value.getObject());
    }

    public void onConfigure(Component component) {
        super.onConfigure(component);
        if (this.hasIconType()) {
            this.value.setObject((Object)((IconType)this.type.getObject()).cssClassName());
        } else {
            this.value.setObject((Object)"");
            component.setVisible(false);
        }
    }

    public final boolean hasIconType() {
        return this.type != null && this.type.getObject() != null;
    }

    public final IconBehavior setType(IconType iconType) {
        this.type.setObject((Object)iconType);
        return this;
    }

    public final IconType type() {
        return (IconType)this.type.getObject();
    }

    public void detach(Component component) {
        super.detach(component);
        this.type.detach();
        this.value.detach();
    }
}

