/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.saml2;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.opensaml.core.xml.XMLObject;
import org.pac4j.core.client.Clients;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="delegatedSaml2ClientMetadataController")
@RequestMapping
public class DelegatedSaml2ClientMetadataController {
    private final Clients builtClients;
    private final OpenSamlConfigBean openSamlConfigBean;

    private static ResponseEntity<String> getSaml2ClientServiceProviderMetadataResponseEntity(SAML2Client saml2Client) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        saml2Client.init();
        String md = saml2Client.getSpMetadataResolver().getMetadata();
        return new ResponseEntity((Object)md, (MultiValueMap)headers, HttpStatus.OK);
    }

    private static ResponseEntity<String> getNotAcceptableResponseEntity() {
        return new ResponseEntity(HttpStatus.NOT_ACCEPTABLE);
    }

    @GetMapping(value={"/sp/metadata"})
    public ResponseEntity<String> getFirstServiceProviderMetadata() {
        Optional<SAML2Client> saml2Client = this.builtClients.getClients().stream().filter(client -> client instanceof SAML2Client).map(SAML2Client.class::cast).findFirst();
        return saml2Client.map(DelegatedSaml2ClientMetadataController::getSaml2ClientServiceProviderMetadataResponseEntity).orElseGet(DelegatedSaml2ClientMetadataController::getNotAcceptableResponseEntity);
    }

    @GetMapping(value={"/sp/idp/metadata"})
    public ResponseEntity<String> getFirstIdentityProviderMetadata(@RequestParam(value="force", defaultValue="false", required=false) boolean force) {
        Optional<SAML2Client> saml2Client = this.builtClients.getClients().stream().filter(client -> client instanceof SAML2Client).map(SAML2Client.class::cast).findFirst();
        return saml2Client.map(client -> this.getSaml2ClientIdentityProviderMetadataResponseEntity((SAML2Client)client, force)).orElseGet(DelegatedSaml2ClientMetadataController::getNotAcceptableResponseEntity);
    }

    @GetMapping(value={"/sp/{client}/metadata"})
    public ResponseEntity<String> getServiceProviderMetadataByName(@PathVariable(value="client") String client) {
        Optional saml2Client = this.builtClients.findClient(client);
        return saml2Client.map(value -> DelegatedSaml2ClientMetadataController.getSaml2ClientServiceProviderMetadataResponseEntity((SAML2Client)SAML2Client.class.cast(value))).orElseGet(DelegatedSaml2ClientMetadataController::getNotAcceptableResponseEntity);
    }

    @GetMapping(value={"/sp/{client}/idp/metadata"})
    public ResponseEntity<String> getIdentityProviderMetadataByName(@PathVariable(value="client") String client, @RequestParam(value="force", defaultValue="false", required=false) boolean force) {
        Optional saml2Client = this.builtClients.findClient(client);
        return saml2Client.map(value -> this.getSaml2ClientIdentityProviderMetadataResponseEntity((SAML2Client)SAML2Client.class.cast(value), force)).orElseGet(DelegatedSaml2ClientMetadataController::getNotAcceptableResponseEntity);
    }

    private ResponseEntity<String> getSaml2ClientIdentityProviderMetadataResponseEntity(SAML2Client saml2Client, boolean force) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        saml2Client.init();
        SAML2MetadataResolver identityProviderMetadataResolver = saml2Client.getIdentityProviderMetadataResolver();
        identityProviderMetadataResolver.resolve(force);
        XMLObject entity = identityProviderMetadataResolver.getEntityDescriptorElement();
        String metadata = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.openSamlConfigBean, (XMLObject)entity).toString();
        return new ResponseEntity((Object)metadata, (MultiValueMap)headers, HttpStatus.OK);
    }

    @Generated
    public DelegatedSaml2ClientMetadataController(Clients builtClients, OpenSamlConfigBean openSamlConfigBean) {
        this.builtClients = builtClients;
        this.openSamlConfigBean = openSamlConfigBean;
    }
}

