/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;

public class LogOutputStream
extends OutputStream
implements AutoCloseable {
    private static final int INTIAL_SIZE = 132;
    private static final int CR = 13;
    private static final int LF = 10;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(132);
    private final Logger logger;
    private boolean skip = false;

    public LogOutputStream(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void write(int cc) {
        byte c = (byte)cc;
        if (c == 10 || c == 13) {
            if (!this.skip) {
                this.processBuffer();
            }
        } else {
            this.buffer.write(cc);
        }
        this.skip = c == 13;
    }

    @Override
    public void flush() {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
        super.close();
    }

    @Override
    public void write(byte[] b, int off, int len) {
        int offset;
        int blockStartOffset = offset = off;
        int remaining = len;
        while (remaining > 0) {
            while (remaining > 0 && b[offset] != 10 && b[offset] != 13) {
                ++offset;
                --remaining;
            }
            int blockLength = offset - blockStartOffset;
            if (blockLength > 0) {
                this.buffer.write(b, blockStartOffset, blockLength);
            }
            while (remaining > 0 && (b[offset] == 10 || b[offset] == 13)) {
                this.write(b[offset]);
                ++offset;
                --remaining;
            }
            blockStartOffset = offset;
        }
    }

    private void processBuffer() {
        this.logger.debug(this.buffer.toString());
        this.buffer.reset();
    }
}

